/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.swingdsl.miglayout.patched;

import com.github.weisj.swingdsl.laf.VisualPaddingProvider;
import com.github.weisj.swingdsl.miglayout.patched.SwingComponentWrapperKt;
import com.github.weisj.swingdsl.miglayout.patched.SwingContainerWrapper;
import com.github.weisj.swingdsl.miglayout.patched.ThreeState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.PlatformDefaults;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010'\u001a\u00020\u000fH\u0016J\b\u0010(\u001a\u00020\u000fH\u0016J\b\u0010)\u001a\u00020\u000fH\u0016J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\n\u0010,\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u00020\bH\u0016J\b\u00101\u001a\u00020\u000fH\u0016J\b\u00102\u001a\u00020\bH\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\bH\u0016J(\u00106\u001a\u0002042\u0006\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/github/weisj/swingdsl/miglayout/patched/SwingComponentWrapper;", "Lnet/miginfocom/layout/ComponentWrapper;", "c", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "hasBaseLine", "Lcom/github/weisj/swingdsl/miglayout/patched/ThreeState;", "isPrefCalled", "", "visualPaddings", "", "equals", "other", "", "getBaseline", "", "width", "height", "getComponent", "getComponentType", "disregardScrollPane", "getContentBias", "getHeight", "getHorizontalScreenDPI", "getLayoutHashCode", "getLinkId", "", "getMaximumHeight", "sz", "getMaximumWidth", "getMinimumHeight", "getMinimumWidth", "getParent", "Lnet/miginfocom/layout/ContainerWrapper;", "getPixelUnitFactor", "", "isHor", "getPreferredHeight", "getPreferredWidth", "getScreenHeight", "getScreenLocationX", "getScreenLocationY", "getScreenWidth", "getVerticalScreenDPI", "getVisualPadding", "getWidth", "getX", "getY", "hasBaseline", "hashCode", "isVisible", "paintDebugOutline", "", "showVisualPadding", "setBounds", "x", "y", "unwrapBorder", "Ljavax/swing/border/Border;", "border", "swing-dsl"})
public class SwingComponentWrapper
implements ComponentWrapper {
    private ThreeState hasBaseLine;
    private boolean isPrefCalled;
    private int[] visualPaddings;
    private final JComponent c;

    public int getBaseline(int width, int height) {
        int h = height;
        int[] visualPaddings = this.getVisualPadding();
        if (h < 0) {
            h = this.c.getHeight();
        } else if (visualPaddings != null) {
            h = height + visualPaddings[0] + visualPaddings[2];
        }
        int baseLine = this.c.getBaseline(width < 0 ? this.c.getWidth() : width, h);
        if (baseLine != -1 && visualPaddings != null) {
            baseLine -= visualPaddings[0];
        }
        return baseLine;
    }

    @NotNull
    public JComponent getComponent() {
        return this.c;
    }

    public float getPixelUnitFactor(boolean isHor) {
        throw (Throwable)new RuntimeException("Do not use LPX/LPY");
    }

    public int getX() {
        return this.c.getX();
    }

    public int getY() {
        return this.c.getY();
    }

    public int getHeight() {
        return this.c.getHeight();
    }

    public int getWidth() {
        return this.c.getWidth();
    }

    public int getScreenLocationX() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.x;
    }

    public int getScreenLocationY() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.y;
    }

    public int getMinimumHeight(int sz) {
        if (!this.isPrefCalled) {
            this.c.getPreferredSize();
            this.isPrefCalled = true;
        }
        return this.c.getMinimumSize().height;
    }

    public int getMinimumWidth(int sz) {
        if (!this.isPrefCalled) {
            this.c.getPreferredSize();
            this.isPrefCalled = true;
        }
        return this.c.getMinimumSize().width;
    }

    public int getPreferredHeight(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), sz, 1);
        }
        return this.c.getPreferredSize().height;
    }

    public int getPreferredWidth(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), 1, sz);
        }
        return this.c.getPreferredSize().width;
    }

    public int getMaximumHeight(int sz) {
        return this.c.isMaximumSizeSet() ? this.c.getMaximumSize().height : Integer.MAX_VALUE;
    }

    public int getMaximumWidth(int sz) {
        return this.c.isMaximumSizeSet() ? this.c.getMaximumSize().width : Integer.MAX_VALUE;
    }

    @Nullable
    public ContainerWrapper getParent() {
        Container container = this.c.getParent();
        if (!(container instanceof JComponent)) {
            container = null;
        }
        JComponent jComponent = (JComponent)container;
        if (jComponent == null) {
            return null;
        }
        JComponent p = jComponent;
        return new SwingContainerWrapper(p);
    }

    public int getHorizontalScreenDPI() {
        int n;
        try {
            Toolkit toolkit = this.c.getToolkit();
            Intrinsics.checkExpressionValueIsNotNull((Object)toolkit, (String)"c.toolkit");
            n = toolkit.getScreenResolution();
        }
        catch (HeadlessException e) {
            n = PlatformDefaults.getDefaultDPI();
        }
        return n;
    }

    public int getVerticalScreenDPI() {
        int n;
        try {
            Toolkit toolkit = this.c.getToolkit();
            Intrinsics.checkExpressionValueIsNotNull((Object)toolkit, (String)"c.toolkit");
            n = toolkit.getScreenResolution();
        }
        catch (HeadlessException e) {
            n = PlatformDefaults.getDefaultDPI();
        }
        return n;
    }

    public int getScreenWidth() {
        int n;
        try {
            Toolkit toolkit = this.c.getToolkit();
            Intrinsics.checkExpressionValueIsNotNull((Object)toolkit, (String)"c.toolkit");
            n = toolkit.getScreenSize().width;
        }
        catch (HeadlessException ignore) {
            n = 1024;
        }
        return n;
    }

    public int getScreenHeight() {
        int n;
        try {
            Toolkit toolkit = this.c.getToolkit();
            Intrinsics.checkExpressionValueIsNotNull((Object)toolkit, (String)"c.toolkit");
            n = toolkit.getScreenSize().height;
        }
        catch (HeadlessException ignore) {
            n = 768;
        }
        return n;
    }

    public boolean hasBaseline() {
        if (this.hasBaseLine == ThreeState.UNSURE) {
            ThreeState threeState;
            SwingComponentWrapper swingComponentWrapper;
            SwingComponentWrapper swingComponentWrapper2 = this;
            try {
                swingComponentWrapper = swingComponentWrapper2;
                threeState = ThreeState.Companion.fromBoolean(this.getBaseline(8192, 8192) > -1);
            }
            catch (Throwable ignore) {
                swingComponentWrapper = swingComponentWrapper2;
                threeState = ThreeState.NO;
            }
            swingComponentWrapper.hasBaseLine = threeState;
        }
        return this.hasBaseLine.toBoolean();
    }

    @Nullable
    public String getLinkId() {
        return this.c.getName();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.c.setBounds(x, y, width, height);
    }

    public boolean isVisible() {
        return this.c.isVisible();
    }

    @Nullable
    public int[] getVisualPadding() {
        Insets insets;
        if (this.visualPaddings != null) {
            int[] nArray = this.visualPaddings;
            boolean bl = false;
            boolean bl2 = false;
            int[] it = nArray;
            boolean bl3 = false;
            return it;
        }
        JComponent component = this.c;
        Border border = component.getBorder();
        if (border == null) {
            return null;
        }
        Border border2 = border;
        if (border2 instanceof LineBorder || border2 instanceof TitledBorder) {
            return null;
        }
        Border unwrapped = this.unwrapBorder(border2);
        if (unwrapped instanceof VisualPaddingProvider) {
            insets = ((VisualPaddingProvider)unwrapped).getVisualPaddings((Component)this.c);
        } else {
            Object object = this.c.getClientProperty("visualPadding");
            if (!(object instanceof Insets)) {
                object = null;
            }
            insets = (Insets)object;
        }
        if (insets == null) {
            return null;
        }
        Insets paddings = insets;
        if (paddings.top == 0 && paddings.left == 0 && paddings.bottom == 0 && paddings.right == 0) {
            return null;
        }
        this.visualPaddings = new int[]{paddings.top, paddings.left, paddings.bottom, paddings.right};
        return this.visualPaddings;
    }

    public void paintDebugOutline(boolean showVisualPadding) {
        int[] padding;
        if (!this.c.isShowing()) {
            return;
        }
        Graphics graphics = this.c.getGraphics();
        if (!(graphics instanceof Graphics2D)) {
            graphics = null;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g = graphics2D;
        g.setPaint(SwingComponentWrapperKt.access$getDB_COMP_OUTLINE$p());
        g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 4.0f}, 0.0f));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (showVisualPadding && (padding = this.getVisualPadding()) != null) {
            g.setColor(Color.GREEN);
            g.drawRect(padding[1], padding[0], this.getWidth() - 1 - (padding[1] + padding[3]), this.getHeight() - 1 - (padding[0] + padding[2]));
        }
    }

    public int getComponentType(boolean disregardScrollPane) {
        throw (Throwable)new RuntimeException("Should be not called and used");
    }

    public int getLayoutHashCode() {
        int hash;
        block1: {
            Dimension d = this.c.getMaximumSize();
            hash = d.width + (d.height << 5);
            d = this.c.getPreferredSize();
            hash += (d.width << 10) + (d.height << 15);
            d = this.c.getMinimumSize();
            hash += (d.width << 20) + (d.height << 25);
            if (this.c.isVisible()) {
                hash += 1324511;
            }
            String string = this.getLinkId();
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            hash += it.hashCode();
        }
        return hash;
    }

    public int hashCode() {
        return this.getComponent().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ComponentWrapper && Intrinsics.areEqual((Object)this.c, (Object)((ComponentWrapper)other).getComponent());
    }

    public int getContentBias() {
        return this.c instanceof JTextArea || this.c instanceof JEditorPane || Intrinsics.areEqual((Object)Boolean.TRUE, (Object)this.c.getClientProperty("migLayout.dynamicAspectRatio")) ? 0 : -1;
    }

    private final Border unwrapBorder(Border border) {
        Border b = border;
        while (b instanceof CompoundBorder) {
            Intrinsics.checkExpressionValueIsNotNull((Object)((CompoundBorder)b).getOutsideBorder(), (String)"b.outsideBorder");
        }
        return b;
    }

    public SwingComponentWrapper(@NotNull JComponent c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.c = c;
        this.hasBaseLine = ThreeState.UNSURE;
    }
}

