/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.nativeutil.AbstractLibrary;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.util.LogUtil;

public class MacOSLibrary
extends AbstractLibrary {
    private static final String PATH = "/com/github/weisj/darklaf/platform/darklaf-macos";
    private static final String x86_64_PATH = "/com/github/weisj/darklaf/platform/darklaf-macos/libdarklaf-macos-x86-64.dylib";
    private static final String arm64_PATH = "/com/github/weisj/darklaf/platform/darklaf-macos/libdarklaf-macos-arm64.dylib";
    private static final MacOSLibrary instance = new MacOSLibrary();

    public static MacOSLibrary get() {
        return instance;
    }

    protected MacOSLibrary() {
        super("darklaf-macos", LogUtil.getLogger(MacOSLibrary.class));
    }

    protected String getArm64Path() {
        return arm64_PATH;
    }

    protected String getX64Path() {
        return x86_64_PATH;
    }

    protected final Class<?> getLoaderClass() {
        return MacOSLibrary.class;
    }

    public String getLibraryPath() {
        if (SystemInfo.isX86Compatible && SystemInfo.isX64) {
            return this.getX64Path();
        }
        if (SystemInfo.isM1) {
            return this.getArm64Path();
        }
        throw new IllegalStateException("Unsupported arch");
    }

    protected boolean canLoad() {
        return (SystemInfo.isX86Compatible && SystemInfo.isX64 || SystemInfo.isM1) && SystemInfo.isMacOSYosemite;
    }
}

