/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos.ui;

import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.macos.JNIDecorationsMacOS;
import com.github.weisj.darklaf.platform.macos.ui.DecorationInformation;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class MacOSDecorationsUtil {
    private static final Logger LOGGER = LogUtil.getLogger(MacOSDecorationsUtil.class);
    private static final String FULL_WINDOW_CONTENT_KEY = "apple.awt.fullWindowContent";
    static final String TRANSPARENT_TITLE_BAR_KEY = "apple.awt.transparentTitleBar";

    static DecorationInformation installDecorations(JRootPane rootPane, boolean useColoredTitleBar) {
        if (rootPane == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        long windowHandle = JNIDecorationsMacOS.getComponentPointer(window);
        if (windowHandle == 0L) {
            return new DecorationInformation(0L, false, rootPane, false, 0, 0.0f);
        }
        Rectangle windowBounds = window.getBounds();
        LOGGER.fine("Installing decorations for window " + windowHandle + "(coloredTitleBar = " + useColoredTitleBar + ")");
        JNIDecorationsMacOS.retainWindow(windowHandle);
        float titleFontSize = (float)JNIDecorationsMacOS.getTitleFontSize(windowHandle);
        int titleBarHeight = (int)JNIDecorationsMacOS.getTitleBarHeight(windowHandle);
        MacOSDecorationsUtil.setFullSizeContent(windowHandle, useColoredTitleBar);
        boolean titleVisible = SystemInfo.isMacOSMojave && !UIManager.getBoolean("Theme.macos.useSwingTitleLabel");
        MacOSDecorationsUtil.setTitleVisible(windowHandle, titleVisible);
        if (titleVisible) {
            boolean isDarkTheme = UIManager.getBoolean("Theme.dark");
            JNIDecorationsMacOS.setDarkTheme(windowHandle, isDarkTheme);
        }
        window.setBounds(windowBounds);
        return new DecorationInformation(windowHandle, useColoredTitleBar, rootPane, titleVisible, titleBarHeight, titleFontSize);
    }

    private static void setFullSizeContent(long windowHandle, boolean enabled) {
        if (enabled) {
            JNIDecorationsMacOS.installDecorations(windowHandle);
        }
    }

    static void uninstallDecorations(Window window, DecorationInformation information) {
        if (information == null || information.windowHandle == 0L) {
            return;
        }
        if (information.useColoredTitleBar) {
            Rectangle bounds = window.getBounds();
            JNIDecorationsMacOS.uninstallDecorations(information.windowHandle, MacOSDecorationsUtil.isFullWindowContentEnabled(information.rootPane), MacOSDecorationsUtil.isTransparentTitleBarEnabled(information.rootPane));
            window.setBounds(bounds);
        }
        MacOSDecorationsUtil.setTitleVisible(information, true);
        JNIDecorationsMacOS.releaseWindow(information.windowHandle);
    }

    private static boolean isFullWindowContentEnabled(JRootPane rootPane) {
        return PropertyUtil.getBooleanProperty((JComponent)rootPane, (String)FULL_WINDOW_CONTENT_KEY);
    }

    static boolean isTransparentTitleBarEnabled(JRootPane rootPane) {
        return PropertyUtil.getBooleanProperty((JComponent)rootPane, (String)TRANSPARENT_TITLE_BAR_KEY);
    }

    static void setTitleVisible(DecorationInformation decorationInformation, boolean visible) {
        if (decorationInformation == null) {
            return;
        }
        MacOSDecorationsUtil.setTitleVisible(decorationInformation.windowHandle, visible);
    }

    private static void setTitleVisible(long windowHandle, boolean visible) {
        JNIDecorationsMacOS.setTitleEnabled(windowHandle, visible);
    }
}

