/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Apps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import jmri.Application;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.JmrixConfigPane;
import jmri.swing.ManagingPreferencesPanel;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfigBase
extends JmriPanel {
    protected HashMap<String, PreferencesPanel> preferencesPanels = new HashMap();
    protected static final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsConfigBundle");
    private static final Logger log = LoggerFactory.getLogger(AppConfigBase.class);

    private boolean checkDups() {
        ConnectionConfig[] connections;
        HashMap ports = new HashMap();
        for (ConnectionConfig connection : connections = InstanceManager.getDefault(ConnectionConfigManager.class).getConnections()) {
            String port;
            if (connection.getDisabled() || (port = connection.getInfo()).equals(JmrixConfigPane.NONE)) continue;
            if (!ports.containsKey(port)) {
                ArrayList<ConnectionConfig> arg1 = new ArrayList<ConnectionConfig>();
                arg1.add(connection);
                ports.put(port, arg1);
                continue;
            }
            ((List)ports.get(port)).add(connection);
        }
        boolean ret = true;
        for (Map.Entry e : ports.entrySet()) {
            if (((List)e.getValue()).size() <= 1) continue;
            ret = false;
            StringBuilder nameB = new StringBuilder();
            for (int n = 0; n < ((List)e.getValue()).size(); ++n) {
                nameB.append(((ConnectionConfig)((List)e.getValue()).get(n)).getManufacturer());
                nameB.append("|");
            }
            String instanceNames = new String(nameB);
            instanceNames = instanceNames.substring(0, instanceNames.lastIndexOf("|"));
            instanceNames = instanceNames.replaceAll("[|]", ", ");
            log.error("Duplicate ports found on: {} for port: {}", (Object)instanceNames, e.getKey());
        }
        return ret;
    }

    private boolean checkPortNames() {
        for (ConnectionConfig connection : InstanceManager.getDefault(ConnectionConfigManager.class).getConnections()) {
            String port = connection.getInfo();
            if (!port.equals(JmrixConfigPane.NONE_SELECTED) && !port.equals(JmrixConfigPane.NO_PORTS_FOUND) || 0 == JmriJOptionPane.showConfirmDialog(null, MessageFormat.format(rb.getString("MessageSerialPortWarning"), port, connection.getConnectionName()), rb.getString("MessageSerialPortNotValid"), 0, 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.preferencesPanels.clear();
    }

    public void saveContents() {
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.removePrefItems();
        }
        this.getPreferencesPanels().values().stream().forEach(panel -> this.registerWithConfigureManager((PreferencesPanel)panel));
        if (cm != null) {
            cm.storePrefs();
        }
    }

    private void registerWithConfigureManager(PreferencesPanel panel) {
        ConfigureManager cm;
        if (panel.isPersistant() && (cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cm.registerPref(panel);
        }
        if (panel instanceof ManagingPreferencesPanel) {
            log.debug("Iterating over managed panels within {}/{}", (Object)panel.getPreferencesItemText(), (Object)panel.getTabbedPreferencesTitle());
            ((ManagingPreferencesPanel)panel).getPreferencesPanels().stream().forEach(managed -> {
                log.debug("Registering {} with the ConfigureManager", (Object)managed.getClass().getName());
                this.registerWithConfigureManager((PreferencesPanel)managed);
            });
        }
    }

    public void savePressed(boolean restartRequired) {
        if (!this.checkPortNames()) {
            return;
        }
        if (!this.checkDups() && JmriJOptionPane.showConfirmDialog(null, rb.getString("MessageLongDupsWarning"), rb.getString("MessageShortDupsWarning"), 0) != 0) {
            return;
        }
        this.saveContents();
        UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        p.resetChangeMade();
        if (restartRequired && !InstanceManager.getDefault(ShutDownManager.class).isShuttingDown()) {
            JLabel question = new JLabel(MessageFormat.format(rb.getString("MessageLongQuitWarning"), Application.getApplicationName()));
            Object[] options = new Object[]{rb.getString("RestartNow"), rb.getString("RestartLater")};
            int retVal = JmriJOptionPane.showOptionDialog(this, question, MessageFormat.format(rb.getString("MessageShortQuitWarning"), Application.getApplicationName()), -1, 3, null, options, null);
            switch (retVal) {
                case 0: {
                    this.dispose();
                    Apps.handleRestart();
                    break;
                }
            }
        }
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().setVisible(false);
        }
    }

    public String getClassDescription() {
        return rb.getString("Application");
    }

    public String getClassName() {
        return AppConfigBase.class.getName();
    }

    public HashMap<String, PreferencesPanel> getPreferencesPanels() {
        return this.preferencesPanels;
    }
}

