/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.AppsConfigurationManager;
import apps.AppsPreferencesActionFactory;
import apps.Bundle;
import apps.CreateButtonModel;
import apps.gui3.tabbedpreferences.TabbedPreferences;
import apps.util.Log4JUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import jmri.Application;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LogixManager;
import jmri.PermissionManager;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.Version;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.revhistory.FileHistory;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.prefs.JmriPreferencesActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppsBase {
    private static final String CONFIG_FILENAME = System.getProperty("org.jmri.Apps.configFilename", "/JmriConfig3.xml");
    protected boolean configOK;
    protected boolean configDeferredLoadOK;
    protected boolean preferenceFileExists;
    static boolean preInit = false;
    private static final Logger log = LoggerFactory.getLogger(AppsBase.class);

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Info String always needs to be evaluated")
    public static void preInit(String applicationName) {
        Log4JUtil.initLogging();
        try {
            Application.setApplicationName(applicationName);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            log.error("Unable to set application name", (Throwable)ex);
        }
        log.info(Log4JUtil.startupInfo(applicationName));
        preInit = true;
    }

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="The thread is only called to help improve user experiance when opening the preferences, it is not critical for it to be run at this stage")
    public AppsBase(String applicationName, String configFileDef, String[] args) {
        if (!preInit) {
            AppsBase.preInit(applicationName);
            AppsBase.setConfigFilename(configFileDef, args);
        }
        Log4JUtil.initLogging();
        this.configureProfile();
        this.installConfigurationManager();
        this.installManagers();
        this.setAndLoadPreferenceFile();
        FileUtil.logFilePaths();
        if (Boolean.getBoolean("org.jmri.python.preload")) {
            new Thread(() -> {
                try {
                    JmriScriptEngineManager.getDefault().initializeAllEngines();
                }
                catch (Exception ex) {
                    log.error("Error initializing python interpreter", (Throwable)ex);
                }
            }, "initialize python interpreter").start();
        }
        InstanceManager.getDefault(LogixManager.class).activateAllLogixs();
        InstanceManager.getDefault(LayoutBlockManager.class).initializeLayoutBlockPaths();
        LogixNG_Manager logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
        logixNG_Manager.setupAllLogixNGs();
        if (InstanceManager.getDefault(LogixNGPreferences.class).getStartLogixNGOnStartup() && InstanceManager.getDefault(LogixNG_Manager.class).isStartLogixNGsOnLoad()) {
            logixNG_Manager.activateAllLogixNGs();
        }
    }

    protected void configureProfile() {
        FileUtil.createDirectory(FileUtil.getPreferencesPath());
        InstanceManager.getDefault(PermissionManager.class);
        String profileFilename = AppsBase.getConfigFileName().replaceFirst(".xml", ".properties");
        File profileFile = !new File(profileFilename).isAbsolute() ? new File(FileUtil.getPreferencesPath() + profileFilename) : new File(profileFilename);
        ProfileManager.getDefault().setConfigFile(profileFile);
        if (System.getProperties().containsKey("org.jmri.profile")) {
            ProfileManager.getDefault().setActiveProfile(System.getProperty("org.jmri.profile"));
        }
        if (!profileFile.exists()) {
            try {
                if (ProfileManager.getDefault().migrateToProfiles(AppsBase.getConfigFileName())) {
                    log.info("Migrated {}", (Object)Bundle.getMessage("ConfigMigratedToProfile"));
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                log.error("Profiles not configurable. Using fallback per-application configuration. Error: {}", (Object)ex.getMessage());
            }
        }
        try {
            if (ProfileManager.getStartingProfile() != null) {
                System.setProperty("org.jmri.Apps.configFilename", "ProfileConfig.xml");
                Profile profile = ProfileManager.getDefault().getActiveProfile();
                if (profile != null) {
                    log.info("Starting with profile {}", (Object)profile.getId());
                } else {
                    log.info("Starting without a profile");
                }
            } else {
                log.error("Specify profile to use as command line argument.");
                log.error("If starting with saved profile configuration, ensure the autoStart property is set to \"true\"");
                log.error("Profiles not configurable. Using fallback per-application configuration.");
            }
        }
        catch (IOException ex) {
            log.info("Profiles not configurable. Using fallback per-application configuration. Error: {}", (Object)ex.getMessage());
        }
    }

    protected void installConfigurationManager() {
        InstanceManager.store(new AppsPreferencesActionFactory(), JmriPreferencesActionFactory.class);
        AppsConfigurationManager cm = new AppsConfigurationManager();
        FileUtil.createDirectory(FileUtil.getUserFilesPath());
        InstanceManager.store(cm, ConfigureManager.class);
        InstanceManager.setDefault(ConfigureManager.class, cm);
        log.debug("config manager installed");
    }

    protected void installManagers() {
        String appString = String.format("%s (v%s)", Application.getApplicationName(), Version.getCanonicalVersion());
        InstanceManager.getDefault(FileHistory.class).addOperation("app", appString, null);
        InstanceManager.store(new CreateButtonModel(), CreateButtonModel.class);
    }

    protected void setAndLoadPreferenceFile() {
        File file;
        FileUtil.createDirectory(FileUtil.getUserFilesPath());
        File sharedConfig = null;
        try {
            sharedConfig = FileUtil.getFile("profile:profile/profile.xml");
            if (!sharedConfig.canRead()) {
                sharedConfig = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (sharedConfig != null) {
            file = sharedConfig;
            log.trace("Try preferences from sharedConfig {}", (Object)file.getPath());
        } else if (!new File(AppsBase.getConfigFileName()).isAbsolute()) {
            file = new File(FileUtil.getUserFilesPath() + AppsBase.getConfigFileName());
            log.trace("Try references from getUserFilesPath {}", (Object)file.getPath());
        } else {
            file = new File(AppsBase.getConfigFileName());
            log.trace("Try references from getConfigFileName {}", (Object)file.getPath());
        }
        if (!file.exists()) {
            this.preferenceFileExists = false;
            this.configOK = false;
            log.info("No pre-existing config file found, searched for '{}'", (Object)file.getPath());
            return;
        }
        log.debug("Found preferences file '{}'", (Object)file.getPath());
        this.preferenceFileExists = true;
        ThreadingUtil.runOnGUI(() -> InstanceManager.getDefault(UserPreferencesManager.class));
        try {
            ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
            this.configOK = cm != null ? cm.load(file) : false;
            log.debug("end load config file {}, OK={}", (Object)file.getName(), (Object)this.configOK);
        }
        catch (JmriException e) {
            this.configOK = false;
        }
        if (sharedConfig != null) {
            this.configDeferredLoadOK = true;
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.configDeferredLoadOK = this.doDeferredLoad(file);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.configDeferredLoadOK = this.doDeferredLoad(file);
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                log.error("Exception creating system console frame:", (Throwable)ex);
            }
        }
        if (sharedConfig == null && this.configOK && this.configDeferredLoadOK) {
            log.info("Migrating preferences to new format...");
            InstanceManager.getOptionalDefault(TabbedPreferences.class).ifPresent(tp -> {
                tp.saveContents();
                InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.storePrefs());
                log.info("Preferences have been migrated to new format.");
                log.info("New preferences format will be used after JMRI is restarted.");
            });
        }
    }

    private boolean doDeferredLoad(File file) {
        boolean result;
        log.debug("start deferred load from config file {}", (Object)file.getName());
        try {
            ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cm != null) {
                result = cm.loadDeferred(file);
            } else {
                log.error("Failed to get default configure manager");
                result = false;
            }
        }
        catch (JmriException e) {
            log.error("Unhandled problem loading deferred configuration:", (Throwable)e);
            result = false;
        }
        log.debug("end deferred load from config file {}, OK={}", (Object)file.getName(), (Object)result);
        return result;
    }

    protected void start() {
        log.debug("main initialization done");
    }

    protected static void setConfigFilename(String def, String[] args) {
        if (System.getProperty("org.jmri.Apps.configFilename") != null) {
            return;
        }
        if (args.length >= 1 && args[0] != null && !args[0].equals("") && !args[0].contains("=")) {
            def = args[0];
            log.debug("Config file was specified as: {}", (Object)args[0]);
        }
        for (String arg : args) {
            String[] split = arg.split("=", 2);
            if (!split[0].equalsIgnoreCase("config")) continue;
            def = split[1];
            log.debug("Config file was specified as: {}", (Object)arg);
        }
        if (def != null) {
            AppsBase.setJmriSystemProperty("configFilename", def);
            log.debug("Config file set to: {}", (Object)def);
        }
    }

    public static String getConfigFileName() {
        if (System.getProperty("org.jmri.Apps.configFilename") != null) {
            return System.getProperty("org.jmri.Apps.configFilename");
        }
        return CONFIG_FILENAME;
    }

    protected static void setJmriSystemProperty(String key, String value) {
        try {
            String current = System.getProperty("org.jmri.Apps." + key);
            if (current == null) {
                System.setProperty("org.jmri.Apps." + key, value);
            } else if (!current.equals(value)) {
                log.warn("JMRI property {} already set to {}, skipping reset to {}", new Object[]{key, current, value});
            }
        }
        catch (Exception e) {
            log.error("Unable to set JMRI property {} to {}due to exception", new Object[]{key, value, e});
        }
    }

    public static boolean handleQuit() {
        log.debug("Start handleQuit");
        try {
            InstanceManager.getDefault(ShutDownManager.class).shutdown();
        }
        catch (Exception e) {
            log.error("Continuing after error in handleQuit", (Throwable)e);
        }
        return false;
    }

    public static void handleRestart() {
        log.debug("Start handleRestart");
        try {
            InstanceManager.getDefault(ShutDownManager.class).restart();
        }
        catch (Exception e) {
            log.error("Continuing after error in handleRestart", (Throwable)e);
        }
    }
}

