/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.AppsBase;
import apps.Bundle;
import apps.gui3.tabbedpreferences.TabbedPreferencesAction;
import apps.jmrit.DebugMenu;
import apps.plaf.macosx.Application;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.TextAction;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.configurexml.LoadXmlUserAction;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.ToolsMenu;
import jmri.jmrit.automat.monitor.AutomatTableAction;
import jmri.jmrit.decoderdefn.PrintDecoderListAction;
import jmri.jmrit.display.PanelMenu;
import jmri.jmrit.jython.JythonWindow;
import jmri.jmrit.jython.RunJythonScript;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.permission.swing.ChangePasswordAction;
import jmri.jmrit.permission.swing.LoginAction;
import jmri.jmrit.permission.swing.LogoutAction;
import jmri.jmrit.revhistory.swing.FileHistoryAction;
import jmri.jmrit.roster.swing.RosterMenu;
import jmri.jmrix.ActiveSystemsMenu;
import jmri.script.swing.InputWindowAction;
import jmri.util.HelpUtil;
import jmri.util.SystemType;
import jmri.util.WindowMenu;
import jmri.util.swing.WindowInterface;

public class AppsMainMenu {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.jython.Bundle");
    static Action prefsAction;

    protected static void createMenus(JMenuBar menuBar, WindowInterface wi, JPanel pane, String windowHelpID) {
        AppsMainMenu.fileMenu(menuBar, wi);
        AppsMainMenu.editMenu(menuBar, wi);
        AppsMainMenu.toolsMenu(menuBar, wi);
        AppsMainMenu.rosterMenu(menuBar, wi, pane);
        AppsMainMenu.panelMenu(menuBar, wi);
        AppsMainMenu.scriptMenu(menuBar, wi);
        if (Setup.isMainMenuEnabled()) {
            AppsMainMenu.operationsMenu(menuBar, wi);
        }
        AppsMainMenu.systemsMenu(menuBar, wi);
        AppsMainMenu.debugMenu(menuBar, wi, pane);
        menuBar.add(new WindowMenu(wi));
        AppsMainMenu.helpMenu(menuBar, wi, pane, windowHelpID);
    }

    private static void fileMenu(JMenuBar menuBar, WindowInterface wi) {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new LoadXmlUserAction(Bundle.getMessage("FileMenuItemLoad")));
        fileMenu.add(new StoreXmlUserAction(Bundle.getMessage("FileMenuItemStore")));
        fileMenu.add(new FileHistoryAction(Bundle.getMessage("FileMenuItemHistory")));
        fileMenu.add(new JSeparator());
        if (InstanceManager.getDefault(PermissionManager.class).isEnabled()) {
            fileMenu.add(new LoginAction());
            fileMenu.add(new LogoutAction());
            fileMenu.add(new ChangePasswordAction());
            fileMenu.add(new JSeparator());
        }
        fileMenu.add(new PrintDecoderListAction(Bundle.getMessage("MenuPrintDecoderDefinitions"), wi.getFrame(), false));
        fileMenu.add(new PrintDecoderListAction(Bundle.getMessage("MenuPrintPreviewDecoderDefinitions"), wi.getFrame(), true));
        if (!SystemType.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            fileMenu.add(new JSeparator());
            fileMenu.add(new AbstractAction(Bundle.getMessage("MenuItemQuit")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppsMainMenu.handleQuit();
                }
            });
        }
    }

    private static void editMenu(JMenuBar menuBar, WindowInterface wi) {
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        menuBar.add(editMenu);
        TextAction a = new DefaultEditorKit.CutAction();
        a.putValue("Name", Bundle.getMessage("MenuItemCut"));
        editMenu.add(a);
        a = new DefaultEditorKit.CopyAction();
        a.putValue("Name", Bundle.getMessage("MenuItemCopy"));
        editMenu.add(a);
        a = new DefaultEditorKit.PasteAction();
        a.putValue("Name", Bundle.getMessage("MenuItemPaste"));
        editMenu.add(a);
        prefsAction = new TabbedPreferencesAction(Bundle.getMessage("MenuItemPreferences"));
        if (SystemType.isMacOSX()) {
            Application.getApplication().setPreferencesHandler(eo -> prefsAction.actionPerformed(null));
        }
        if (!SystemType.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            editMenu.addSeparator();
            editMenu.add(prefsAction);
        }
    }

    private static void toolsMenu(JMenuBar menuBar, WindowInterface wi) {
        menuBar.add(new ToolsMenu(Bundle.getMessage("MenuTools")));
    }

    private static void scriptMenu(JMenuBar menuBar, WindowInterface wi) {
        JMenu scriptMenu = new JMenu(rb.getString("MenuScripting"));
        scriptMenu.add(new RunJythonScript(rb.getString("MenuItemScript")));
        scriptMenu.add(new AutomatTableAction(rb.getString("MenuItemMonitor")));
        scriptMenu.add(new JythonWindow(rb.getString("MenuItemScriptLog")));
        scriptMenu.add(new InputWindowAction(rb.getString("MenuItemScriptInput")));
        menuBar.add(scriptMenu);
    }

    private static void operationsMenu(JMenuBar menuBar, WindowInterface wi) {
        menuBar.add(new OperationsMenu());
    }

    private static void rosterMenu(JMenuBar menuBar, WindowInterface wi, JPanel pane) {
        menuBar.add(new RosterMenu(Bundle.getMessage("MenuRoster"), 1, pane));
    }

    private static void panelMenu(JMenuBar menuBar, WindowInterface wi) {
        menuBar.add(new PanelMenu());
    }

    private static void systemsMenu(JMenuBar menuBar, WindowInterface wi) {
        ActiveSystemsMenu.addItems(menuBar);
    }

    private static void debugMenu(JMenuBar menuBar, WindowInterface wi, JPanel pane) {
        menuBar.add(new DebugMenu(pane));
    }

    private static void helpMenu(JMenuBar menuBar, WindowInterface wi, JPanel containedPane, String windowHelpID) {
        JMenu helpMenu = HelpUtil.makeHelpMenu(windowHelpID, true);
        menuBar.add(helpMenu);
    }

    private static void handleQuit() {
        AppsBase.handleQuit();
    }
}

