/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Bundle;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jmri.Version;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForUpdateAction
extends JmriAbstractAction {
    private static final Logger log = LoggerFactory.getLogger(CheckForUpdateAction.class);

    public CheckForUpdateAction(@Nonnull String s, @Nonnull WindowInterface wi) {
        super(s, wi);
    }

    public CheckForUpdateAction(@Nonnull String s, @Nonnull Icon i, @Nonnull WindowInterface wi) {
        super(s, i, wi);
    }

    public CheckForUpdateAction() {
        super(Bundle.getMessage("TitleUpdate"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        URL url;
        JmriJFrame frame = new JmriJFrame(Bundle.getMessage("TitleUpdate"), false, false);
        frame.setLayout(new BoxLayout(frame.getContentPane(), 1));
        JTextArea text = new JTextArea();
        text.setEditable(false);
        frame.add(text);
        String productionrelease = "";
        String testrelease = "";
        String urlname = "https://www.jmri.org/releaselist";
        String downloadURI = "https://www.jmri.org/download/";
        try {
            url = new URI(urlname).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Unexpected failure in URL parsing", (Throwable)e);
            return;
        }
        try (InputStream in = url.openConnection().getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("production")) {
                    productionrelease = this.getNumber(reader);
                }
                if (!line.startsWith("test")) continue;
                testrelease = this.getNumber(reader);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("Unable to get version info from web", (Throwable)e);
        }
        catch (IOException e) {
            log.debug("Unexpected failure during reading", (Throwable)e);
        }
        text.append(Bundle.getMessage("MostRecent", productionrelease) + "\n");
        text.append(Bundle.getMessage("MostRecentTest", testrelease) + "\n");
        text.append(Bundle.getMessage("YouHaveVersion", Version.name()) + "\n");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JButton go = new JButton(Bundle.getMessage("ButtonDownloadPage"));
        go.addActionListener(event -> {
            try {
                Desktop.getDesktop().browse(new URI(downloadURI));
            }
            catch (URISyntaxException e) {
                log.error("Invalid page requested", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Could no load page", (Throwable)e);
            }
        });
        p.add(go);
        JButton close = new JButton(Bundle.getMessage("ButtonClose"));
        close.addActionListener(event -> {
            frame.setVisible(false);
            frame.dispose();
        });
        p.add(close);
        frame.add(p);
        ((Window)frame).pack();
        frame.setVisible(true);
    }

    @Nonnull
    String getNumber(@Nonnull BufferedReader reader) throws IOException {
        String line = reader.readLine();
        log.debug("intentionally skipping line {}", (Object)line);
        line = reader.readLine();
        if (line == null) {
            return "";
        }
        return line.substring(0, line.length() - 1);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

