/*
 * Decompiled with CFR 0.152.
 */
package apps;

import jmri.util.swing.JmriJOptionPane;

public class JavaVersionCheckWindow {
    static Compatibility checkJavaVersion() {
        String version;
        switch (version = System.getProperty("java.version")) {
            case "11": 
            case "12": 
            case "13": {
                return Compatibility.SUPPORTED;
            }
        }
        if (version.startsWith("1.8")) {
            return Compatibility.INCOMPATIBLE;
        }
        switch (version) {
            case "17": {
                return Compatibility.UNSUPPORTED;
            }
        }
        return Compatibility.UNSUPPORTED;
    }

    public static void main(String[] opts) {
        Compatibility result = JavaVersionCheckWindow.checkJavaVersion();
        if (result == Compatibility.INCOMPATIBLE) {
            System.err.println("JMRI cannot run on Java version " + System.getProperty("java.version"));
            JmriJOptionPane.showMessageDialog(null, "JMRI cannot run on Java version " + System.getProperty("java.version"), "Alert", 0);
            System.exit(-1);
        }
    }

    static enum Compatibility {
        SUPPORTED,
        INCOMPATIBLE,
        UNSUPPORTED;

    }
}

