/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.AppsConfigurationManager;
import apps.AppsPreferencesActionFactory;
import apps.util.Log4JUtil;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.lenz.li100.LI100Adapter;
import jmri.util.exceptionhandler.UncaughtExceptionHandler;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.web.server.WebServer;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleMinimalProgram {
    static String name = "Faceless App";
    private static final Logger log = LoggerFactory.getLogger(SampleMinimalProgram.class);

    public static void main(String[] args) {
        SampleMinimalProgram.initLog4J();
        log.info("Startup: {}", (Object)Log4JUtil.startupInfo(name));
        new SampleMinimalProgram(args);
        log.debug("main initialization done");
    }

    public static String startupInfo(String program) {
        return program + " version " + Version.name() + " starts under Java " + System.getProperty("java.version", "<unknown>");
    }

    protected static void initLog4J() {
        String configFile = "default_lcf.xml";
        Log4JUtil.initLogging(configFile);
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    public SampleMinimalProgram(String[] args) {
        this.codeConfig(args);
    }

    protected void codeConfig(String[] args) {
        LI100Adapter adapter = new LI100Adapter();
        String portName = "/dev/cu.Bluetooth-PDA-Sync";
        String baudRate = "9600";
        adapter.setPort(portName);
        adapter.configureBaudRate(baudRate);
        adapter.openPort(portName, "JMRI app");
        adapter.configure();
        InstanceManager.store(new AppsPreferencesActionFactory(), JmriPreferencesActionFactory.class);
        AppsConfigurationManager cm = new AppsConfigurationManager();
        InstanceManager.setDefault(ConfigureManager.class, cm);
        int port = 12080;
        InstanceManager.getDefault(WebServerPreferences.class).setPort(12080);
        try {
            WebServer.getDefault().start();
        }
        catch (Exception ex) {
            log.error("Unable to start web server.", (Throwable)ex);
        }
        log.info("Up!");
    }
}

