/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.Bundle;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.util.JmriJFrame;
import jmri.util.swing.TextAreaFIFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConsole {
    static final ResourceBundle rbc = ResourceBundle.getBundle("apps.AppsConfigBundle");
    private static final int STD_ERR = 1;
    private static final int STD_OUT = 2;
    private final TextAreaFIFO console;
    private final PrintStream originalOut;
    private final PrintStream originalErr;
    private final PrintStream outputStream;
    private final PrintStream errorStream;
    private JmriJFrame frame = null;
    private final JPopupMenu popup = new JPopupMenu();
    private JMenuItem copySelection = null;
    private JMenu wrapMenu = null;
    private ButtonGroup wrapGroup = null;
    private JMenu schemeMenu = null;
    private ButtonGroup schemeGroup = null;
    private ArrayList<Scheme> schemes;
    private int scheme = 0;
    private int fontSize = 12;
    private int fontStyle = 0;
    private static final String FONT_FAMILY = "Monospaced";
    public static final int WRAP_STYLE_NONE = 0;
    public static final int WRAP_STYLE_LINE = 1;
    public static final int WRAP_STYLE_WORD = 2;
    private int wrapStyle = 2;
    private final String alwaysScrollCheck = this.getClass().getName() + ".alwaysScroll";
    private final String alwaysOnTopCheck = this.getClass().getName() + ".alwaysOnTop";
    public int MAX_CONSOLE_LINES = 5000;
    private static final Logger log = LoggerFactory.getLogger(SystemConsole.class);

    public static SystemConsole getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Can only be called from the same instance so default encoding OK")
    private SystemConsole() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.console = new TextAreaFIFO(this.MAX_CONSOLE_LINES);
        this.console.setRows(20);
        this.console.setColumns(120);
        this.console.setFont(new Font(FONT_FAMILY, this.fontStyle, this.fontSize));
        this.console.setEditable(false);
        this.setScheme(this.scheme);
        this.setWrapStyle(this.wrapStyle);
        this.outputStream = new PrintStream(this.outStream(2), true);
        this.errorStream = new PrintStream(this.outStream(1), true);
        this.redirectSystemStreams(this.outputStream, this.errorStream);
    }

    public static JFrame getConsole() {
        return SystemConsole.getInstance().getFrame();
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            log.debug("Creating frame for console");
            if (SwingUtilities.isEventDispatchThread()) {
                this.createFrame();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this::createFrame);
                }
                catch (InvocationTargetException ex) {
                    log.error("Invocation Exception creating system console frame", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    log.error("Interrupt Exception creating system console frame", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
            log.debug("Frame created");
        }
        return this.frame;
    }

    private void createFrame() {
        JRadioButtonMenuItem rbMenuItem;
        this.frame = new JmriJFrame(Bundle.getMessage("TitleConsole"));
        UserPreferencesManager pref = InstanceManager.getDefault(UserPreferencesManager.class);
        this.frame.addHelpMenu("package.apps.SystemConsole", true);
        Clipboard clipboard = this.frame.getToolkit().getSystemClipboard();
        JScrollPane scroll = new JScrollPane(this.console);
        this.frame.add((Component)scroll, "Center");
        JPanel p = new JPanel();
        JButton clear = new JButton(Bundle.getMessage("ButtonClear"));
        clear.addActionListener(e -> this.console.setText(""));
        clear.setToolTipText(Bundle.getMessage("ButtonClearTip"));
        p.add(clear);
        JButton copy = new JButton(Bundle.getMessage("ButtonCopyClip"));
        copy.addActionListener(e -> {
            StringSelection text = new StringSelection(this.console.getText());
            clipboard.setContents(text, text);
        });
        p.add(copy);
        JButton close = new JButton(Bundle.getMessage("ButtonClose"));
        close.addActionListener(e -> {
            this.frame.setVisible(false);
            this.console.dispose();
            this.frame.dispose();
        });
        p.add(close);
        JButton stackTrace = new JButton(Bundle.getMessage("ButtonStackTrace"));
        stackTrace.addActionListener(e -> this.performStackTrace());
        p.add(stackTrace);
        JCheckBox autoScroll = new JCheckBox(Bundle.getMessage("CheckBoxAutoScroll"));
        p.add((Component)autoScroll, !pref.getSimplePreferenceState(this.alwaysScrollCheck));
        this.console.setAutoScroll(autoScroll.isSelected());
        autoScroll.addActionListener(event -> {
            this.console.setAutoScroll(autoScroll.isSelected());
            pref.setSimplePreferenceState(this.alwaysScrollCheck, !autoScroll.isSelected());
        });
        JCheckBox alwaysOnTop = new JCheckBox(Bundle.getMessage("CheckBoxOnTop"));
        p.add((Component)alwaysOnTop, pref.getSimplePreferenceState(this.alwaysOnTopCheck));
        alwaysOnTop.setVisible(true);
        alwaysOnTop.setToolTipText(Bundle.getMessage("ToolTipOnTop"));
        alwaysOnTop.addActionListener(event -> {
            this.frame.setAlwaysOnTop(alwaysOnTop.isSelected());
            pref.setSimplePreferenceState(this.alwaysOnTopCheck, alwaysOnTop.isSelected());
        });
        this.frame.setAlwaysOnTop(alwaysOnTop.isSelected());
        this.copySelection = new JMenuItem(Bundle.getMessage("MenuItemCopy"));
        this.copySelection.addActionListener(event -> {
            StringSelection text = new StringSelection(this.console.getSelectedText());
            clipboard.setContents(text, text);
        });
        this.popup.add(this.copySelection);
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("ButtonCopyClip"));
        menuItem.addActionListener(event -> {
            StringSelection text = new StringSelection(this.console.getText());
            clipboard.setContents(text, text);
        });
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        this.schemeMenu = new JMenu(rbc.getString("ConsoleSchemeMenu"));
        this.schemeGroup = new ButtonGroup();
        for (Scheme s : this.schemes) {
            rbMenuItem = new JRadioButtonMenuItem(s.description);
            rbMenuItem.addActionListener(e -> this.setScheme(this.schemes.indexOf(s)));
            rbMenuItem.setSelected(this.getScheme() == this.schemes.indexOf(s));
            this.schemeMenu.add(rbMenuItem);
            this.schemeGroup.add(rbMenuItem);
        }
        this.popup.add(this.schemeMenu);
        this.wrapMenu = new JMenu(rbc.getString("ConsoleWrapStyleMenu"));
        this.wrapGroup = new ButtonGroup();
        rbMenuItem = new JRadioButtonMenuItem(rbc.getString("ConsoleWrapStyleNone"));
        rbMenuItem.addActionListener(e -> this.setWrapStyle(0));
        rbMenuItem.setSelected(this.getWrapStyle() == 0);
        this.wrapMenu.add(rbMenuItem);
        this.wrapGroup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(rbc.getString("ConsoleWrapStyleLine"));
        rbMenuItem.addActionListener(e -> this.setWrapStyle(1));
        rbMenuItem.setSelected(this.getWrapStyle() == 1);
        this.wrapMenu.add(rbMenuItem);
        this.wrapGroup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(rbc.getString("ConsoleWrapStyleWord"));
        rbMenuItem.addActionListener(e -> this.setWrapStyle(2));
        rbMenuItem.setSelected(this.getWrapStyle() == 2);
        this.wrapMenu.add(rbMenuItem);
        this.wrapGroup.add(rbMenuItem);
        this.popup.add(this.wrapMenu);
        PopupListener popupListener = new PopupListener();
        this.console.addMouseListener(popupListener);
        this.frame.addMouseListener(popupListener);
        this.frame.add((Component)p, "South");
        this.frame.pack();
    }

    private void updateTextArea(String text, int which) {
        if (which == 2) {
            this.originalOut.append(text);
        } else if (which == 1) {
            this.originalErr.append(text);
        }
        SwingUtilities.invokeLater(() -> {
            SystemConsole systemConsole = this;
            synchronized (systemConsole) {
                this.console.append(text);
            }
        });
    }

    private OutputStream outStream(final int which) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                SystemConsole.this.updateTextArea(String.valueOf((char)b), which);
            }

            @Override
            @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Can only be called from the same instance so default encoding OK")
            public void write(byte[] b, int off, int len) throws IOException {
                SystemConsole.this.updateTextArea(new String(b, off, len), which);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Can only be called from the same instance so default encoding OK")
    private void redirectSystemStreams(PrintStream out, PrintStream err) {
        System.setOut(out);
        System.setErr(err);
    }

    public void setWrapStyle(int style) {
        this.wrapStyle = style;
        this.console.setLineWrap(style != 0);
        this.console.setWrapStyleWord(style == 2);
        if (this.wrapGroup != null) {
            this.wrapGroup.setSelected(this.wrapMenu.getItem(style).getModel(), true);
        }
    }

    public int getWrapStyle() {
        return this.wrapStyle;
    }

    public void setFontSize(int size) {
        this.fontSize = size < 6 ? 6 : (size > 24 ? 24 : size);
        this.updateFont(FONT_FAMILY, this.fontStyle, this.fontSize);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontStyle(int style) {
        this.fontStyle = style == 1 || style == 2 || style == 0 || style == 3 ? style : 0;
        this.updateFont(FONT_FAMILY, this.fontStyle, this.fontSize);
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    private void updateFont(String family, int style, int size) {
        this.console.setFont(new Font(family, style, size));
    }

    private void defineSchemes() {
        this.schemes = new ArrayList();
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeGreenOnBlack"), Color.GREEN, Color.BLACK));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeOrangeOnBlack"), Color.ORANGE, Color.BLACK));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeWhiteOnBlack"), Color.WHITE, Color.BLACK));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeBlackOnWhite"), Color.BLACK, Color.WHITE));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeWhiteOnBlue"), Color.WHITE, Color.BLUE));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeBlackOnLightGray"), Color.BLACK, Color.LIGHT_GRAY));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeBlackOnGray"), Color.BLACK, Color.GRAY));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeWhiteOnGray"), Color.WHITE, Color.GRAY));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeWhiteOnDarkGray"), Color.WHITE, Color.DARK_GRAY));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeGreenOnDarkGray"), Color.GREEN, Color.DARK_GRAY));
        this.schemes.add(new Scheme(rbc.getString("ConsoleSchemeOrangeOnDarkGray"), Color.ORANGE, Color.DARK_GRAY));
    }

    private void performStackTrace() {
        System.out.println("----------- Begin Stack Trace -----------");
        System.out.println("-----------------------------------------");
        HashMap<Thread, StackTraceElement[]> traces = new HashMap<Thread, StackTraceElement[]>(Thread.getAllStackTraces());
        for (Thread thread : traces.keySet()) {
            System.out.println("[" + thread.getId() + "] " + thread.getName());
            for (StackTraceElement el : thread.getStackTrace()) {
                System.out.println("  " + el);
            }
            System.out.println("-----------------------------------------");
        }
        System.out.println("-----------  End Stack Trace  -----------");
    }

    public void setScheme(int which) {
        Scheme s;
        this.scheme = which;
        if (this.schemes == null) {
            this.defineSchemes();
        }
        try {
            s = this.schemes.get(which);
        }
        catch (IndexOutOfBoundsException ex) {
            s = this.schemes.get(0);
            this.scheme = 0;
        }
        this.console.setForeground(s.foreground);
        this.console.setBackground(s.background);
        if (this.schemeGroup != null) {
            this.schemeGroup.setSelected(this.schemeMenu.getItem(this.scheme).getModel(), true);
        }
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public void close() {
        this.redirectSystemStreams(this.originalOut, this.originalErr);
    }

    public void open() {
        this.redirectSystemStreams(this.getOutputStream(), this.getErrorStream());
    }

    public int getScheme() {
        return this.scheme;
    }

    public Scheme[] getSchemes() {
        return this.schemes.toArray(new Scheme[this.schemes.size()]);
    }

    public final class PopupListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SystemConsole.this.copySelection.setEnabled(SystemConsole.this.console.getSelectionStart() != SystemConsole.this.console.getSelectionEnd());
                SystemConsole.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static final class Scheme {
        public Color foreground;
        public Color background;
        public String description;

        Scheme(String description, Color foreground, Color background) {
            this.foreground = foreground;
            this.background = background;
            this.description = description;
        }
    }

    private static class InstanceHolder {
        private static final SystemConsole INSTANCE;

        private InstanceHolder() {
        }

        static {
            SystemConsole instance = null;
            try {
                instance = new SystemConsole();
            }
            catch (RuntimeException ex) {
                log.error("failed to complete Console redirection", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

