/*
 * Decompiled with CFR 0.152.
 */
package apps.configurexml;

import apps.SystemConsoleConfigPanel;
import apps.systemconsole.SystemConsolePreferencesManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConsoleConfigPanelXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(SystemConsoleConfigPanelXml.class);

    @Override
    public Element store(Object o) {
        Element e = new Element("console");
        e.setAttribute("class", this.getClass().getName());
        SystemConsolePreferencesManager manager = InstanceManager.getDefault(SystemConsolePreferencesManager.class);
        e.setAttribute("scheme", "" + manager.getScheme());
        e.setAttribute("fontsize", "" + manager.getFontSize());
        e.setAttribute("fontstyle", "" + manager.getFontStyle());
        e.setAttribute("wrapstyle", "" + manager.getWrapStyle());
        return e;
    }

    @Override
    public boolean loadDeferred() {
        return true;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = true;
        SystemConsolePreferencesManager manager = InstanceManager.getDefault(SystemConsolePreferencesManager.class);
        try {
            String value = shared.getAttributeValue("scheme");
            if (value != null) {
                manager.setScheme(Integer.parseInt(value));
            }
            if ((value = shared.getAttributeValue("fontsize")) != null) {
                manager.setFontSize(Integer.parseInt(value));
            }
            if ((value = shared.getAttributeValue("fontstyle")) != null) {
                manager.setFontStyle(Integer.parseInt(value));
            }
            if ((value = shared.getAttributeValue("wrapstyle")) != null) {
                manager.setWrapStyle(Integer.parseInt(value));
            }
        }
        catch (NumberFormatException ex) {
            log.error("NumberFormatException while setting System Console parameters", (Throwable)ex);
            result = false;
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerPref(new SystemConsoleConfigPanel());
        }
        return result;
    }
}

