/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3;

import apps.AppsBase;
import apps.SplashWindow;
import apps.SystemConsole;
import apps.gui3.Bundle;
import apps.gui3.FirstTimeStartUpWizardAction;
import apps.gui3.tabbedpreferences.TabbedPreferencesAction;
import apps.plaf.macosx.Application;
import apps.swing.AboutDialog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicToolBarUI;
import jmri.InstanceManager;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileManagerDialog;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.SystemType;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Apps3
extends AppsBase {
    static JComponent _buttonSpace = null;
    protected JmriJFrame mainFrame;
    static SplashWindow sp = null;
    static AWTEventListener debugListener = null;
    static boolean debugFired = false;
    static boolean debugmsg = false;
    private static final Logger log = LoggerFactory.getLogger(Apps3.class);

    public static void preInit(String applicationName) {
        AppsBase.preInit(applicationName);
        SystemConsole.getInstance();
        Apps3.splash(true);
        Apps3.setButtonSpace();
    }

    public Apps3(String applicationName, String configFileDef, String[] args) {
        super(applicationName, configFileDef, args);
        if (SystemType.isMacOSX()) {
            this.initMacOSXMenus();
        }
        if ((!this.configOK || !this.configDeferredLoadOK) && !this.preferenceFileExists || this.wizardLaunchCheck()) {
            this.launchFirstTimeStartupWizard();
            return;
        }
        this.createAndDisplayFrame();
    }

    protected boolean wizardLaunchCheck() {
        return false;
    }

    public void launchFirstTimeStartupWizard() {
        FirstTimeStartUpWizardAction prefsAction = new FirstTimeStartUpWizardAction("Start Up Wizard");
        prefsAction.setApp(this);
        prefsAction.actionPerformed(null);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="only one application at a time")
    protected static void setButtonSpace() {
        _buttonSpace = new JPanel();
        _buttonSpace.setLayout(new FlowLayout(0));
    }

    public static JComponent buttonSpace() {
        return _buttonSpace;
    }

    protected abstract void createMainFrame();

    public void createAndDisplayFrame() {
        this.createMainFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.displayMainFrame(this.mainFrame.getMaximumSize());
    }

    protected void setFloating(JToolBar toolBar) {
        ((BasicToolBarUI)toolBar.getUI()).setFloating(true, new Point(500, 500));
    }

    protected void displayMainFrame(Dimension d) {
        this.mainFrame.setSize(d);
        this.mainFrame.setVisible(true);
    }

    @Override
    protected void start() {
        super.start();
        Apps3.splash(false);
    }

    protected static void splash(boolean show) {
        Apps3.splash(show, false);
    }

    protected static void splash(boolean show, boolean debug) {
        if (debugListener == null && debug) {
            debugFired = false;
            debugListener = new AWTEventListener(){

                @Override
                @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="debugmsg write is semi-global")
                public void eventDispatched(AWTEvent e) {
                    if (!debugFired) {
                        debugmsg = true;
                        if (e.getID() == 401 && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 119) {
                            Apps3.startupDebug();
                        } else if (e.getID() == 401 && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 120) {
                            InstanceManager.getDefault(LogixNG_Manager.class).startLogixNGsOnLoad(false);
                        } else {
                            debugmsg = false;
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(debugListener, 8L);
        }
        if (sp == null) {
            sp = new SplashWindow(debug ? Apps3.splashDebugMsg() : null);
        }
        sp.setVisible(show);
        if (!show) {
            sp.dispose();
            Toolkit.getDefaultToolkit().removeAWTEventListener(debugListener);
            debugListener = null;
            sp = null;
        }
    }

    protected static JPanel splashDebugMsg() {
        JLabel panelLabelDisableLogix = new JLabel(Bundle.getMessage("PressF8ToDebug"));
        panelLabelDisableLogix.setFont(panelLabelDisableLogix.getFont().deriveFont(9.0f));
        JLabel panelLabelDisableLogixNG = new JLabel(Bundle.getMessage("PressF9ToDisableLogixNG"));
        panelLabelDisableLogixNG.setFont(panelLabelDisableLogix.getFont().deriveFont(9.0f));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(panelLabelDisableLogix);
        panel.add(panelLabelDisableLogixNG);
        return panel;
    }

    protected static void startupDebug() {
        debugFired = true;
        debugmsg = true;
        debugmsg = false;
    }

    protected void initMacOSXMenus() {
        Application macApp = Application.getApplication();
        macApp.setAboutHandler(eo -> new AboutDialog(null, true).setVisible(true));
        macApp.setPreferencesHandler(eo -> new TabbedPreferencesAction(Bundle.getMessage("MenuItemPreferences")).actionPerformed());
        macApp.setQuitHandler(eo -> Apps3.handleQuit());
    }

    @Override
    protected void configureProfile() {
        FileUtil.createDirectory(FileUtil.getPreferencesPath());
        String profileFilename = Apps3.getConfigFileName().replaceFirst(".xml", ".properties");
        File profileFile = !new File(profileFilename).isAbsolute() ? new File(FileUtil.getPreferencesPath() + profileFilename) : new File(profileFilename);
        ProfileManager.getDefault().setConfigFile(profileFile);
        if (System.getProperties().containsKey("org.jmri.profile")) {
            ProfileManager.getDefault().setActiveProfile(System.getProperty("org.jmri.profile"));
        }
        if (!profileFile.exists()) {
            log.trace("profileFile {} doesn't exist", (Object)profileFile);
            try {
                if (ProfileManager.getDefault().migrateToProfiles(Apps3.getConfigFileName())) {
                    JmriJOptionPane.showMessageDialog(sp, Bundle.getMessage("ConfigMigratedToProfile"), jmri.Application.getApplicationName(), 1);
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                JmriJOptionPane.showMessageDialog(sp, ex.getLocalizedMessage(), jmri.Application.getApplicationName(), 0);
                log.error("Exception: ", (Throwable)ex);
            }
        }
        try {
            ProfileManagerDialog.getStartingProfile(sp);
            System.setProperty("org.jmri.Apps.configFilename", "ProfileConfig.xml");
            Profile profile = ProfileManager.getDefault().getActiveProfile();
            if (profile != null) {
                log.info("Starting with profile {}", (Object)profile.getId());
            } else {
                log.info("Starting without a profile");
            }
            GuiLafPreferencesManager.setLocaleMinimally(profile);
        }
        catch (IOException ex) {
            log.info("Profiles not configurable. Using fallback per-application configuration. Error: {}", (Object)ex.getMessage());
        }
    }

    @Override
    protected void setAndLoadPreferenceFile() {
        File sharedConfig = null;
        try {
            sharedConfig = FileUtil.getFile("profile:profile/profile.xml");
            if (!sharedConfig.canRead()) {
                sharedConfig = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        super.setAndLoadPreferenceFile();
        if (sharedConfig == null && this.configOK && this.configDeferredLoadOK) {
            String name = ProfileManager.getDefault().getActiveProfileName();
            if (!GraphicsEnvironment.isHeadless()) {
                JmriJOptionPane.showMessageDialog(sp, Bundle.getMessage("SingleConfigMigratedToSharedConfig", name), jmri.Application.getApplicationName(), 1);
            }
        }
    }
}

