/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3;

import apps.gui3.Apps3;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import jmri.Application;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.PortAdapter;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.prefs.InitializationException;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstTimeStartUpWizard
implements Thread.UncaughtExceptionHandler {
    Image splashIm;
    JmriJFrame parent;
    protected final JmrixConfigPane connectionConfigPane = JmrixConfigPane.createNewPanel();
    JLabel header = new JLabel();
    ArrayList<WizardPage> wizPage = new ArrayList();
    Apps3 app;
    JPanel entryPanel = new JPanel();
    JPanel helpPanel = new JPanel();
    Dimension minHelpFieldDim = new Dimension(160, 20);
    Dimension maxHelpFieldDim = new Dimension(160, 300);
    JTextField owner = new JTextField(20);
    int currentScreen = 0;
    Locale initalLocale;
    JComboBox<String> localeBox;
    HashMap<String, Locale> locale;
    final String[] localeNames;
    JPanel mainWizardPanel = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(FirstTimeStartUpWizard.class);

    public FirstTimeStartUpWizard(JmriJFrame parent, Apps3 app) {
        this.parent = parent;
        this.app = app;
        this.mainWizardPanel.setLayout(new BorderLayout());
        this.localeNames = new String[Locale.getAvailableLocales().length];
        this.mainWizardPanel.add((Component)this.createTopBanner(), "North");
        this.mainWizardPanel.add((Component)this.createHelpPanel(), "West");
        this.mainWizardPanel.add((Component)this.createEntryPanel(), "Center");
        this.mainWizardPanel.add((Component)this.createButtonPanel(), "South");
        this.customizeConnection();
    }

    JPanel createTopBanner() {
        JPanel top = new JPanel();
        this.header.setText("Welcome to JMRI StartUp Wizard");
        top.add(this.header);
        return top;
    }

    protected void customizeConnection() {
    }

    JPanel createHelpPanel() {
        this.splashIm = Toolkit.getDefaultToolkit().getImage(FileUtil.findURL("resources/logo.gif", FileUtil.Location.INSTALLED));
        ImageIcon img = new ImageIcon(this.splashIm, "JMRI splash screen");
        int imageWidth = img.getIconWidth();
        this.minHelpFieldDim = new Dimension(imageWidth, 20);
        this.maxHelpFieldDim = new Dimension(imageWidth + 20, 350);
        this.helpPanel.setPreferredSize(this.maxHelpFieldDim);
        this.helpPanel.setMaximumSize(this.maxHelpFieldDim);
        this.helpPanel.setLayout(new BoxLayout(this.helpPanel, 1));
        JLabel l = new JLabel(img);
        l.setAlignmentX(0.5f);
        l.setOpaque(false);
        this.helpPanel.add(l);
        return this.helpPanel;
    }

    void createScreens() {
        this.firstWelcome();
        this.setDefaultOwner();
        this.setConnection();
        this.finishAndConnect();
    }

    public void dispose() {
        Cursor normalCursor = new Cursor(0);
        this.parent.setCursor(normalCursor);
        this.app.createAndDisplayFrame();
        this.parent.setVisible(false);
        this.parent.dispose();
    }

    JComponent createEntryPanel() {
        this.createScreens();
        for (int i = 0; i < this.wizPage.size(); ++i) {
            this.entryPanel.add(this.wizPage.get(i).getPanel());
            this.helpPanel.add(this.wizPage.get(i).getHelpDetails());
        }
        this.wizPage.get(0).getPanel().setVisible(true);
        this.wizPage.get(0).getHelpDetails().setVisible(true);
        this.header.setFont(this.header.getFont().deriveFont(14.0f));
        return this.entryPanel;
    }

    void setDefaultOwner() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Select your language<br>"));
        this.initalLocale = Locale.getDefault();
        p.add(this.doLocale());
        p.add(this.formatText("<br>Enter in the default owner for all your loco roster entries<p>If you are not part of group or club, where different people will be accessing DecoderPro, then you can leave this blank</p>"));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(new JLabel("Default Owner"));
        this.owner.setText(InstanceManager.getDefault(RosterConfigManager.class).getDefaultOwner());
        if (this.owner.getText().isEmpty()) {
            this.owner.setText(System.getProperty("user.name"));
        }
        p2.add(this.owner);
        p.add(p2);
        this.wizPage.add(new WizardPage(p, new JPanel(), "Set the Default Language and Owner"));
    }

    protected String firstPrompt() {
        return "First select the manufacturer of your DCC system\n\nFollowed by the type of connection being used.\n\nFinally select the serial port or enter in the IP address of the device";
    }

    void setConnection() {
        JPanel h = new JPanel();
        h.setLayout(new BoxLayout(h, 1));
        h.setMaximumSize(this.maxHelpFieldDim);
        JTextArea text = new JTextArea(this.firstPrompt());
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setOpaque(false);
        text.setMinimumSize(this.minHelpFieldDim);
        text.setMaximumSize(this.maxHelpFieldDim);
        h.add(text);
        this.wizPage.add(new WizardPage(this.connectionConfigPane, h, "Select Your System Connection"));
    }

    void firstWelcome() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Welcome to JMRI's " + Application.getApplicationName() + "<p><br>This little wizard will help to guide you through setting up " + Application.getApplicationName() + " for the first time"));
        this.wizPage.add(new WizardPage(p, new JPanel(), "Welcome to JMRI StartUp Wizard"));
    }

    void finishAndConnect() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.formatText("Configuration is now all complete, press finish below to connect to your system and start using " + Application.getApplicationName() + "\n\nIf at any time you need to change your settings, you can find the preference setting under the Edit Menu"));
        this.wizPage.add(new WizardPage(p, new JPanel(), "Finish and Connect"));
    }

    JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(new BevelBorder(1));
        JButton previous = new JButton("< Back");
        JButton next = new JButton("Next >");
        JButton finish = new JButton("Finish");
        finish.setVisible(false);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            Locale.setDefault(this.initalLocale);
            this.dispose();
        });
        previous.addActionListener(e -> {
            if (this.currentScreen < this.wizPage.size()) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(false);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(false);
            }
            finish.setVisible(false);
            --this.currentScreen;
            if (this.currentScreen != -1) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(true);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(true);
                this.header.setText(this.wizPage.get(this.currentScreen).getHeaderText());
                this.header.setFont(this.header.getFont().deriveFont(14.0f));
                if (this.currentScreen == 0) {
                    previous.setEnabled(false);
                }
                next.setEnabled(true);
                next.setVisible(true);
            } else {
                this.currentScreen = 0;
                previous.setEnabled(false);
            }
        });
        next.addActionListener(e -> {
            this.wizPage.get(this.currentScreen).getPanel().setVisible(false);
            this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(false);
            ++this.currentScreen;
            if (this.currentScreen < this.wizPage.size()) {
                this.wizPage.get(this.currentScreen).getPanel().setVisible(true);
                this.wizPage.get(this.currentScreen).getHelpDetails().setVisible(true);
                this.header.setText(this.wizPage.get(this.currentScreen).getHeaderText());
                this.header.setFont(this.header.getFont().deriveFont(14.0f));
                previous.setEnabled(true);
                if (this.currentScreen == this.wizPage.size() - 1) {
                    next.setEnabled(false);
                    next.setVisible(false);
                    finish.setVisible(true);
                }
            }
        });
        finish.addActionListener(e -> {
            Connect r = new Connect();
            Thread connectThread = new Thread(r);
            connectThread.start();
            connectThread.setName("Start-Up Wizard Connect");
            connectThread.setUncaughtExceptionHandler(this);
        });
        buttonPanel.add(previous);
        buttonPanel.add(next);
        buttonPanel.add(new JLabel("     "));
        buttonPanel.add(finish);
        buttonPanel.add(cancel);
        previous.setEnabled(false);
        return buttonPanel;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.showDialogue(e);
    }

    private void showDialogue(Throwable ex) {
        log.error("Exception: ", ex);
        Cursor normalCursor = new Cursor(0);
        this.parent.setCursor(normalCursor);
        ConnectionConfig conn = this.connectionConfigPane.getCurrentObject();
        String connName = conn == null ? "No Connection " : conn.getConnectionName();
        ThreadingUtil.runOnGUI(() -> JmriJOptionPane.showMessageDialog(this.parent, "<html>An error occurred while trying to connect to " + connName + ", <br>press the back button and check the connection details.<br>" + ex.getLocalizedMessage() + "</html>", "Error Opening Connection", 0));
    }

    public JPanel doLocale() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.localeBox = new JComboBox<String>(new String[]{Locale.getDefault().getDisplayName(), "(Please Wait)"});
        panel.add(this.localeBox);
        Runnable r = () -> {
            Locale[] locales = Locale.getAvailableLocales();
            this.locale = new HashMap();
            for (int i = 0; i < locales.length; ++i) {
                this.locale.put(locales[i].getDisplayName(), locales[i]);
                this.localeNames[i] = locales[i].getDisplayName();
            }
            Arrays.sort(this.localeNames);
            Runnable update = () -> {
                this.localeBox.setModel(new DefaultComboBoxModel<String>(this.localeNames));
                this.localeBox.setSelectedItem(Locale.getDefault().getDisplayName());
            };
            SwingUtilities.invokeLater(update);
        };
        new Thread(r).start();
        this.localeBox.addActionListener(a -> {
            if (this.localeBox == null || this.locale == null) {
                return;
            }
            String desired = (String)this.localeBox.getSelectedItem();
            Locale.setDefault(this.locale.get(desired));
        });
        return panel;
    }

    JLabel formatText(String text) {
        JLabel label = new JLabel();
        label.setText("<html><body width='450'>" + text + "</html>");
        return label;
    }

    public JPanel getPanel() {
        return this.mainWizardPanel;
    }

    static class WizardPage {
        static Dimension defaultInfoSize = new Dimension(500, 300);
        JComponent panel;
        JPanel helpDetails = new JPanel();
        String headerText = "";

        WizardPage(JComponent mainPanel, JPanel helpDetails, String headerText) {
            this.panel = mainPanel;
            if (helpDetails != null) {
                this.helpDetails = helpDetails;
                this.helpDetails.setLayout(new BoxLayout(this.helpDetails, 1));
            }
            if (this.panel != null) {
                this.panel.setPreferredSize(defaultInfoSize);
                this.panel.setVisible(false);
            }
            this.helpDetails.setVisible(false);
            this.headerText = headerText;
        }

        JComponent getPanel() {
            return this.panel;
        }

        JPanel getHelpDetails() {
            return this.helpDetails;
        }

        String getHeaderText() {
            return this.headerText;
        }
    }

    protected class Connect
    implements Runnable {
        protected Connect() {
        }

        @Override
        public void run() {
            Cursor hourglassCursor = new Cursor(3);
            FirstTimeStartUpWizard.this.parent.setCursor(hourglassCursor);
            ConnectionConfig connect = FirstTimeStartUpWizard.this.connectionConfigPane.getCurrentObject();
            ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cm != null) {
                cm.registerPref(connect);
            }
            if (connect instanceof AbstractConnectionConfig) {
                ((AbstractConnectionConfig)connect).updateAdapter();
                PortAdapter adp = connect.getAdapter();
                try {
                    adp.connect();
                    adp.configure();
                }
                catch (Exception ex) {
                    FirstTimeStartUpWizard.this.showDialogue(ex);
                    return;
                }
            }
            Profile project = ProfileManager.getDefault().getActiveProfile();
            InstanceManager.getDefault(RosterConfigManager.class).setDefaultOwner(project, FirstTimeStartUpWizard.this.owner.getText());
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setLocale(Locale.getDefault());
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setDefaultFontSize();
            InstanceManager.getDefault(GuiLafPreferencesManager.class).setFontSize(InstanceManager.getDefault(GuiLafPreferencesManager.class).getDefaultFontSize());
            InstanceManager.getDefault(RosterConfigManager.class).savePreferences(project);
            InstanceManager.getDefault(GuiLafPreferencesManager.class).savePreferences(project);
            FirstTimeStartUpWizard.this.connectionConfigPane.savePreferences();
            try {
                InstanceManager.getDefault(WarrantPreferences.class).initialize(project);
            }
            catch (InitializationException ex) {
                log.error("Exception Initialising warrant preferences: ", (Throwable)ex);
            }
            InstanceManager.getDefault(ConfigureManager.class).storePrefs();
            FirstTimeStartUpWizard.this.dispose();
        }
    }
}

