/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.dp3;

import apps.gui3.dp3.Bundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.decoderdefn.PrintDecoderListAction;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.progsupport.ProgServiceModeComboBox;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterMenu;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CombinedLocoSelTreePane;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.DccAddressPanel;
import jmri.jmrit.symbolicprog.DccAddressVarHandler;
import jmri.jmrit.symbolicprog.EnumVariableValue;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.jmrit.symbolicprog.tabbedframe.PaneContainer;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgPane;
import jmri.jmrit.symbolicprog.tabbedframe.PaneServiceProgFrame;
import jmri.util.BusyGlassPane;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneProgDp3Action
extends JmriAbstractAction
implements ProgListener,
PaneContainer {
    Object o1;
    Object o2;
    Object o3;
    Object o4;
    JLabel statusLabel;
    final ProgModeSelector modePane = new ProgServiceModeComboBox();
    JmriJFrame f;
    CombinedLocoSelTreePane combinedLocoSelTree;
    String lastSelectedProgrammer = this.getClass().getName() + ".SelectedProgrammer";
    JTextField rosterIdField = new JTextField(20);
    JTextField rosterAddressField = new JTextField(10);
    RosterEntry re;
    int teststatus = 0;
    DecoderFile decoderFile;
    boolean shortAddr = false;
    int cv29 = 0;
    int cv17 = -1;
    int cv18 = -1;
    int cv19 = 0;
    int cv1 = 0;
    int longAddress;
    String address = "3";
    JPanel rosterPanel = null;
    Programmer mProgrammer;
    CvTableModel cvModel = null;
    VariableTableModel variableModel;
    DccAddressPanel dccAddressPanel;
    Element modelElem = null;
    ThisProgPane progPane = null;
    boolean longMode = false;
    String newAddr = null;
    JButton saveBasicRoster;
    VariableValue primaryAddr = null;
    VariableValue extendAddr = null;
    EnumVariableValue addMode = null;
    private static final Logger log = LoggerFactory.getLogger(PaneProgDp3Action.class);

    public PaneProgDp3Action(String s, WindowInterface wi) {
        super(s, wi);
        this.init();
    }

    public PaneProgDp3Action(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this.init();
    }

    public PaneProgDp3Action() {
        this(Bundle.getMessage("Name"));
    }

    public PaneProgDp3Action(String s) {
        super(s);
        this.init();
    }

    void init() {
        this.statusLabel = new JLabel(SymbolicProgBundle.getMessage("StateIdle"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Pane programmer requested");
        if (this.f == null) {
            log.debug("found f==null");
            this.f = new JmriJFrame(Bundle.getMessage("FrameProgrammerSetup"));
            this.f.getContentPane().setLayout(new BorderLayout());
            this.f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    PaneProgDp3Action.this.statusLabel.setText(SymbolicProgBundle.getMessage("StateIdle"));
                    PaneProgDp3Action.this.f.windowClosing(we);
                }
            });
            JMenuBar menuBar = new JMenuBar();
            JMenu j = new JMenu(SymbolicProgBundle.getMessage("MenuFile"));
            j.add(new PrintDecoderListAction(SymbolicProgBundle.getMessage("MenuPrintDecoderDefinitions"), this.f, false));
            j.add(new PrintDecoderListAction(SymbolicProgBundle.getMessage("MenuPrintPreviewDecoderDefinitions"), this.f, true));
            menuBar.add(j);
            menuBar.add(new RosterMenu(SymbolicProgBundle.getMessage("MenuRoster"), 1, this.f));
            this.f.setJMenuBar(menuBar);
            final JPanel bottomPanel = new JPanel(new BorderLayout());
            this.combinedLocoSelTree = new CombinedLocoSelTreePane(this.statusLabel, this.modePane){

                @Override
                protected void startProgrammer(DecoderFile decoderFile, @Nonnull RosterEntry re, @Nonnull String progName) {
                    log.debug("startProgrammer");
                    String title = MessageFormat.format(SymbolicProgBundle.getMessage("FrameServiceProgrammerTitle"), re.getId());
                    PaneProgFrame p = !PaneProgDp3Action.this.modePane.isSelected() || PaneProgDp3Action.this.modePane.getProgrammer() == null ? new PaneProgFrame(decoderFile, re, title, "programmers" + File.separator + "Comprehensive.xml", null, false){

                        @Override
                        protected JPanel getModePane() {
                            return null;
                        }
                    } : new PaneServiceProgFrame(decoderFile, re, title, "programmers" + File.separator + "Comprehensive.xml", PaneProgDp3Action.this.modePane.getProgrammer());
                    ((Window)p).pack();
                    p.setVisible(true);
                }

                @Override
                protected void openNewLoco() {
                    log.debug("openNewLoco");
                    DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(this.selectedDecoderType());
                    log.debug("decoder file: {}", (Object)decoderFile.getFileName());
                    if (PaneProgDp3Action.this.rosterIdField.getText().equals(SymbolicProgBundle.getMessage("LabelNewDecoder"))) {
                        PaneProgDp3Action.this.re = new RosterEntry();
                        PaneProgDp3Action.this.re.setDecoderFamily(decoderFile.getFamily());
                        PaneProgDp3Action.this.re.setDecoderModel(decoderFile.getModel());
                        PaneProgDp3Action.this.re.setProgrammingModes(decoderFile.getProgrammingModes());
                        PaneProgDp3Action.this.re.setId(SymbolicProgBundle.getMessage("LabelNewDecoder"));
                        Roster.getDefault().addEntry(PaneProgDp3Action.this.re);
                    } else {
                        try {
                            PaneProgDp3Action.this.saveRosterEntry();
                        }
                        catch (JmriException ex) {
                            log.warn("Exception while saving roster entry", (Throwable)ex);
                            return;
                        }
                    }
                    this.startProgrammer(decoderFile, PaneProgDp3Action.this.re, "");
                    PaneProgDp3Action.this.re = null;
                }

                @Override
                protected JPanel layoutRosterSelection() {
                    log.debug("layoutRosterSelection");
                    return null;
                }

                @Override
                protected JPanel layoutDecoderSelection() {
                    log.debug("layoutDecoderSelection");
                    JPanel pan = super.layoutDecoderSelection();
                    this.dTree.removeTreeSelectionListener(this.dListener);
                    this.dListener = e1 -> {
                        if (!this.dTree.isSelectionEmpty() && this.dTree.getSelectionPath() != null && ((TreeNode)this.dTree.getSelectionPath().getLastPathComponent()).isLeaf() && this.dTree.getSelectionPath().getPathCount() > 2 && this.dTree.getSelectionCount() < 2) {
                            log.debug("Selection event with {}", (Object)this.dTree.getSelectionPath());
                            this.go2.setEnabled(true);
                            this.go2.setRequestFocusEnabled(true);
                            this.go2.requestFocus();
                            this.go2.setToolTipText(SymbolicProgBundle.getMessage("TipClickToOpen"));
                            PaneProgDp3Action.this.decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(this.selectedDecoderType());
                            PaneProgDp3Action.this.setUpRosterPanel();
                        } else {
                            PaneProgDp3Action.this.decoderFile = null;
                            this.go2.setEnabled(false);
                            this.go2.setToolTipText(SymbolicProgBundle.getMessage("TipSelectLoco"));
                            PaneProgDp3Action.this.setUpRosterPanel();
                        }
                    };
                    this.dTree.addTreeSelectionListener(this.dListener);
                    return pan;
                }

                @Override
                protected void selectDecoder(int mfgID, int modelID, int productID) {
                    log.debug("selectDecoder");
                    super.selectDecoder(mfgID, modelID, productID);
                    PaneProgDp3Action.this.findDecoderAddress();
                }

                @Override
                protected JPanel createProgrammerSelection() {
                    log.debug("createProgrammerSelection");
                    JPanel pane3a = new JPanel();
                    pane3a.setLayout(new BoxLayout(pane3a, 1));
                    this.go2 = new JButton(Bundle.getMessage("OpenProgrammer"));
                    this.go2.getAccessibleContext().setAccessibleName(Bundle.getMessage("OpenProgrammer"));
                    this.go2.addActionListener(e1 -> {
                        log.debug("Open programmer pressed");
                        this.openButton();
                        log.debug("Closing f {}", (Object)PaneProgDp3Action.this.f);
                        WindowEvent wev = new WindowEvent(PaneProgDp3Action.this.f, 201);
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
                    });
                    this.go2.setAlignmentX(1.0f);
                    this.go2.setEnabled(false);
                    this.go2.setToolTipText(SymbolicProgBundle.getMessage("TipSelectLoco"));
                    bottomPanel.add((Component)this.go2, "East");
                    return pane3a;
                }
            };
            JPanel topPanel = new JPanel();
            topPanel.add(this.modePane);
            topPanel.add(new JSeparator(0));
            this.f.getContentPane().add((Component)topPanel, "North");
            this.combinedLocoSelTree.setAlignmentX(0.5f);
            this.f.getContentPane().add((Component)this.combinedLocoSelTree, "Center");
            this.statusLabel.setAlignmentX(0.5f);
            bottomPanel.add((Component)this.statusLabel, "South");
            this.f.getContentPane().add((Component)bottomPanel, "South");
            this.f.pack();
            log.debug("Tab-Programmer setup created");
        } else {
            this.re = null;
            this.combinedLocoSelTree.resetSelections();
        }
        this.f.setVisible(true);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }

    synchronized void findDecoderAddress() {
        this.teststatus = 1;
        this.readCV("29");
    }

    @Override
    public synchronized void programmingOpReply(int value, int status) {
        switch (this.teststatus) {
            case 1: {
                this.teststatus = 2;
                this.cv29 = value;
                this.readCV("1");
                break;
            }
            case 2: {
                this.teststatus = 3;
                this.cv1 = value;
                this.readCV("17");
                break;
            }
            case 3: {
                this.teststatus = 4;
                this.cv17 = value;
                this.readCV("18");
                break;
            }
            case 4: {
                this.teststatus = 5;
                this.cv18 = value;
                this.readCV("19");
                break;
            }
            case 5: {
                this.cv19 = value;
                this.finishRead();
                break;
            }
            default: {
                log.error("unknown test state {}", (Object)this.teststatus);
            }
        }
    }

    synchronized void finishRead() {
        if ((this.cv29 & 0x20) == 0) {
            this.shortAddr = true;
            this.address = "" + this.cv1;
        }
        if (this.cv17 != -1 || this.cv18 != -1) {
            this.longAddress = (this.cv17 & 0x3F) * 256 + this.cv18;
            this.address = "" + this.longAddress;
        }
        if (this.progPane != null) {
            this.progPane.setVariableValue("Short Address", this.cv1);
            this.progPane.setVariableValue("Long Address", this.longAddress);
            this.progPane.setCVValue("29", this.cv29);
            this.progPane.setCVValue("19", this.cv19);
        }
    }

    protected void readCV(String cv) {
        Programmer p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        if (p != null) {
            try {
                p.readCV(cv, this);
            }
            catch (ProgrammerException programmerException) {
                // empty catch block
            }
        }
    }

    synchronized void setUpRosterPanel() {
        Element decoderRoot;
        this.re = null;
        if (this.rosterPanel == null) {
            this.rosterPanel = new JPanel();
            this.rosterPanel.setLayout(new BorderLayout());
            JPanel p = new JPanel();
            p.add(new JLabel(Bundle.getMessage("RosterId")));
            p.add(this.rosterIdField);
            this.rosterPanel.add((Component)p, "North");
            this.rosterIdField.setText(SymbolicProgBundle.getMessage("LabelNewDecoder"));
            this.saveBasicRoster = new JButton(Bundle.getMessage("Save"));
            this.saveBasicRoster.addActionListener(e -> {
                try {
                    log.debug("saveBasicRoster button pressed, calls saveRosterEntry");
                    this.saveRosterEntry();
                }
                catch (JmriException jmriException) {
                    // empty catch block
                }
            });
            TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            border.setTitle(Bundle.getMessage("CreateBasicRosterEntry"));
            this.rosterPanel.setBorder(border);
            this.rosterPanel.setVisible(false);
            this.f.getContentPane().add((Component)this.rosterPanel, "East");
        } else {
            this.rosterIdField.setText(SymbolicProgBundle.getMessage("LabelNewDecoder"));
        }
        if (this.progPane != null) {
            this.progPane.dispose();
            this.rosterPanel.remove(this.progPane);
            this.progPane = null;
            this.rosterPanel.revalidate();
            this.f.getContentPane().repaint();
            this.f.repaint();
            this.f.pack();
        }
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable()) {
            this.mProgrammer = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        }
        this.cvModel = new CvTableModel(this.statusLabel, this.mProgrammer);
        this.variableModel = new VariableTableModel(this.statusLabel, new String[]{"Name", "Value"}, this.cvModel);
        if (this.decoderFile != null) {
            try {
                decoderRoot = this.decoderFile.rootFromName(DecoderFile.fileLocation + this.decoderFile.getFileName());
            }
            catch (IOException | JDOMException e2) {
                log.error("Exception while loading decoder XML file: {}", (Object)this.decoderFile.getFileName(), (Object)e2);
                return;
            }
        } else {
            this.rosterPanel.setVisible(false);
            return;
        }
        this.modelElem = this.decoderFile.getModelElement();
        this.decoderFile.loadVariableModel(decoderRoot.getChild("decoder"), this.variableModel);
        this.rosterPanel.setVisible(true);
        XmlFile pf = new XmlFile(){};
        PropertyChangeListener dccNews = e -> this.updateDccAddress();
        this.primaryAddr = this.variableModel.findVar("Short Address");
        if (this.primaryAddr == null) {
            log.debug("DCC Address monitor didn't find a Short Address variable");
        } else {
            this.primaryAddr.addPropertyChangeListener(dccNews);
        }
        this.extendAddr = this.variableModel.findVar("Long Address");
        if (this.extendAddr == null) {
            log.debug("DCC Address monitor didn't find a Long Address variable");
        } else {
            this.extendAddr.addPropertyChangeListener(dccNews);
        }
        this.addMode = (EnumVariableValue)this.variableModel.findVar("Address Format");
        if (this.addMode == null) {
            log.debug("DCC Address monitor didn't find an Address Format variable");
        } else {
            this.addMode.addPropertyChangeListener(dccNews);
        }
        try {
            Element programmerRoot = pf.rootFromName("programmers" + File.separator + "Basic.xml");
            Element base = programmerRoot.getChild("programmer");
            if (base == null) {
                log.error("xml file top element is not programmer");
                return;
            }
            List paneList = base.getChildren("pane");
            log.debug("will process {} pane definitions", (Object)paneList.size());
            String name = LocaleSelector.getAttribute((Element)paneList.get(0), "name");
            this.progPane = new ThisProgPane(this, name, (Element)paneList.get(0), this.cvModel, this.variableModel, this.modelElem);
            this.progPane.setVariableValue("Short Address", this.cv1);
            this.progPane.setVariableValue("Long Address", this.longAddress);
            this.progPane.setCVValue("29", this.cv29);
            this.progPane.setCVValue("19", this.cv19);
            this.rosterPanel.add((Component)this.progPane, "Center");
            this.rosterPanel.revalidate();
            this.rosterPanel.setVisible(true);
            this.f.getContentPane().repaint();
            this.f.repaint();
            this.f.pack();
        }
        catch (IOException | JDOMException e3) {
            log.error("exception reading programmer file: ", e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDccAddress() {
        if (log.isDebugEnabled()) {
            log.debug("updateDccAddress: short {} long {} mode {}", new Object[]{this.primaryAddr == null ? "<null>" : this.primaryAddr.getValueString(), this.extendAddr == null ? "<null>" : this.extendAddr.getValueString(), this.addMode == null ? "<null>" : this.addMode.getValueString()});
        }
        new DccAddressVarHandler(this.primaryAddr, this.extendAddr, this.addMode){

            @Override
            protected void doPrimary() {
                PaneProgDp3Action.this.longMode = false;
                if (PaneProgDp3Action.this.primaryAddr != null && !PaneProgDp3Action.this.primaryAddr.getValueString().isEmpty()) {
                    PaneProgDp3Action.this.newAddr = PaneProgDp3Action.this.primaryAddr.getValueString();
                }
            }

            @Override
            protected void doExtended() {
                if (!PaneProgDp3Action.this.extendAddr.getValueString().isEmpty()) {
                    PaneProgDp3Action.this.longMode = true;
                    PaneProgDp3Action.this.newAddr = PaneProgDp3Action.this.extendAddr.getValueString();
                }
            }
        };
        if (this.newAddr != null) {
            PaneProgDp3Action paneProgDp3Action = this;
            synchronized (paneProgDp3Action) {
                this.address = this.newAddr;
                this.shortAddr = !this.longMode;
            }
        }
    }

    boolean checkDuplicate() {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, this.rosterIdField.getText());
        boolean oops = false;
        for (RosterEntry rosterEntry : l) {
            if (this.re == rosterEntry) continue;
            oops = true;
            break;
        }
        return oops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveRosterEntry() throws JmriException {
        log.debug("saveRosterEntry");
        if (this.rosterIdField.getText().equals(SymbolicProgBundle.getMessage("LabelNewDecoder"))) {
            PaneProgDp3Action paneProgDp3Action = this;
            synchronized (paneProgDp3Action) {
                JmriJOptionPane.showMessageDialog(this.progPane, SymbolicProgBundle.getMessage("PromptFillInID"));
            }
            throw new JmriException("No Roster ID");
        }
        if (this.checkDuplicate()) {
            PaneProgDp3Action paneProgDp3Action = this;
            synchronized (paneProgDp3Action) {
                JmriJOptionPane.showMessageDialog(this.progPane, SymbolicProgBundle.getMessage("ErrorDuplicateID"));
            }
            throw new JmriException("Duplicate ID");
        }
        if (this.re == null) {
            log.debug("re null, creating RosterEntry");
            this.re = new RosterEntry();
            this.re.setDecoderFamily(this.decoderFile.getFamily());
            this.re.setDecoderModel(this.decoderFile.getModel());
            this.re.setId(this.rosterIdField.getText());
            this.re.setDeveloperID(this.decoderFile.getDeveloperID());
            this.re.setManufacturerID(this.decoderFile.getManufacturerID());
            this.re.setProductID(this.decoderFile.getProductID());
            this.re.setProgrammingModes(this.decoderFile.getProgrammingModes());
            Roster.getDefault().addEntry(this.re);
        }
        this.updateDccAddress();
        this.re.ensureFilenameExists();
        String filename = this.re.getFileName();
        log.debug("setting DCC address {} {}", (Object)this.address, (Object)this.shortAddr);
        PaneProgDp3Action paneProgDp3Action = this;
        synchronized (paneProgDp3Action) {
            this.re.setDccAddress(this.address);
            this.re.setLongAddress(!this.shortAddr);
            this.re.writeFile(this.cvModel, this.variableModel);
            this.variableModel.setFileDirty(false);
        }
        FileUtil.createDirectory(FileUtil.getUserFilesPath());
        Roster.getDefault().writeRoster();
        this.statusLabel.setText(MessageFormat.format(SymbolicProgBundle.getMessage("StateSaveOK"), filename));
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void paneFinished() {
    }

    @Override
    public void enableButtons(boolean enable) {
    }

    @Override
    public void prepGlassPane(AbstractButton activeButton) {
    }

    @Override
    public synchronized BusyGlassPane getBusyGlassPane() {
        return new BusyGlassPane(new ArrayList<JComponent>(), new ArrayList<Rectangle>(), this.rosterPanel, this.f);
    }

    class ThisProgPane
    extends PaneProgPane {
        public ThisProgPane(PaneContainer parent, String name, Element pane, CvTableModel cvModel, VariableTableModel varModel, Element modelElem) {
            super(parent, name, pane, cvModel, varModel, modelElem, PaneProgDp3Action.this.re);
            this.bottom.remove(this.readChangesButton);
            this.bottom.remove(this.writeChangesButton);
            this.writeAllButton.setText(SymbolicProgBundle.getMessage("ButtonWrite"));
            this.readAllButton.setText(SymbolicProgBundle.getMessage("ButtonRead"));
            this.bottom.add(PaneProgDp3Action.this.saveBasicRoster);
            this.bottom.revalidate();
            this.readAllButton.removeItemListener(this.l2);
            this.l2 = e -> {
                if (e.getStateChange() == 1) {
                    this.readAllButton.setText(SymbolicProgBundle.getMessage("ButtonStopReadSheet"));
                    if (!this.container.isBusy()) {
                        this.prepReadPane(false);
                        PaneProgDp3Action.this.prepGlassPane(this.readAllButton);
                        this.container.getBusyGlassPane().setVisible(true);
                        this.readPaneAll();
                    }
                } else {
                    this.stopProgramming();
                    this.readAllButton.setText(SymbolicProgBundle.getMessage("ButtonRead"));
                    if (this.container.isBusy()) {
                        this.readAllButton.setEnabled(false);
                    }
                }
            };
            this.readAllButton.addItemListener(this.l2);
            this.writeAllButton.removeItemListener(this.l4);
            this.l4 = e -> {
                if (e.getStateChange() == 1) {
                    this.writeAllButton.setText(SymbolicProgBundle.getMessage("ButtonStopWriteSheet"));
                    if (!this.container.isBusy()) {
                        this.prepWritePane(false);
                        PaneProgDp3Action.this.prepGlassPane(this.writeAllButton);
                        this.container.getBusyGlassPane().setVisible(true);
                        this.writePaneAll();
                    }
                } else {
                    this.stopProgramming();
                    this.writeAllButton.setText(SymbolicProgBundle.getMessage("ButtonWrite"));
                    if (this.container.isBusy()) {
                        this.writeAllButton.setEnabled(false);
                    }
                }
            };
            this.writeAllButton.addItemListener(this.l4);
            if (this._cvModel.getProgrammer() == null) {
                this.bottom.remove(this.readAllButton);
                this.bottom.remove(this.writeAllButton);
                this.bottom.revalidate();
                this.add(this.bottom);
            }
        }

        public void setCVValue(String cv, int value) {
            if (this._cvModel.getCvByNumber(cv) != null) {
                this._cvModel.getCvByNumber(cv).setValue(value);
                this._cvModel.getCvByNumber(cv).setState(AbstractValue.ValueState.READ);
            }
        }

        public void setVariableValue(String variable, int value) {
            if (this._varModel.findVar(variable) != null) {
                this._varModel.findVar(variable).setIntValue(value);
                this._varModel.findVar(variable).setState(AbstractValue.ValueState.READ);
            }
        }

        @Override
        public void dispose() {
            this.bottom.remove(PaneProgDp3Action.this.saveBasicRoster);
            super.dispose();
        }
    }
}

