/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.lccpro;

import apps.gui3.Apps3;
import apps.gui3.FirstTimeStartUpWizard;
import apps.gui3.FirstTimeStartUpWizardAction;
import apps.gui3.lccpro.Bundle;
import apps.gui3.lccpro.LccProWindow;
import apps.gui3.tabbedpreferences.TabbedPreferencesAction;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LccPro
extends Apps3 {
    private static String menuFile = null;
    private static String toolbarFile = null;
    private static final String applicationName = "LccPro";
    private static final Logger log = LoggerFactory.getLogger(LccPro.class);

    public LccPro(String[] args) {
        super(applicationName, "LccProConfig.xml", args);
    }

    public static synchronized String getMenuFile() {
        if (menuFile == null) {
            menuFile = "lccpro/Gui3Menus.xml";
            File file = new File(menuFile);
            if (!file.isAbsolute()) {
                menuFile = FileUtil.getUserFilesPath() + "lccpro/Gui3Menus.xml";
                file = new File(menuFile);
            }
            if (!file.exists()) {
                menuFile = "xml/config/parts/apps/gui3/lccpro/LccProFrameMenu.xml";
            } else {
                log.info("Found user created menu structure this will be used instead of the system default");
            }
        }
        return menuFile;
    }

    public static synchronized String getToolbarFile() {
        if (toolbarFile == null) {
            toolbarFile = "lccpro/Gui3MainToolBar.xml";
            File file = new File(toolbarFile);
            if (!file.isAbsolute()) {
                toolbarFile = FileUtil.getUserFilesPath() + "lccpro/Gui3MainToolBar.xml";
                file = new File(toolbarFile);
            }
            if (!file.exists()) {
                toolbarFile = "xml/config/parts/apps/gui3/lccpro/LccProFrameToolBar.xml";
            } else {
                log.info("Found user created toolbar structure this will be used instead of the system default");
            }
        }
        return toolbarFile;
    }

    @Override
    protected boolean wizardLaunchCheck() {
        CanSystemConnectionMemo memo = InstanceManager.getNullableDefault(CanSystemConnectionMemo.class);
        return memo == null;
    }

    @Override
    public void launchFirstTimeStartupWizard() {
        FirstTimeStartUpWizardAction prefsAction = new FirstTimeStartUpWizardAction("Start Up Wizard"){

            @Override
            public FirstTimeStartUpWizard makeWizard(JmriJFrame f, Apps3 app) {
                f.setTitle("LccPro Wizard");
                return new FirstTimeStartUpWizard(f, app){

                    @Override
                    protected void customizeConnection() {
                        this.connectionConfigPane.manuBox.setSelectedItem("LCC");
                        this.connectionConfigPane.manuBox.setEnabled(false);
                    }

                    @Override
                    protected String firstPrompt() {
                        return "Next you need to configure your LCC connection.\n\nThen select the serial port or enter in the IP address of the device";
                    }
                };
            }
        };
        prefsAction.setApp(this);
        prefsAction.actionPerformed(null);
    }

    @Override
    protected void createMainFrame() {
        this.mainFrame = new LccProWindow(LccPro.getMenuFile(), LccPro.getToolbarFile());
    }

    @Override
    protected void displayMainFrame(Dimension d) {
        UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        if (!p.hasProperties(this.mainFrame.getWindowFrameRef())) {
            this.mainFrame.setSize(new Dimension(1024, 600));
            this.mainFrame.setPreferredSize(new Dimension(1024, 600));
        }
        this.mainFrame.setVisible(true);
    }

    public static void main(String[] args) {
        LccPro.preInit(args);
        LccPro app = new LccPro(args);
        app.start();
    }

    public static void preInit(String[] args) {
        Apps3.preInit(applicationName);
        Apps3.setConfigFilename("LccProConfig.xml", args);
    }

    @Override
    protected void start() {
        super.start();
        if (!(this.configOK && this.configDeferredLoadOK || !this.preferenceFileExists)) {
            TabbedPreferencesAction prefsAction = new TabbedPreferencesAction(Bundle.getMessage("MenuItemPreferences"));
            prefsAction.actionPerformed(null);
        }
        ThreadingUtil.runOnGUI(() -> {
            try {
                DecoderIndexFile.updateIndexIfNeeded();
            }
            catch (IOException | JDOMException e) {
                log.error("Exception trying to pre-load decoderIndex", e);
            }
        });
    }
}

