/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.tabbedpreferences;

import apps.AppConfigBase;
import apps.ConfigBundle;
import apps.gui3.tabbedpreferences.Bundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BooleanSupplier;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jmri.InstanceManager;
import jmri.ReferenceNotNull;
import jmri.ShutDownManager;
import jmri.swing.PreferencesPanel;
import jmri.swing.PreferencesSubPanel;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedPreferences
extends AppConfigBase {
    ArrayList<Element> preferencesElements = new ArrayList();
    JPanel detailpanel = new JPanel();
    ArrayList<PreferencesCatItems> preferencesArray;
    JPanel buttonpanel;
    JList<String> list;
    JButton save;
    JScrollPane listScroller;
    private static final Logger log = LoggerFactory.getLogger(TabbedPreferences.class);

    @Override
    public String getHelpTarget() {
        return "package.apps.TabbedPreferences";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("TitlePreferences");
    }

    @Override
    public boolean isMultipleInstances() {
        return false;
    }

    public TabbedPreferences() {
        this.detailpanel.setLayout(new CardLayout());
        this.preferencesArray = new ArrayList();
        this.preferencesArray.add(new PreferencesCatItems("CONNECTIONS", rb.getString("MenuConnections"), 100));
        this.preferencesArray.add(new PreferencesCatItems("DEFAULTS", rb.getString("MenuDefaults"), 200));
        this.preferencesArray.add(new PreferencesCatItems("FILELOCATIONS", rb.getString("MenuFileLocation"), 300));
        this.preferencesArray.add(new PreferencesCatItems("STARTUP", rb.getString("MenuStartUp"), 400));
        this.preferencesArray.add(new PreferencesCatItems("DISPLAY", rb.getString("MenuDisplay"), 500));
        this.preferencesArray.add(new PreferencesCatItems("MESSAGES", rb.getString("MenuMessages"), 600));
        this.preferencesArray.add(new PreferencesCatItems("ROSTER", rb.getString("MenuRoster"), 700));
        this.preferencesArray.add(new PreferencesCatItems("THROTTLE", rb.getString("MenuThrottle"), 800));
        this.preferencesArray.add(new PreferencesCatItems("WITHROTTLE", rb.getString("MenuWiThrottle"), 900));
        this.init();
    }

    private void init() {
        String parent;
        this.list = new JList();
        this.listScroller = new JScrollPane(this.list);
        this.listScroller.setPreferredSize(new Dimension(100, 100));
        this.buttonpanel = new JPanel();
        this.buttonpanel.setLayout(new BoxLayout(this.buttonpanel, 1));
        this.buttonpanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 3));
        this.detailpanel = new JPanel();
        this.detailpanel.setLayout(new CardLayout());
        this.detailpanel.setBorder(BorderFactory.createEmptyBorder(6, 3, 6, 6));
        this.save = new JButton(ConfigBundle.getMessage("ButtonSave"), new ImageIcon(FileUtil.findURL("program:resources/icons/misc/gui3/SaveIcon.png", FileUtil.Location.INSTALLED)));
        this.save.addActionListener(e -> this.savePressed(this.invokeSaveOptions()));
        this.setLayout(new BoxLayout(this, 0));
        HashSet<PreferencesPanel> delayed = new HashSet<PreferencesPanel>();
        for (PreferencesPanel panel2 : InstanceManager.getList(PreferencesPanel.class)) {
            if (panel2 instanceof PreferencesSubPanel) {
                parent = ((PreferencesSubPanel)panel2).getParentClassName();
                if (!this.getPreferencesPanels().containsKey(parent)) {
                    delayed.add(panel2);
                } else {
                    ((PreferencesSubPanel)panel2).setParent(this.getPreferencesPanels().get(parent));
                }
            }
            if (delayed.contains(panel2)) continue;
            this.addPreferencesPanel(panel2);
        }
        for (PreferencesPanel panel2 : ServiceLoader.load(PreferencesPanel.class)) {
            if (panel2 instanceof PreferencesSubPanel) {
                parent = ((PreferencesSubPanel)panel2).getParentClassName();
                if (!this.getPreferencesPanels().containsKey(parent)) {
                    delayed.add(panel2);
                } else {
                    ((PreferencesSubPanel)panel2).setParent(this.getPreferencesPanels().get(parent));
                }
            }
            if (delayed.contains(panel2)) continue;
            this.addPreferencesPanel(panel2);
        }
        while (!delayed.isEmpty()) {
            HashSet iterated = new HashSet(delayed);
            iterated.stream().filter(panel -> panel instanceof PreferencesSubPanel).forEach(panel -> {
                String parent = ((PreferencesSubPanel)panel).getParentClassName();
                if (this.getPreferencesPanels().containsKey(parent)) {
                    ((PreferencesSubPanel)panel).setParent(this.getPreferencesPanels().get(parent));
                    delayed.remove(panel);
                    this.addPreferencesPanel((PreferencesPanel)panel);
                }
            });
        }
        this.preferencesArray.stream().forEach(preferences -> this.detailpanel.add((Component)preferences.getPanel(), preferences.getPrefItem()));
        this.preferencesArray.sort((o1, o2) -> {
            int comparison = Integer.compare(o1.sortOrder, o2.sortOrder);
            return comparison != 0 ? comparison : o1.getPrefItem().compareTo(o2.getPrefItem());
        });
        this.updateJList();
        this.add(this.buttonpanel);
        this.add(new JSeparator(1));
        this.add(this.detailpanel);
        this.list.setSelectedIndex(0);
        this.selection(this.preferencesArray.get(0).getPrefItem());
    }

    boolean isDirty() {
        return this.getPreferencesPanels().values().stream().map(panel -> {
            if (log.isDebugEnabled()) {
                log.debug("PreferencesPanel {} ({}) is {}.", new Object[]{panel.getClass().getName(), panel.getTabbedPreferencesTitle() != null ? panel.getTabbedPreferencesTitle() : panel.getPreferencesItemText(), panel.isDirty() ? "dirty" : "clean"});
            }
            return panel;
        }).anyMatch(panel -> panel.isDirty());
    }

    boolean invokeSaveOptions() {
        boolean restartRequired = false;
        for (PreferencesPanel panel : this.getPreferencesPanels().values()) {
            if (log.isDebugEnabled()) {
                log.debug("PreferencesPanel {} ({}) is {}.", new Object[]{panel.getClass().getName(), panel.getTabbedPreferencesTitle() != null ? panel.getTabbedPreferencesTitle() : panel.getPreferencesItemText(), panel.isDirty() ? "dirty" : "clean"});
            }
            panel.savePreferences();
            if (log.isDebugEnabled()) {
                log.debug("PreferencesPanel {} ({}) restart is {}required.", new Object[]{panel.getClass().getName(), panel.getTabbedPreferencesTitle() != null ? panel.getTabbedPreferencesTitle() : panel.getPreferencesItemText(), panel.isRestartRequired() ? "" : "not "});
            }
            if (restartRequired) continue;
            restartRequired = panel.isRestartRequired();
        }
        return restartRequired;
    }

    void selection(String view) {
        CardLayout cl = (CardLayout)this.detailpanel.getLayout();
        cl.show(this.detailpanel, view);
    }

    public void addPreferencesPanel(PreferencesPanel panel) {
        this.getPreferencesPanels().put(panel.getClass().getName(), panel);
        this.addItem(panel.getPreferencesItem(), panel.getPreferencesItemText(), panel.getTabbedPreferencesTitle(), panel.getLabelKey(), panel, panel.getPreferencesTooltip(), panel.getSortOrder());
    }

    private void addItem(String prefItem, String itemText, String tabTitle, String labelKey, PreferencesPanel item, String tooltip, int sortOrder) {
        PreferencesCatItems itemBeingAdded = null;
        for (PreferencesCatItems preferences : this.preferencesArray) {
            if (!preferences.getPrefItem().equals(prefItem)) continue;
            itemBeingAdded = preferences;
            if (sortOrder >= preferences.sortOrder) break;
            preferences.sortOrder = sortOrder;
            break;
        }
        if (itemBeingAdded == null) {
            itemBeingAdded = new PreferencesCatItems(prefItem, itemText, sortOrder, item.getIsEnabled());
            this.preferencesArray.add(itemBeingAdded);
            this.updateJList();
        }
        if (tabTitle == null) {
            tabTitle = itemText;
        }
        itemBeingAdded.addPreferenceItem(tabTitle, labelKey, item.getPreferencesComponent(), tooltip, sortOrder);
    }

    public void gotoPreferenceItem(String selection, String subCategory) {
        this.selection(selection);
        this.list.setSelectedIndex(this.getCategoryIndexFromString(selection));
        if (subCategory == null || subCategory.isEmpty()) {
            return;
        }
        this.preferencesArray.get(this.getCategoryIndexFromString(selection)).gotoSubCategory(subCategory);
    }

    public List<String> getPreferenceMenuList() {
        ArrayList<String> choices = new ArrayList<String>();
        for (PreferencesCatItems preferences : this.preferencesArray) {
            choices.add(preferences.getPrefItem());
        }
        return choices;
    }

    public List<String> getPreferenceSubCategory(String category) {
        int index = this.getCategoryIndexFromString(category);
        return this.preferencesArray.get(index).getSubCategoriesList();
    }

    int getCategoryIndexFromString(String category) {
        for (int x = 0; x < this.preferencesArray.size(); ++x) {
            if (!this.preferencesArray.get(x).getPrefItem().equals(category)) continue;
            return x;
        }
        return -1;
    }

    public void disablePreferenceItem(String selection, String subCategory) {
        if (subCategory != null && !subCategory.isEmpty()) {
            this.preferencesArray.get(this.getCategoryIndexFromString(selection)).disableSubCategory(subCategory);
        }
    }

    protected ArrayList<String> getChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        for (PreferencesCatItems preferences : this.preferencesArray) {
            choices.add(preferences.getItemString());
        }
        return choices;
    }

    void updateJList() {
        this.buttonpanel.removeAll();
        if (this.list.getListSelectionListeners().length > 0) {
            this.list.removeListSelectionListener(this.list.getListSelectionListeners()[0]);
        }
        ArrayList<String> choices = this.getChoices();
        this.list = new JList<String>(choices.toArray(new String[choices.size()]));
        this.listScroller = new JScrollPane(this.list);
        this.listScroller.setPreferredSize(new Dimension(100, 100));
        this.list.setSelectionMode(1);
        this.list.setLayoutOrientation(0);
        ReferenceNotNull<Integer> lastSelection = new ReferenceNotNull<Integer>(-1);
        this.list.addListSelectionListener(e -> {
            PreferencesCatItems item = this.preferencesArray.get(this.list.getSelectedIndex());
            String newSelection = item.getPrefItem();
            BooleanSupplier getIsEnabled = item.getIsEnabled;
            if (this.list.getSelectedIndex() != ((Integer)lastSelection.get()).intValue() && getIsEnabled != null && !getIsEnabled.getAsBoolean()) {
                this.list.setSelectedIndex((Integer)lastSelection.get());
            } else {
                lastSelection.set(this.list.getSelectedIndex());
                this.selection(newSelection);
            }
        });
        this.buttonpanel.add(this.listScroller);
        this.buttonpanel.add(this.save);
    }

    public boolean isPreferencesValid() {
        return this.getPreferencesPanels().values().stream().allMatch(panel -> panel.isPreferencesValid());
    }

    @Override
    public void savePressed(boolean restartRequired) {
        ShutDownManager sdm = InstanceManager.getDefault(ShutDownManager.class);
        if (!this.isPreferencesValid() && !sdm.isShuttingDown()) {
            for (PreferencesPanel panel : this.getPreferencesPanels().values()) {
                if (panel.isPreferencesValid()) continue;
                switch (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("InvalidPreferencesMessage", panel.getTabbedPreferencesTitle()), Bundle.getMessage("InvalidPreferencesTitle"), 0, 0)) {
                    case 0: {
                        this.gotoPreferenceItem(panel.getPreferencesItem(), panel.getTabbedPreferencesTitle());
                        return;
                    }
                }
            }
        }
        super.savePressed(restartRequired);
    }

    static class PreferencesCatItems
    implements Serializable {
        String itemText;
        String prefItem;
        int sortOrder = Integer.MAX_VALUE;
        BooleanSupplier getIsEnabled;
        JTabbedPane tabbedPane = new JTabbedPane();
        ArrayList<String> disableItemsList = new ArrayList();
        private final ArrayList<TabDetails> tabDetailsArray = new ArrayList();

        PreferencesCatItems(String pref, String title, int sortOrder) {
            this.prefItem = pref;
            this.itemText = title;
            this.sortOrder = sortOrder;
        }

        PreferencesCatItems(String pref, String title, int sortOrder, BooleanSupplier getIsEnabled) {
            this.prefItem = pref;
            this.itemText = title;
            this.sortOrder = sortOrder;
            this.getIsEnabled = getIsEnabled;
        }

        void addPreferenceItem(String title, String labelkey, JComponent item, String tooltip, int sortOrder) {
            for (TabDetails tabDetails : this.tabDetailsArray) {
                if (!tabDetails.getTitle().equals(title)) continue;
                return;
            }
            TabDetails tab = new TabDetails(labelkey, title, item, tooltip, sortOrder);
            this.tabDetailsArray.add(tab);
            this.tabDetailsArray.sort((o1, o2) -> {
                int comparison = Integer.compare(o1.sortOrder, o2.sortOrder);
                return comparison != 0 ? comparison : o1.tabTitle.compareTo(o2.tabTitle);
            });
            JScrollPane scroller = new JScrollPane(tab.getPanel());
            scroller.setBorder(BorderFactory.createEmptyBorder());
            ThreadingUtil.runOnGUI(() -> {
                this.tabbedPane.addTab(tab.getTitle(), null, scroller, tab.getToolTip());
                for (String disableItem : this.disableItemsList) {
                    if (!item.getClass().getName().equals(disableItem)) continue;
                    this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfTab(tab.getTitle()), false);
                    return;
                }
            });
        }

        String getPrefItem() {
            return this.prefItem;
        }

        String getItemString() {
            return this.itemText;
        }

        ArrayList<String> getSubCategoriesList() {
            ArrayList<String> choices = new ArrayList<String>();
            for (TabDetails tabDetails : this.tabDetailsArray) {
                choices.add(tabDetails.getTitle());
            }
            return choices;
        }

        JComponent getPanel() {
            if (this.tabDetailsArray.size() == 1) {
                return this.tabDetailsArray.get(0).getPanel();
            }
            if (this.tabbedPane.getTabCount() == 0) {
                for (TabDetails tab : this.tabDetailsArray) {
                    ThreadingUtil.runOnGUI(() -> {
                        JScrollPane scroller = new JScrollPane(tab.getPanel());
                        scroller.setBorder(BorderFactory.createEmptyBorder());
                        this.tabbedPane.addTab(tab.getTitle(), null, scroller, tab.getToolTip());
                        for (String disableItem : this.disableItemsList) {
                            if (!tab.getItem().getClass().getName().equals(disableItem)) continue;
                            this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfTab(tab.getTitle()), false);
                            return;
                        }
                    });
                }
            }
            return this.tabbedPane;
        }

        void gotoSubCategory(String sub) {
            if (this.tabDetailsArray.size() == 1) {
                return;
            }
            for (int i = 0; i < this.tabDetailsArray.size(); ++i) {
                if (!this.tabDetailsArray.get(i).getTitle().equals(sub)) continue;
                this.tabbedPane.setSelectedIndex(i);
                return;
            }
        }

        void disableSubCategory(String sub) {
            if (this.tabDetailsArray.isEmpty()) {
                this.disableItemsList.add(sub);
                return;
            }
            for (int i = 0; i < this.tabDetailsArray.size(); ++i) {
                if (!this.tabDetailsArray.get(i).getItem().getClass().getName().equals(sub)) continue;
                this.tabbedPane.setEnabledAt(i, false);
                return;
            }
        }

        static class TabDetails
        implements Serializable {
            JComponent tabItem;
            String tabTooltip;
            String tabTitle;
            JPanel tabPanel = new JPanel();
            private final int sortOrder;

            TabDetails(String labelkey, String tabTit, JComponent item, String tooltip, int sortOrder) {
                this.tabItem = item;
                this.tabTitle = tabTit;
                this.tabTooltip = tooltip;
                this.sortOrder = sortOrder;
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                if (labelkey != null) {
                    JLabel t = new JLabel("<html>" + labelkey.replace(String.valueOf('\n'), "<br>") + "</html>");
                    t.setHorizontalAlignment(0);
                    t.setAlignmentX(0.5f);
                    t.setPreferredSize(t.getMinimumSize());
                    t.setMaximumSize(t.getMinimumSize());
                    t.setOpaque(false);
                    p.add((Component)t, "North");
                }
                p.add((Component)item, "Center");
                ThreadingUtil.runOnGUI(() -> {
                    this.tabPanel.setLayout(new BorderLayout());
                    this.tabPanel.add((Component)p, "Center");
                });
            }

            String getToolTip() {
                return this.tabTooltip;
            }

            String getTitle() {
                return this.tabTitle;
            }

            JPanel getPanel() {
                return this.tabPanel;
            }

            JComponent getItem() {
                return this.tabItem;
            }

            int getSortOrder() {
                return this.sortOrder;
            }
        }
    }
}

