/*
 * Decompiled with CFR 0.152.
 */
package apps.gui3.tabbedpreferences;

import apps.gui3.tabbedpreferences.Bundle;
import apps.gui3.tabbedpreferences.TabbedPreferences;
import java.awt.event.WindowEvent;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.swing.PreferencesPanel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public class TabbedPreferencesFrame
extends JmriJFrame {
    @Override
    public String getTitle() {
        return this.getTabbedPreferences().getTitle();
    }

    public boolean isMultipleInstances() {
        return true;
    }

    public TabbedPreferencesFrame() {
        this.add(this.getTabbedPreferences());
        this.addHelpMenu("package.apps.TabbedPreferences", true);
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    public void gotoPreferenceItem(String item, String sub) {
        this.getTabbedPreferences().gotoPreferenceItem(item, sub);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        ShutDownManager sdm = InstanceManager.getDefault(ShutDownManager.class);
        if (!this.getTabbedPreferences().isPreferencesValid() && !sdm.isShuttingDown()) {
            for (PreferencesPanel panel : this.getTabbedPreferences().getPreferencesPanels().values()) {
                if (panel.isPreferencesValid()) continue;
                switch (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("InvalidPreferencesMessage", panel.getTabbedPreferencesTitle()), Bundle.getMessage("InvalidPreferencesTitle"), 0, 0)) {
                    case 0: {
                        this.getTabbedPreferences().gotoPreferenceItem(panel.getPreferencesItem(), panel.getTabbedPreferencesTitle());
                        return;
                    }
                }
            }
        }
        if (this.getTabbedPreferences().isDirty()) {
            int buttons = 1;
            if (sdm.isShuttingDown()) {
                buttons = 0;
            }
            switch (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("UnsavedChangesMessage", this.getTabbedPreferences().getTitle()), Bundle.getMessage("UnsavedChangesTitle"), buttons, 3)) {
                case 0: {
                    this.getTabbedPreferences().savePressed(this.getTabbedPreferences().invokeSaveOptions());
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.setVisible(false);
    }

    private TabbedPreferences getTabbedPreferences() {
        return InstanceManager.getOptionalDefault(TabbedPreferences.class).orElseGet(() -> InstanceManager.setDefault(TabbedPreferences.class, new TabbedPreferences()));
    }
}

