/*
 * Decompiled with CFR 0.152.
 */
package apps.jmrit;

import apps.TrainCrew.InstallFromURL;
import apps.jmrit.Bundle;
import apps.jmrit.log.LogAction;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.configurexml.StoreAndCompare;
import jmri.jmrit.LogixLoadAction;
import jmri.jmrit.MemoryFrameAction;
import jmri.jmrit.XmlFileValidateAction;
import jmri.jmrit.decoderdefn.DecoderIndexCreateAction;
import jmri.jmrit.decoderdefn.InstallDecoderFileAction;
import jmri.jmrit.decoderdefn.InstallDecoderURLAction;
import jmri.jmrit.decoderdefn.NameCheckAction;
import jmri.jmrit.jython.RunJythonScript;
import jmri.jmrit.roster.RecreateRosterAction;
import jmri.jmrit.roster.UpdateDecoderDefinitionAction;
import jmri.jmrit.symbolicprog.tabbedframe.ProgCheckAction;
import jmri.jmrix.jinput.treecontrol.TreeAction;
import jmri.jmrix.libusb.UsbViewAction;
import jmri.jmrix.pricom.PricomMenu;
import jmri.util.FileUtil;
import jmri.util.swing.JmriNamedPaneAction;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugMenu
extends JMenu {
    static final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsBundle");
    private static final Logger log = LoggerFactory.getLogger(DebugMenu.class);

    public DebugMenu(String name, JPanel panel) {
        this(panel);
        this.setText(name);
    }

    public DebugMenu(JPanel panel) {
        this.setText(Bundle.getMessage("MenuDebug"));
        this.add(new MemoryFrameAction(Bundle.getMessage("MenuItemMemoryUsageMonitor")));
        this.add(new JSeparator());
        this.add(new InstallDecoderFileAction(Bundle.getMessage("MenuItemImportDecoderFile"), panel));
        this.add(new InstallDecoderURLAction(Bundle.getMessage("MenuItemImportDecoderURL"), panel));
        this.add(new DecoderIndexCreateAction(Bundle.getMessage("MenuItemRecreateDecoderIndex")));
        this.add(new RecreateRosterAction(Bundle.getMessage("MenuItemRecreateRoster")));
        this.add(new UpdateDecoderDefinitionAction(Bundle.getMessage("MenuItemUpdateDecoderDefinition")));
        this.add(new JSeparator());
        this.add(new XmlFileValidateAction(Bundle.getMessage("MenuItemValidateXMLFile"), panel));
        this.add(new NameCheckAction(Bundle.getMessage("MenuItemCheckDecoderNames"), panel));
        this.add(new ProgCheckAction(Bundle.getMessage("MenuItemCheckProgrammerNames"), panel));
        this.add(new StoreAndCompare(Bundle.getMessage("MenuTestStoreCompare")));
        this.add(new JSeparator());
        this.add(new LogAction(Bundle.getMessage("MenuItemLogAction")));
        this.add(new JmriNamedPaneAction(Bundle.getMessage("MenuItemLogTreeAction"), new JmriJFrameInterface(), "apps.jmrit.log.Log4JTreePane"));
        this.add(new JSeparator());
        this.add(new LogixLoadAction(Bundle.getMessage("MenuItemLogixDisabled"), panel));
        this.add(new JSeparator());
        this.add(new PricomMenu());
        this.add(new JSeparator());
        this.add(new TreeAction());
        this.add(new UsbViewAction());
        this.add(new JSeparator());
        try {
            this.add(new RunJythonScript(rb.getString("MenuRailDriverThrottle"), new File(FileUtil.findURL("jython/RailDriver.py").toURI())));
        }
        catch (NullPointerException | URISyntaxException ex) {
            log.error("Unable to load RailDriver Throttle", (Throwable)ex);
            JMenuItem i = new JMenuItem(rb.getString("MenuRailDriverThrottle"));
            i.setEnabled(false);
            this.add(i);
        }
        this.add(new JSeparator());
        this.add(new InstallFromURL());
    }
}

