/*
 * Decompiled with CFR 0.152.
 */
package apps.jmrit.log;

import apps.jmrit.log.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriPanel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JTreePane
extends JmriPanel {
    private JTextArea text;
    private JScrollPane scroll;
    private JComboBox<Level> levelSelectionComboBox;
    private JComboBox<String> categoryComboBox;
    private static final String ROOT_LEVEL_STRING = Bundle.getMessage("DataItemRootLoggingLevel");
    private static final Level[] SELECTABLE_LEVELS = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.OFF};
    private static final Logger log = LoggerFactory.getLogger(Log4JTreePane.class);

    @Override
    public String getTitle() {
        return Bundle.getMessage("MenuItemLogTreeAction");
    }

    public Log4JTreePane() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void initComponents() {
        this.add((Component)this.getEditLoggingLevelPanel(), "South");
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.scroll = new JScrollPane(this.text);
        this.updateTextAreaAndCategorySelect();
        this.add((Component)this.scroll, "Center");
        JPanel topP = new JPanel(new FlowLayout());
        JButton refreshButton = new JButton(Bundle.getMessage("ButtonRefreshCategories"));
        refreshButton.addActionListener(this::refreshButtonPressed);
        topP.add(refreshButton);
        topP.add(new JLabel(Bundle.getMessage("FieldLogConfiguredInherited")));
        this.add((Component)topP, "North");
        this.text.setCaretPosition(0);
        JScrollBar b = this.scroll.getVerticalScrollBar();
        b.setValue(b.getMaximum());
    }

    private JPanel getEditLoggingLevelPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel categoryLabelPanel = new JPanel(new FlowLayout());
        categoryLabelPanel.add(new JLabel(Bundle.getMessage("LabelCategoryToChange")));
        this.categoryComboBox = new JComboBox();
        JComboBoxUtil.setupComboBoxMaxRows(this.categoryComboBox);
        this.categoryComboBox.setToolTipText(Bundle.getMessage("ToolTipSelectLoggingLevel"));
        this.categoryComboBox.setEditable(true);
        JPanel catergoryComboboxPanel = new JPanel(new FlowLayout());
        catergoryComboboxPanel.add(this.categoryComboBox);
        this.levelSelectionComboBox = new JComboBox<Level>(SELECTABLE_LEVELS);
        JComboBoxUtil.setupComboBoxMaxRows(this.levelSelectionComboBox);
        this.levelSelectionComboBox.setSelectedItem(Level.DEBUG);
        Dimension preferredSize = this.levelSelectionComboBox.getPreferredSize();
        preferredSize.width = (int)((double)preferredSize.width * 1.2);
        this.levelSelectionComboBox.setPreferredSize(preferredSize);
        this.levelSelectionComboBox.setToolTipText(Bundle.getMessage("ToolTipSelectLoggingLevelValue"));
        JPanel levelSelectPanel = new JPanel(new FlowLayout());
        levelSelectPanel.add(new JLabel(Bundle.getMessage("LabelNewLevelForAboveCategory")));
        levelSelectPanel.add(this.levelSelectionComboBox);
        JButton setLevelButton = new JButton(Bundle.getMessage("ButtonEditLoggingLevel"));
        setLevelButton.setToolTipText(Bundle.getMessage("ToolTipEditLoggingLevel"));
        setLevelButton.addActionListener(this::editButtonPressed);
        JPanel setButtonPanel = new JPanel(new FlowLayout());
        setButtonPanel.add(setLevelButton);
        p.add(categoryLabelPanel);
        p.add(catergoryComboboxPanel);
        p.add(levelSelectPanel);
        p.add(setButtonPanel);
        return p;
    }

    private void updateTextAreaAndCategorySelect() {
        List<LoggerInfo> loggersWithLevels = Log4JTreePane.getAllLoggersWithLevels();
        this.populateTextArea(loggersWithLevels);
        this.updateCategoryComboBox(loggersWithLevels);
    }

    private static List<LoggerInfo> getAllLoggersWithLevels() {
        HashMap<String, LoggerInfo> hs = new HashMap<String, LoggerInfo>();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (org.apache.logging.log4j.Logger category : loggerContext.getLoggers()) {
            hs.put(category.getName(), new LoggerInfo(category.getName(), category.getLevel()));
        }
        Configuration config = loggerContext.getConfiguration();
        Map mm = config.getLoggers();
        mm.forEach((key, value) -> {
            hs.putIfAbsent((String)key, new LoggerInfo(value.getName(), value.getLevel()));
            ((LoggerInfo)hs.get(key)).setInConfig();
        });
        hs.putIfAbsent("", new LoggerInfo("", config.getRootLogger().getLevel()));
        ((LoggerInfo)hs.get("")).setInConfig();
        ArrayList<LoggerInfo> valuesList = new ArrayList<LoggerInfo>(hs.values());
        Collections.sort(valuesList);
        return valuesList;
    }

    private void populateTextArea(List<LoggerInfo> loggers) {
        StringBuilder result = new StringBuilder();
        for (LoggerInfo s : loggers) {
            result.append("  ").append(s.toString()).append(System.lineSeparator());
        }
        JScrollBar b = this.scroll.getVerticalScrollBar();
        int beforeScroll = b.getValue();
        int caret = this.text.getCaretPosition();
        this.text.setText(result.toString());
        this.text.setCaretPosition(caret);
        b.setValue(beforeScroll);
    }

    private void updateCategoryComboBox(List<LoggerInfo> loggers) {
        String f = (String)this.categoryComboBox.getSelectedItem();
        this.categoryComboBox.removeAllItems();
        for (LoggerInfo l : loggers) {
            this.categoryComboBox.addItem(l.getLoggerName());
        }
        this.categoryComboBox.setSelectedItem(f == null ? ROOT_LEVEL_STRING : f);
    }

    private void editButtonPressed(ActionEvent e) {
        log.debug("{} pressed", (Object)e.getActionCommand());
        String f = (String)this.categoryComboBox.getSelectedItem();
        Level l = (Level)this.levelSelectionComboBox.getSelectedItem();
        log.info("changing Logging for {} to {}", (Object)f, (Object)l);
        if (ROOT_LEVEL_STRING.equals(f)) {
            f = "";
        }
        Configurator.setLevel((org.apache.logging.log4j.Logger)LogManager.getLogger((String)f), (Level)l);
        this.updateTextAreaAndCategorySelect();
    }

    private void refreshButtonPressed(ActionEvent e) {
        log.debug("{} pressed", (Object)e.getActionCommand());
        this.updateTextAreaAndCategorySelect();
    }

    @Override
    public void initContext(Object context) {
    }

    private static class LoggerInfo
    implements Comparable<LoggerInfo> {
        private final String loggerName;
        private final Level level;
        private boolean inConfig = false;

        private LoggerInfo(String loggerName, Level level) {
            this.loggerName = loggerName;
            this.level = level;
        }

        String getLoggerName() {
            return this.loggerName.isBlank() ? ROOT_LEVEL_STRING : this.loggerName;
        }

        private void setInConfig() {
            this.inConfig = true;
        }

        @Override
        public int compareTo(LoggerInfo other) {
            return this.loggerName.compareTo(other.loggerName);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.getLoggerName()).append("  ");
            if (!this.inConfig) {
                s.append("{ ").append(this.level.name()).append(" }");
            } else {
                s.append("[ ").append(this.level.name()).append(" ]");
            }
            return s.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoggerInfo)) {
                return false;
            }
            LoggerInfo other = (LoggerInfo)obj;
            return Objects.equals(this.loggerName, other.loggerName) && Objects.equals(this.level, other.level);
        }

        public int hashCode() {
            return 13 * Objects.hashCode(this.loggerName) * Objects.hashCode(this.level);
        }
    }
}

