/*
 * Decompiled with CFR 0.152.
 */
package apps.plaf.macosx;

import apps.plaf.macosx.AboutHandler;
import apps.plaf.macosx.Application;
import apps.plaf.macosx.PreferencesHandler;
import apps.plaf.macosx.QuitHandler;
import java.awt.Desktop;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jdk9Application
extends Application {
    private static final Logger log = LoggerFactory.getLogger(Jdk9Application.class);

    Jdk9Application() {
    }

    private void setHandler(String methodName, String handlerType, Object handler) {
        try {
            Class<?> parameterType = Class.forName(handlerType);
            Class[] parameterTypes = new Class[]{parameterType};
            Method method = Desktop.class.getDeclaredMethod(methodName, parameterTypes);
            Object[] parameters = new Object[]{handler};
            method.invoke((Object)Desktop.getDesktop(), parameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            log.debug("Exception calling {} with {}", new Object[]{methodName, handlerType, ex});
        }
    }

    @Override
    public void setAboutHandler(AboutHandler handler) {
        if (handler != null) {
            Desktop.getDesktop().setAboutHandler(handler::handleAbout);
        } else {
            this.setHandler("setAboutHandler", "java.awt.desktop.AboutHandler", null);
        }
    }

    @Override
    public void setPreferencesHandler(PreferencesHandler handler) {
        if (handler != null) {
            Desktop.getDesktop().setPreferencesHandler(handler::handlePreferences);
        } else {
            this.setHandler("setPreferencesHandler", "java.awt.desktop.PreferencesHandler", null);
        }
    }

    @Override
    public void setQuitHandler(QuitHandler handler) {
        if (handler != null) {
            Desktop.getDesktop().setQuitHandler((QuitEvent qe, QuitResponse response) -> {
                if (handler.handleQuitRequest(qe)) {
                    response.performQuit();
                } else {
                    response.cancelQuit();
                }
            });
        } else {
            this.setHandler("setQuitHandler", "java.awt.desktop.QuitHandler", null);
        }
    }
}

