/*
 * Decompiled with CFR 0.152.
 */
package apps.startup;

import apps.startup.Bundle;
import apps.startup.ScriptButtonModel;
import apps.startup.ScriptButtonPanel;
import java.awt.Component;
import java.io.File;
import jmri.InstanceManager;
import jmri.script.swing.ScriptFileChooser;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;
import jmri.util.startup.StartupModelFactory;
import jmri.util.swing.JmriJOptionPane;

public class ScriptButtonModelFactory
implements StartupModelFactory {
    private ScriptFileChooser chooser = null;

    @Override
    public Class<? extends StartupModel> getModelClass() {
        return ScriptButtonModel.class;
    }

    @Override
    public ScriptButtonModel newModel() {
        return new ScriptButtonModel();
    }

    @Override
    public String getDescription() {
        return Bundle.getMessage(this.getModelClass().getCanonicalName());
    }

    @Override
    public String getActionText() {
        return Bundle.getMessage("EditableStartupAction", this.getDescription());
    }

    @Override
    public void editModel(StartupModel model, Component parent) {
        if (this.chooser == null) {
            this.chooser = new ScriptFileChooser();
            this.chooser.setDialogTitle(this.getDescription());
            this.chooser.setDialogType(2);
        }
        if (ScriptButtonModel.class.isInstance(model)) {
            ScriptButtonPanel buttonPanel = new ScriptButtonPanel(this.chooser, parent);
            if (((ScriptButtonModel)model).getScript() != null) {
                buttonPanel.setScript(((ScriptButtonModel)model).getScript().getPath());
            } else {
                buttonPanel.setScript("");
            }
            buttonPanel.setButtonName(model.getName());
            JmriJOptionPane.showMessageDialog(parent, buttonPanel, this.getDescription(), -1);
            if (!buttonPanel.getButtonName().isEmpty()) {
                model.setName(buttonPanel.getButtonName());
                ((ScriptButtonModel)model).setScript(new File(buttonPanel.getScript()));
                InstanceManager.getDefault(StartupActionsManager.class).setRestartRequired();
            }
        }
    }

    @Override
    public void initialize() {
    }
}

