/*
 * Decompiled with CFR 0.152.
 */
package apps.startup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptButtonPanel
extends JPanel {
    private final Component parent;
    private final JFileChooser chooser;
    private static final Logger log = LoggerFactory.getLogger(ScriptButtonPanel.class);
    private JTextField buttonName;
    private JLabel nameLabel;
    private JTextField script;
    private JButton scriptButton;
    private JLabel scriptLabel;

    public ScriptButtonPanel(JFileChooser chooser, Component parent) {
        this.initComponents();
        this.parent = parent;
        this.chooser = chooser;
    }

    private void initComponents() {
        this.buttonName = new JTextField();
        this.nameLabel = new JLabel();
        this.scriptLabel = new JLabel();
        this.script = new JTextField();
        this.scriptButton = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("apps/startup/Bundle");
        this.buttonName.setText(bundle.getString("ScriptButtonPanel.buttonName.text"));
        this.nameLabel.setText(bundle.getString("ScriptButtonPanel.nameLabel.text"));
        this.scriptLabel.setText(bundle.getString("ScriptButtonPanel.scriptLabel.text"));
        this.script.setText(bundle.getString("ScriptButtonPanel.script.text"));
        this.scriptButton.setText(bundle.getString("ScriptButtonPanel.scriptButton.text"));
        this.scriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptButtonPanel.this.scriptButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.scriptLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.script, -1, 220, Short.MAX_VALUE).addComponent(this.buttonName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonName, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.script, -2, -1, -2).addComponent(this.scriptLabel).addComponent(this.scriptButton))));
    }

    private void scriptButtonActionPerformed(ActionEvent evt) {
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            try {
                this.script.setText(this.chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                log.error("File {} does not exist.", (Object)this.chooser.getSelectedFile());
            }
        }
    }

    protected String getButtonName() {
        return this.buttonName.getText();
    }

    protected void setButtonName(String name) {
        this.buttonName.setText(name);
    }

    protected String getScript() {
        return this.script.getText();
    }

    protected void setScript(String script) {
        this.script.setText(script);
    }
}

