/*
 * Decompiled with CFR 0.152.
 */
package apps.startup;

import apps.ConfigBundle;
import apps.startup.Bundle;
import apps.startup.StartupModelCellEditor;
import apps.startup.StartupModelCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.startup.StartupActionsManager;
import jmri.util.startup.StartupModel;

public class StartupActionsPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_ENABLED = 2;
    JPopupMenu actionsMenu;
    JTable actionsTbl;
    JButton addBtn;
    JButton downBtn;
    JScrollPane jScrollPane1;
    JLabel moveLbl;
    JLabel recommendationsLbl;
    JButton removeBtn;
    JLabel startupLbl;
    JButton upBtn;

    public StartupActionsPreferencesPanel() {
        this.initComponents();
        JButton testButton = new JButton("XXXXXX");
        TableColumn enableColumn = this.actionsTbl.getColumnModel().getColumn(2);
        enableColumn.setMinWidth(testButton.getPreferredSize().width);
        enableColumn.setMaxWidth(testButton.getPreferredSize().width);
        this.actionsTbl.getSelectionModel().addListSelectionListener(e -> {
            int row = this.actionsTbl.getSelectedRow();
            this.upBtn.setEnabled(row != 0 && row != -1);
            this.downBtn.setEnabled(row != this.actionsTbl.getRowCount() - 1 && row != -1);
            this.removeBtn.setEnabled(row != -1);
        });
        ArrayList items = new ArrayList();
        InstanceManager.getDefault(StartupActionsManager.class).getFactories().values().stream().forEach(factory -> {
            JMenuItem item = new JMenuItem(factory.getActionText());
            item.addActionListener(e -> {
                StartupModel model = factory.newModel();
                factory.editModel(model, this.getTopLevelAncestor());
                if (model.isValid()) {
                    InstanceManager.getDefault(StartupActionsManager.class).addAction(model);
                }
            });
            items.add(item);
        });
        items.sort((o1, o2) -> o1.getText().compareTo(o2.getText()));
        items.stream().forEach(item -> this.actionsMenu.add((JMenuItem)item));
    }

    private void initComponents() {
        this.actionsMenu = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.actionsTbl = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                try {
                    return this.getValueAt(this.rowAtPoint(e.getPoint()), -1).toString();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
        };
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.startupLbl = new JLabel();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.moveLbl = new JLabel();
        this.recommendationsLbl = new JLabel();
        this.actionsTbl.setDefaultRenderer(StartupModel.class, new StartupModelCellRenderer());
        this.actionsTbl.setDefaultEditor(StartupModel.class, new StartupModelCellEditor());
        this.actionsTbl.setModel(new TableModel(InstanceManager.getDefault(StartupActionsManager.class)));
        this.actionsTbl.setSelectionMode(0);
        this.actionsTbl.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.actionsTbl);
        this.actionsTbl.getColumnModel().getSelectionModel().setSelectionMode(0);
        ResourceBundle bundle = ResourceBundle.getBundle("apps/startup/Bundle");
        this.addBtn.setText(bundle.getString("StartupActionsPreferencesPanel.addBtn.text"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupActionsPreferencesPanel.this.addBtnActionPerformed(evt);
            }
        });
        this.removeBtn.setText(bundle.getString("StartupActionsPreferencesPanel.removeBtn.text"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupActionsPreferencesPanel.this.removeBtnActionPerformed(evt);
            }
        });
        this.startupLbl.setText(bundle.getString("StartupActionsPreferencesPanel.startupLbl.text"));
        this.upBtn.setText(bundle.getString("StartupActionsPreferencesPanel.upBtn.text"));
        this.upBtn.setEnabled(false);
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupActionsPreferencesPanel.this.upBtnActionPerformed(evt);
            }
        });
        this.downBtn.setText(bundle.getString("StartupActionsPreferencesPanel.downBtn.text"));
        this.downBtn.setEnabled(false);
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupActionsPreferencesPanel.this.downBtnActionPerformed(evt);
            }
        });
        this.moveLbl.setText(bundle.getString("StartupActionsPreferencesPanel.moveLbl.text"));
        this.recommendationsLbl.setText(bundle.getString("StartupActionsPreferencesPanel.recommendationsLbl.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.recommendationsLbl).addComponent(this.jScrollPane1, -1, 487, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addBtn).addGap(18, 18, 18).addComponent(this.moveLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.removeBtn)).addComponent(this.startupLbl)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.startupLbl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 200, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recommendationsLbl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addBtn).addComponent(this.removeBtn).addComponent(this.upBtn).addComponent(this.downBtn).addComponent(this.moveLbl)).addContainerGap()));
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        Component c = (Component)evt.getSource();
        this.actionsMenu.show(c, -1, c.getHeight());
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        int row = this.actionsTbl.getSelectedRow();
        if (row != -1) {
            StartupModel model = InstanceManager.getDefault(StartupActionsManager.class).getActions(row);
            InstanceManager.getDefault(StartupActionsManager.class).removeAction(model);
        }
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        int row = this.actionsTbl.getSelectedRow();
        if (row != 0) {
            InstanceManager.getDefault(StartupActionsManager.class).moveAction(row, row - 1);
            this.actionsTbl.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        int row = this.actionsTbl.getSelectedRow();
        if (row != this.actionsTbl.getRowCount() - 1) {
            InstanceManager.getDefault(StartupActionsManager.class).moveAction(row, row + 1);
            this.actionsTbl.setRowSelectionInterval(row + 1, row + 1);
        }
    }

    @Override
    public String getPreferencesItem() {
        return "STARTUP";
    }

    @Override
    public String getPreferencesItemText() {
        return ConfigBundle.getMessage("MenuStartUp");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        InstanceManager.getDefault(StartupActionsManager.class).savePreferences(profile);
    }

    @Override
    public boolean isDirty() {
        return InstanceManager.getDefault(StartupActionsManager.class).isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return InstanceManager.getDefault(StartupActionsManager.class).isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private static class TableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        private final StartupActionsManager manager;

        public TableModel(StartupActionsManager manager) {
            this.manager = manager;
            this.manager.addPropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            return this.manager.getActions().length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StartupModel model = this.manager.getActions(rowIndex);
            switch (columnIndex) {
                case -1: {
                    return model.toString();
                }
                case 0: {
                    return model;
                }
                case 1: {
                    return this.manager.getFactories(model.getClass()).getDescription();
                }
                case 2: {
                    return model.isEnabled();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 2: {
                    if (!(aValue instanceof Boolean)) break;
                    StartupModel model = this.manager.getActions(rowIndex);
                    model.setEnabled((Boolean)aValue);
                    this.manager.setRestartRequired();
                    break;
                }
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Bundle.getMessage("StartupActionsTableModel.name");
                }
                case 1: {
                    return Bundle.getMessage("StartupActionsTableModel.type");
                }
                case 2: {
                    return Bundle.getMessage("StartupActionsTableModel.enabled");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return StartupModel.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int index = -1;
            if (evt instanceof IndexedPropertyChangeEvent) {
                index = ((IndexedPropertyChangeEvent)evt).getIndex();
            }
            if (index != -1 && evt.getOldValue() instanceof Integer) {
                this.fireTableRowsUpdated((Integer)evt.getOldValue(), index);
            } else {
                this.fireTableDataChanged();
            }
        }
    }
}

