/*
 * Decompiled with CFR 0.152.
 */
package apps.startup;

import apps.startup.Bundle;
import jmri.JmriException;
import jmri.util.startup.AbstractStartupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupPauseModel
extends AbstractStartupModel {
    public static final int DEFAULT_DELAY = 10;
    private int delay = -1;
    private static final Logger log = LoggerFactory.getLogger(StartupPauseModel.class);

    @Override
    public String getName() {
        return Bundle.getMessage("StartupPauseModel.name", this.getDelay());
    }

    @Override
    public boolean isValid() {
        return this.getDelay() >= 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void performAction() throws JmriException {
        if (this.delay > 0) {
            log.info("Pausing startup actions processing for {} seconds.", (Object)this.delay);
            try {
                Thread.sleep((long)this.delay * 1000L);
            }
            catch (InterruptedException ex) {
                log.warn("Pause in startup actions interrupted.");
            }
        }
    }
}

