/*
 * Decompiled with CFR 0.152.
 */
package apps.swing;

import apps.swing.Bundle;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.swing.ConnectionLabel;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AboutDialog {
    private final JFrame frame;
    private final boolean modal;
    private static final String REGISTERED_TM_SYMBOL = "\u00ae";
    private static final Logger log = LoggerFactory.getLogger(AboutDialog.class);

    public AboutDialog(JFrame jframe, boolean isModal) {
        this.frame = jframe;
        this.modal = isModal;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        log.debug("Start UI");
        if (this.modal) {
            JmriJOptionPane.showMessageDialog(this.frame, this.getMainPanel(), Bundle.getMessage("TitleAbout", Application.getApplicationName()), -1);
        } else {
            JmriJOptionPane.showMessageDialogNonModal(this.frame, this.getMainPanel(), Bundle.getMessage("TitleAbout", Application.getApplicationName()), -1, null);
        }
    }

    private JPanel getMainPanel() {
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.namePane());
        pane.add(this.infoPane());
        return pane;
    }

    protected JPanel namePane() {
        String logo = Application.getLogo();
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        if (log.isDebugEnabled()) {
            log.debug("Fetch main logo: {} ({})", (Object)logo, (Object)FileUtil.findURL(logo, FileUtil.Location.INSTALLED));
        }
        AboutDialog.addCenteredComponent(new JLabel(new ImageIcon(pane.getToolkit().getImage(FileUtil.findURL(logo, FileUtil.Location.INSTALLED)), "JMRI logo"), 0), pane);
        pane.add(Box.createRigidArea(new Dimension(0, 15)));
        String name = Application.getApplicationName();
        name = AboutDialog.checkRegisteredTmInString(name);
        JLabel appName = new JLabel(name, 0);
        appName.setFont(pane.getFont().deriveFont(1, (float)pane.getFont().getSize() * 1.2f));
        AboutDialog.addCenteredComponent(appName, pane);
        AboutDialog.addCenteredComponent(new JLabel(Application.getURL(), 0), pane);
        pane.add(Box.createRigidArea(new Dimension(0, 15)));
        pane.setAlignmentX(0.5f);
        return pane;
    }

    protected static String checkRegisteredTmInString(String name) {
        if (!name.contains(REGISTERED_TM_SYMBOL)) {
            return name + " \u00ae";
        }
        return name;
    }

    protected JPanel infoPane() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        log.debug("start labels");
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (conn.getDisabled()) continue;
            pane1.add(new ConnectionLabel(conn));
        }
        pane1.add(Box.createRigidArea(new Dimension(0, 15)));
        pane1.add(new JLabel(Bundle.getMessage("DefaultVersionCredit", Version.name())));
        pane1.add(new JLabel(Version.getCopyright()));
        pane1.add(new JLabel(Bundle.getMessage("JavaVersionCredit", System.getProperty("java.version", "<unknown>"), Locale.getDefault().toString())));
        pane1.setAlignmentX(0.5f);
        return pane1;
    }

    protected static void addCenteredComponent(JComponent c, JPanel p) {
        c.setAlignmentX(0.5f);
        p.add(c);
    }
}

