/*
 * Decompiled with CFR 0.152.
 */
package apps.swing;

import apps.CheckForUpdateAction;
import apps.LicenseAction;
import apps.ReportContextAction;
import apps.SystemConsoleAction;
import apps.plaf.macosx.Application;
import apps.swing.AboutAction;
import apps.swing.AboutDialog;
import apps.swing.Bundle;
import apps.util.issuereporter.swing.IssueReporterAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import jmri.jmrit.XmlFileLocationAction;
import jmri.util.HelpUtil;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpMenuProvider
implements HelpUtil.MenuProvider {
    private static final Logger log = LoggerFactory.getLogger(HelpMenuProvider.class);

    @Override
    @Nonnull
    public List<JMenuItem> getHelpMenuItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem item = new JMenuItem(Bundle.getMessage("MenuItemHelp"));
        HelpUtil.enableHelpOnButton(item, "index");
        items.add(item);
        JMenuItem license = new JMenuItem(Bundle.getMessage("MenuItemLicense"));
        items.add(license);
        license.addActionListener(new LicenseAction());
        JMenuItem directories = new JMenuItem(Bundle.getMessage("MenuItemFileLocations"));
        items.add(directories);
        directories.addActionListener(new XmlFileLocationAction());
        JMenuItem updates = new JMenuItem(Bundle.getMessage("MenuItemCheckUpdates"));
        items.add(updates);
        updates.addActionListener(new CheckForUpdateAction());
        JMenuItem context = new JMenuItem(Bundle.getMessage("MenuItemContext"));
        items.add(context);
        context.addActionListener(new ReportContextAction());
        JMenuItem console = new JMenuItem(Bundle.getMessage("MenuItemConsole"));
        items.add(console);
        console.addActionListener(new SystemConsoleAction());
        items.add(new JMenuItem(new IssueReporterAction()));
        if (SystemType.isMacOSX()) {
            try {
                Objects.requireNonNull(Application.getApplication()).setAboutHandler(eo -> new AboutDialog(null, true).setVisible(true));
            }
            catch (RuntimeException re) {
                log.error("Unable to put About handler in default location", (Throwable)re);
            }
        }
        if (!SystemType.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            items.add(null);
            JMenuItem about = new JMenuItem(Bundle.getMessage("MenuItemAbout") + " " + jmri.Application.getApplicationName());
            items.add(about);
            about.addActionListener(new AboutAction());
        }
        return items;
    }
}

