/*
 * Decompiled with CFR 0.152.
 */
package apps.util;

import apps.SystemConsole;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Version;
import jmri.util.FileUtil;
import jmri.util.exceptionhandler.UncaughtExceptionHandler;
import jmri.util.swing.JmriJOptionPane;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Log4JUtil {
    public static final String DEFAULT_LCF_NAME = "default_lcf.xml";
    public static final String SYS_PROP_LCF_LOCATION = "jmri.log";
    public static final String SYS_PROP_LOG_PATH = "jmri.log.path";
    private static final String LOG_HEADER = "****** JMRI log *******";
    private static final Logger log = LoggerFactory.getLogger(Log4JUtil.class);

    public static void initLogging() {
        Log4JUtil.initLogging(System.getProperty(SYS_PROP_LCF_LOCATION, DEFAULT_LCF_NAME));
    }

    public static void initLogging(@Nonnull String controlfile) {
        Log4JUtil.initLog4J(controlfile);
    }

    static void initLog4J(@Nonnull String logFile) {
        org.apache.logging.log4j.Logger logger = LogManager.getLogger();
        Map appenderMap = ((org.apache.logging.log4j.core.Logger)logger).getAppenders();
        if (appenderMap.size() > 1) {
            log.debug("initLog4J already initialized!");
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            SystemConsole.getInstance();
        }
        Log4JUtil.initializeJavaUtilLogging();
        String loggingControlFileLocation = Log4JUtil.getLoggingConfig(logFile);
        if (loggingControlFileLocation != null) {
            Log4JUtil.configureLogging(loggingControlFileLocation);
        } else {
            Configurator.reconfigure();
            Configurator.setRootLevel((Level)Level.INFO);
            log.error("Unable to load Configuration {}", (Object)logFile);
            if (!GraphicsEnvironment.isHeadless()) {
                JmriJOptionPane.showMessageDialog(null, "Could not locate Logging Configuration file " + logFile, "Could not Locate Logging Configuration File", 0);
            }
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    @CheckForNull
    public static String getLoggingConfig(@Nonnull String logFileLocation) {
        if (new File(logFileLocation).isAbsolute() && new File(logFileLocation).canRead()) {
            return logFileLocation;
        }
        if (new File(FileUtil.getPreferencesPath() + logFileLocation).canRead()) {
            return FileUtil.getPreferencesPath() + logFileLocation;
        }
        if (new File(FileUtil.getProgramPath() + logFileLocation).canRead()) {
            return FileUtil.getProgramPath() + logFileLocation;
        }
        return null;
    }

    static void initializeJavaUtilLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    @Nonnull
    public static String startupInfo(@Nonnull String program) {
        log.info(LOG_HEADER);
        org.apache.logging.log4j.Logger logger = LogManager.getLogger();
        Map appenderMap = ((org.apache.logging.log4j.core.Logger)logger).getAppenders();
        appenderMap.forEach((key, a) -> {
            if (a instanceof RollingFileAppender) {
                RollingFileAppender rf = (RollingFileAppender)a;
                String fileName = rf.getFileName();
                if (fileName.equals(rf.getFilePattern())) {
                    log.info("This log is stored in file: {}", (Object)fileName);
                } else {
                    log.info("This log is appended to file: {}", (Object)fileName);
                }
            } else if (a instanceof FileAppender) {
                log.info("This log is stored in file: {}", (Object)((FileAppender)a).getFileName());
            }
        });
        return program + " version " + Version.name() + " starts under Java " + System.getProperty("java.version", "<unknown>") + " on " + System.getProperty("os.name", "<unknown>") + " " + System.getProperty("os.arch", "<unknown>") + " v" + System.getProperty("os.version", "<unknown>") + " at " + new Date();
    }

    private static void configureLogging(@Nonnull String configFile) {
        String createLogErr;
        block7: {
            System.setProperty("log4j2.configurationFile", configFile);
            if (System.getProperty(SYS_PROP_LOG_PATH) == null) {
                System.setProperty(SYS_PROP_LOG_PATH, FileUtil.getPreferencesPath() + "log" + File.separator);
            }
            File logDir = new File(System.getProperty(SYS_PROP_LOG_PATH));
            createLogErr = null;
            if (!logDir.exists()) {
                try {
                    Files.createDirectories(logDir.toPath(), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    createLogErr = "Could not create directory for log files, " + ex.getMessage();
                }
            }
            try {
                Configurator.initialize(null, (String)configFile);
                log.debug("Logging initialised with {}", (Object)configFile);
            }
            catch (Exception ex) {
                Configurator.reconfigure();
                Configurator.setRootLevel((Level)Level.INFO);
                if (GraphicsEnvironment.isHeadless()) break block7;
                JmriJOptionPane.showMessageDialog(null, "Could not Initialise Logging " + ex.getMessage(), configFile, 0);
            }
        }
        if (createLogErr != null) {
            log.error("Could not create directory for log files at {} {}", (Object)System.getProperty(SYS_PROP_LOG_PATH), (Object)createLogErr);
        }
    }
}

