/*
 * Decompiled with CFR 0.152.
 */
package apps.util.issuereporter;

import apps.util.issuereporter.Bundle;
import apps.util.issuereporter.IssueReport;
import apps.util.issuereporter.SystemInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.prefs.InitializationException;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReport
extends IssueReport {
    private boolean includeProfile;
    private final boolean includeSysInfo;
    private final boolean includeLogs;
    private final List<File> files = new ArrayList<File>();
    private static final Logger log = LoggerFactory.getLogger(BugReport.class);

    public BugReport(String title, String body, boolean includeProfile, boolean includeSysInfo, boolean includeLogs) {
        super(title, body);
        this.includeProfile = includeProfile;
        this.includeSysInfo = includeSysInfo;
        this.includeLogs = includeLogs;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Null check in stream.forEach() is embedded, beyond our control")
    public void prepare() {
        this.title = Bundle.getMessage(Locale.US, "bug.title", this.title);
        if (!this.tooLong) {
            try {
                Profile profile;
                Path dir = Files.createTempDirectory("jmri-issue-report-" + new Date().getTime(), new FileAttribute[0]);
                if (this.includeLogs) {
                    Files.copy(new File(System.getProperty("jmri.log.path"), "session.log").toPath(), dir.resolve("session.log"), StandardCopyOption.REPLACE_EXISTING);
                }
                if (this.includeProfile && (profile = ProfileManager.getDefault().getActiveProfile()) != null) {
                    File archive = new File(dir.toFile(), "profile.zip");
                    ProfileManager.getDefault().export(profile, archive, false, false);
                }
                if (this.includeSysInfo) {
                    this.getSysInfoFile(dir);
                }
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                    stream.forEach(p -> this.files.add(p.toFile()));
                }
            }
            catch (IOException | NullPointerException | InitializationException | JDOMException ex) {
                log.error("Unable to include profile in report.", ex);
                this.includeProfile = false;
            }
            this.body = Bundle.getMessage(Locale.US, "bug.body", !this.files.isEmpty() ? Bundle.getMessage("instructions.paste.files") : "", this.body, this.getSimpleContext(), this.getIssueFooter());
        } else {
            this.body = Bundle.getMessage("instructions.paste.414");
        }
    }

    private void getSysInfoFile(Path path) {
        Path file = path.resolve("systemInfo.txt");
        try {
            Files.createFile(file, new FileAttribute[0]);
            Files.write(file, new SystemInfo(false).asList(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            log.error("Exception writing system info", (Throwable)ex);
        }
    }

    @Override
    public List<File> getAttachments() {
        return this.files;
    }
}

