/*
 * Decompiled with CFR 0.152.
 */
package apps.util.issuereporter;

import apps.util.issuereporter.Bundle;
import apps.util.issuereporter.GitHubRepository;
import apps.util.issuereporter.IssueReport414Exception;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Application;
import jmri.Version;
import jmri.beans.Bean;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, consumers={"apps.util.issuereporter.*"})
public abstract class IssueReport
extends Bean {
    protected String title;
    protected String body;
    protected boolean tooLong = false;

    IssueReport(String title, String body) {
        this.title = title;
        this.body = body;
    }

    @Nonnull
    public URI submit(GitHubRepository repository) throws URISyntaxException, IOException, IssueReport414Exception {
        this.prepare();
        URI uri = new URI(String.format("https://github.com/%s/%s/issues/new?title=%s;body=%s", repository.getOwner(), repository.getName(), URLEncoder.encode(this.title, StandardCharsets.UTF_8.toString()), URLEncoder.encode(this.body, StandardCharsets.UTF_8.toString())));
        HttpURLConnection request = (HttpURLConnection)uri.toURL().openConnection();
        request.setRequestMethod("GET");
        request.connect();
        if (request.getResponseCode() != 200) {
            this.tooLong = true;
            throw new IssueReport414Exception();
        }
        return uri;
    }

    protected abstract void prepare();

    @Nonnull
    public List<File> getAttachments() {
        return new ArrayList<File>();
    }

    @Nonnull
    public String getSimpleContext() {
        return Bundle.getMessage(Locale.US, "issue.context", Application.getApplicationName(), Version.name(), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    @Nonnull
    public String getIssueFooter() {
        return Bundle.getMessage(Locale.US, "issue.footer", new Object[0]);
    }

    @Nonnull
    public String getBody() {
        return this.body;
    }
}

