/*
 * Decompiled with CFR 0.152.
 */
package apps.util.issuereporter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import jmri.util.FileUtil;
import jmri.util.startup.StartupRunnable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public final class IssueReporterStartupRunnable
implements StartupRunnable {
    private static final Logger log = LoggerFactory.getLogger(IssueReporterStartupRunnable.class);

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Null check in stream.forEach() is embedded, beyond our control")
    public void run() {
        Path tempDir = new File(System.getProperty("java.io.tmpdir")).toPath();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tempDir, entry -> entry.toFile().getName().startsWith("jmri-issue-report-"));){
            stream.forEach(entry -> FileUtil.delete(entry.toFile()));
        }
        catch (IOException ex) {
            log.error("Exception cleaning up from issue reporter", (Throwable)ex);
        }
    }
}

