/*
 * Decompiled with CFR 0.152.
 */
package apps.util.issuereporter;

import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.filechooser.FileSystemView;
import jmri.Application;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.configurexml.LoadXmlUserAction;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.roster.Roster;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.PortNameMapper;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.node.NodeIdentity;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.zeroconf.ZeroConfServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private final boolean inBody;
    private static final Logger log = LoggerFactory.getLogger(SystemInfo.class);

    SystemInfo(boolean inBody) {
        this.inBody = inBody;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.inBody) {
            builder.append("<details>\n<summary>System Info</summary>\n\n");
        }
        this.asList().forEach(l -> builder.append((String)l).append("\n"));
        if (this.inBody) {
            builder.append("</details>\n");
        }
        return builder.toString();
    }

    public List<String> asList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("|Item|Value|");
        list.add("|---|---|");
        this.addLine(list, "JMRI Version", Version.name());
        this.addLine(list, "Application", Application.getApplicationName());
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            this.addLine(list, "Active profile", profile.getName());
            this.addLine(list, "Profile location", profile.getPath().getPath());
            this.addLine(list, "Profile ID", profile.getId());
        } else {
            this.addLine(list, "Active profile", "");
        }
        this.addLine(list, "JMRI Network ID", NodeIdentity.networkIdentity());
        this.addLine(list, "JMRI Storage ID", NodeIdentity.storageIdentity(profile));
        this.addLine(list, "Preferences directory", FileUtil.getUserFilesPath());
        this.addLine(list, "Program directory", FileUtil.getProgramPath());
        this.addLine(list, "Roster index", Roster.getDefault().getRosterIndexPath());
        File panel = LoadXmlUserAction.getCurrentFile();
        this.addLine(list, "Panel file", panel != null ? panel.getPath() : "");
        this.addLine(list, "Locale", InstanceManager.getDefault(GuiLafPreferencesManager.class).getLocale().toString());
        this.addLine(list, "Operations location", OperationsXml.getFileLocation());
        InstanceManager.getOptionalDefault(AudioManager.class).ifPresent(am -> {
            AudioFactory af = am.getActiveAudioFactory();
            this.addLine(list, "Audio factory", af != null ? af.toString() : "");
        });
        InstanceManager.getOptionalDefault(ConnectionConfigManager.class).ifPresent(ccm -> Arrays.stream(ccm.getConnections()).forEach(c -> this.addLine(list, "Connection " + c.getConnectionName(), c.getManufacturer() + " connected via " + c.name() + " on " + c.getInfo() + (c.getDisabled() ? " (disabled)" : " (enabled)"))));
        this.addComPortInfo(list);
        System.getProperties().stringPropertyNames().stream().sorted().filter(n -> !n.equals("line.separator")).forEach(n -> this.addLine((List<String>)list, (String)n, System.getProperty(n)));
        if (!GraphicsEnvironment.isHeadless()) {
            this.addLine(list, "FileSystemView#getDefaultDirectory()", FileSystemView.getFileSystemView().getDefaultDirectory().getPath());
            this.addLine(list, "FileSystemView#getHomeDirectory()", FileSystemView.getFileSystemView().getHomeDirectory().getPath());
            this.addLine(list, "Default JFileChooser()", new JmriJFileChooser().getCurrentDirectory().getPath());
        }
        this.addDisplayDimensions(list);
        this.addNetworkInfo(list);
        return list;
    }

    private void addDisplayDimensions(List<String> list) {
        if (!GraphicsEnvironment.isHeadless()) {
            Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).forEachOrdered(device -> {
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
                this.addLine(list, "Display " + device.getIDstring(), " size: width " + device.getDisplayMode().getWidth() + " height " + device.getDisplayMode().getHeight() + " insets: top " + insets.top + " right " + insets.right + " bottom " + insets.bottom + " left " + insets.left);
            });
        } else {
            this.addLine(list, "Display", "headless");
        }
    }

    private void addNetworkInfo(List<String> list) {
        try {
            Collections.list(NetworkInterface.getNetworkInterfaces()).stream().forEach(ni -> ni.getInterfaceAddresses().forEach(ia -> this.addLine(list, "Network Interface " + ni.getDisplayName(), ia.getAddress().getHostAddress())));
        }
        catch (SocketException ex) {
            log.error("Unable to enumerate network interfaces", (Throwable)ex);
        }
        InstanceManager.getDefault(ZeroConfServiceManager.class).allServices().forEach(zcs -> this.addLine(list, "ZeroConf service " + zcs.getKey(), zcs.getServiceInfo().getNiceTextString()));
    }

    private void addComPortInfo(List<String> list) {
        Vector<String> portNames = AbstractSerialPortController.getActualPortNames();
        for (String name : portNames) {
            PortNameMapper.SerialPortFriendlyName port = PortNameMapper.getPortNameMap().get(name);
            if (port == null) {
                port = new PortNameMapper.SerialPortFriendlyName(name, null);
                PortNameMapper.getPortNameMap().put(name, port);
            }
            this.addLine(list, " Port: " + name, "");
        }
    }

    private void addLine(List<String> list, String item, String value) {
        list.add(String.format("|%s|%s|", this.escapePipes(item), this.escapePipes(value)));
    }

    private String escapePipes(String input) {
        return input.replace("|", "\\|");
    }
}

