/*
 * Decompiled with CFR 0.152.
 */
package apps.util.issuereporter.swing;

import apps.util.issuereporter.BugReport;
import apps.util.issuereporter.EnhancementRequest;
import apps.util.issuereporter.GitHubRepository;
import apps.util.issuereporter.IssueReport;
import apps.util.issuereporter.IssueReport414Exception;
import apps.util.issuereporter.swing.Bundle;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.Application;
import jmri.util.swing.JmriJOptionPane;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public class IssueReporter
extends JFrame
implements ClipboardOwner,
DocumentListener {
    private static final int BUG = 0;
    private static final int RFE = 1;
    private JComboBox<String> typeCB;
    private JComboBox<GitHubRepository> repoCB;
    private JTextArea bodyTA;
    private JToggleButton submitBtn;
    private JTextField titleText;
    private JLabel descriptionLabel;
    private JLabel instructionsLabel;
    private JPanel typeOptionsPanel;
    private JPanel bugReportPanel;
    private JCheckBox profileCB;
    private JCheckBox sysInfoCB;
    private JCheckBox logsCB;
    private static final Logger log = LoggerFactory.getLogger(IssueReporter.class);

    public IssueReporter() {
        this.initComponents();
    }

    private void initComponents() {
        this.titleText = new JTextField();
        this.bodyTA = new JTextArea();
        this.submitBtn = new JToggleButton();
        this.typeCB = new JComboBox();
        this.repoCB = new JComboBox();
        this.typeOptionsPanel = new JPanel();
        this.bugReportPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.instructionsLabel = new JLabel();
        JLabel titleLabel = new JLabel();
        JScrollPane bodySP = new JScrollPane();
        JLabel typeLabel = new JLabel();
        JLabel repoLabel = new JLabel();
        this.profileCB = new JCheckBox();
        this.sysInfoCB = new JCheckBox();
        this.logsCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(Bundle.getMessage("IssueReporterAction.title", ""));
        this.setPreferredSize(new Dimension(400, 600));
        titleLabel.setFont(titleLabel.getFont().deriveFont(titleLabel.getFont().getStyle()));
        titleLabel.setText(Bundle.getMessage("IssueReporter.titleLabel.text"));
        this.bodyTA.setColumns(20);
        this.bodyTA.setLineWrap(true);
        this.bodyTA.setRows(5);
        this.bodyTA.setWrapStyleWord(true);
        bodySP.setViewportView(this.bodyTA);
        this.submitBtn.setText(Bundle.getMessage("IssueReporter.submitBtn.text"));
        this.submitBtn.setEnabled(false);
        this.submitBtn.addActionListener(this::submitBtnActionListener);
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(this.descriptionLabel.getFont().getStyle() | 1));
        this.descriptionLabel.setText(Bundle.getMessage("IssueReporter.descriptionLabel.bug"));
        this.instructionsLabel.setText(Bundle.getMessage("IssueReporter.instructionsLabel.bug"));
        typeLabel.setFont(typeLabel.getFont().deriveFont(typeLabel.getFont().getStyle()));
        typeLabel.setText(Bundle.getMessage("IssueReporter.typeLabel.text"));
        this.typeCB.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.getMessage("IssueReporterType.bug"), Bundle.getMessage("IssueReporterType.feature")}));
        this.typeCB.addActionListener(this::typeCBActionListener);
        repoLabel.setFont(repoLabel.getFont().deriveFont(repoLabel.getFont().getStyle()));
        repoLabel.setText(Bundle.getMessage("IssueReporter.repoLabel.text"));
        this.repoCB.setModel(new GitHubRepositoryComboBoxModel());
        this.repoCB.setRenderer(new GitHubRepositoryListCellRenderer());
        this.profileCB.setText(Bundle.getMessage("IssueReporter.profileCB.text"));
        this.sysInfoCB.setText(Bundle.getMessage("IssueReporter.sysInfoCB.text"));
        this.logsCB.setText(Bundle.getMessage("IssueReporter.logsCB.text"));
        this.titleText.getDocument().addDocumentListener(this);
        this.bodyTA.getDocument().addDocumentListener(this);
        GroupLayout bugReportPanelLayout = new GroupLayout(this.bugReportPanel);
        this.bugReportPanel.setLayout(bugReportPanelLayout);
        bugReportPanelLayout.setHorizontalGroup(bugReportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bugReportPanelLayout.createSequentialGroup().addContainerGap().addGroup(bugReportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysInfoCB).addComponent(this.logsCB).addComponent(this.profileCB)).addContainerGap(-1, Short.MAX_VALUE)));
        bugReportPanelLayout.setVerticalGroup(bugReportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bugReportPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sysInfoCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logsCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profileCB).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout typeOptionsPanelLayout = new GroupLayout(this.typeOptionsPanel);
        this.typeOptionsPanel.setLayout(typeOptionsPanelLayout);
        typeOptionsPanelLayout.setHorizontalGroup(typeOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bugReportPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        typeOptionsPanelLayout.setVerticalGroup(typeOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bugReportPanel, -2, -1, -2));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(bodySP, -1, 376, Short.MAX_VALUE).addComponent(this.instructionsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.submitBtn)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(typeLabel, -2, 70, Short.MAX_VALUE).addComponent(repoLabel, -2, 70, Short.MAX_VALUE).addComponent(titleLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeCB, 0, -1, Short.MAX_VALUE).addComponent(this.repoCB, 0, -1, Short.MAX_VALUE).addComponent(this.titleText))).addComponent(this.typeOptionsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, titleLabel, typeLabel, repoLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeCB, -2, -1, -2).addComponent(typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repoCB, -2, -1, -2).addComponent(repoLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(titleLabel).addComponent(this.titleText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(bodySP, -1, 109, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeOptionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitBtn).addContainerGap()));
        this.pack();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.submitBtn.setEnabled(!this.bodyTA.getText().isEmpty() && !this.titleText.getText().isEmpty());
    }

    private void typeCBActionListener(ActionEvent e) {
        switch (this.typeCB.getSelectedIndex()) {
            case 0: {
                this.descriptionLabel.setText(Bundle.getMessage("IssueReporter.descriptionLabel.bug"));
                this.instructionsLabel.setText(Bundle.getMessage("IssueReporter.instructionsLabel.bug"));
                if (this.typeOptionsPanel.equals(this.bugReportPanel.getParent())) break;
                this.typeOptionsPanel.add(this.bugReportPanel);
                this.typeOptionsPanel.setPreferredSize(this.bugReportPanel.getPreferredSize());
                this.bugReportPanel.revalidate();
                this.bugReportPanel.repaint();
                break;
            }
            case 1: {
                this.descriptionLabel.setText(Bundle.getMessage("IssueReporter.descriptionLabel.feature"));
                this.instructionsLabel.setText(Bundle.getMessage("IssueReporter.instructionsLabel.feature"));
                this.typeOptionsPanel.remove(this.bugReportPanel);
                break;
            }
            default: {
                log.error("Unexpected selected index {} for issue type", (Object)this.typeCB.getSelectedIndex(), (Object)new IllegalArgumentException());
            }
        }
    }

    private void submitBtnActionListener(ActionEvent e) {
        IssueReport report = null;
        switch (this.typeCB.getSelectedIndex()) {
            case 0: {
                report = new BugReport(this.titleText.getText(), this.bodyTA.getText(), this.profileCB.isSelected(), this.sysInfoCB.isSelected(), this.logsCB.isSelected());
                break;
            }
            case 1: {
                report = new EnhancementRequest(this.titleText.getText(), this.bodyTA.getText());
                break;
            }
            default: {
                log.error("Unexpected selected index {} for issue type", (Object)this.typeCB.getSelectedIndex(), (Object)new IllegalArgumentException());
            }
        }
        if (report != null) {
            this.submitReport(report);
        }
    }

    private void submitReport(IssueReport report) {
        try {
            URI uri = report.submit(this.repoCB.getItemAt(this.repoCB.getSelectedIndex()));
            List<File> attachments = report.getAttachments();
            if (!attachments.isEmpty()) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IssueReporter.attachments.message"), Bundle.getMessage("IssueReporter.attachments.title"), 1);
                Desktop.getDesktop().open(attachments.get(0).getParentFile());
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(uri);
                this.dispatchEvent(new WindowEvent(this, 201));
            } else {
                Object[] options = new Object[]{Bundle.getMessage("IssueReporter.browser.copy"), Bundle.getMessage("IssueReporter.browser.skip")};
                int choice = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("IssueReporter.browser.message"), Bundle.getMessage("IssueReporter.browser.title"), 0, 1, null, options, Bundle.getMessage("IssueReporter.browser.copy"));
                if (choice == 0) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(uri.toString()), null);
                    this.dispatchEvent(new WindowEvent(this, 201));
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            log.error("Unable to report issue", (Throwable)ex);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IssueReporter.error.message", ex.getLocalizedMessage()), Bundle.getMessage("IssueReporter.error.title"), 0);
        }
        catch (IssueReport414Exception ex) {
            BodyTransferable bt = new BodyTransferable(report.getBody());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(bt, this);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IssueReporter.414.message"), Bundle.getMessage("IssueReporter.414.title"), 1);
            this.submitReport(report);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public static class BodyTransferable
    implements Transferable {
        private final String body;

        public BodyTransferable(@Nonnull String body) {
            this.body = body;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.body;
        }
    }

    public static class FileTransferable
    implements Transferable {
        private final List<File> files;

        public FileTransferable(@Nonnull List<File> files) {
            this.files = files;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.files;
        }
    }

    private static class GitHubRepositoryListCellRenderer
    extends DefaultListCellRenderer {
        private GitHubRepositoryListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value instanceof GitHubRepository ? ((GitHubRepository)value).getTitle() : value, index, isSelected, cellHasFocus);
        }
    }

    private static class GitHubRepositoryComboBoxModel
    extends DefaultComboBoxModel<GitHubRepository> {
        public GitHubRepositoryComboBoxModel() {
            ServiceLoader<GitHubRepository> loader = ServiceLoader.load(GitHubRepository.class);
            TreeSet set = new TreeSet();
            loader.forEach(set::add);
            loader.reload();
            set.forEach(r -> {
                this.addElement(r);
                if (r.getTitle().equals(Application.getApplicationName())) {
                    this.setSelectedItem(r);
                }
            });
        }
    }
}

