/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.Bundle;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.ProvidingManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.implementation.AbstractShutDownTask;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.display.layoutEditor.BlockValueFile;
import jmri.managers.AbstractManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManager
extends AbstractManager<Block>
implements ProvidingManager<Block>,
InstanceManagerAutoDefault {
    private final String powerManagerChangeName;
    public final ShutDownTask shutDownTask = new AbstractShutDownTask("Writing Blocks"){

        @Override
        public void run() {
            try {
                new BlockValueFile().writeBlockValues();
            }
            catch (IOException ex) {
                log.error("Exception writing blocks", (Throwable)ex);
            }
        }
    };
    public static final String PROPERTY_DEFAULT_BLOCK_SPEED_CHANGE = "DefaultBlockSpeedChange";
    private boolean saveBlockPath = true;
    private String defaultSpeed = "Normal";
    private Instant lastTimeLayoutPowerOn;
    private static final Logger log = LoggerFactory.getLogger(BlockManager.class);

    public BlockManager() {
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(ReporterManager.class).addVetoableChangeListener(this);
        InstanceManager.getList(PowerManager.class).forEach(pm -> pm.addPropertyChangeListener(this));
        this.powerManagerChangeName = InstanceManager.getListPropertyName(PowerManager.class);
        InstanceManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(SensorManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(ReporterManager.class).removeVetoableChangeListener(this);
        InstanceManager.getList(PowerManager.class).forEach(pm -> pm.removePropertyChangeListener(this));
        InstanceManager.removePropertyChangeListener(this);
        super.dispose();
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    @Override
    @CheckReturnValue
    public int getXMLOrder() {
        return 100;
    }

    @Override
    @CheckReturnValue
    public char typeLetter() {
        return 'B';
    }

    @Override
    public Class<Block> getNamedBeanClass() {
        return Block.class;
    }

    @CheckReturnValue
    public boolean isSavedPathInfo() {
        return this.saveBlockPath;
    }

    public void setSavedPathInfo(boolean save) {
        this.saveBlockPath = save;
    }

    @CheckForNull
    public Block createNewBlock(@Nonnull String systemName, @CheckForNull String userName) {
        Block r;
        if (userName != null && !userName.isEmpty() && (r = (Block)this.getByUserName(userName)) != null) {
            return null;
        }
        r = (Block)this.getBySystemName(systemName);
        if (r != null) {
            return null;
        }
        r = new Block(systemName, userName);
        this.updateAutoNumber(systemName);
        this.register(r);
        try {
            r.setBlockSpeed("Global");
        }
        catch (JmriException ex) {
            log.error("Unexpected exception {}", (Object)ex.getMessage());
        }
        return r;
    }

    @CheckForNull
    public Block createNewBlock(@CheckForNull String userName) {
        return this.createNewBlock(this.getAutoSystemName(), userName);
    }

    @Nonnull
    public Block provideBlock(@Nonnull String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Could not create block, no name supplied");
        }
        Block b = this.getBlock(name);
        if (b != null) {
            return b;
        }
        b = name.startsWith(this.getSystemNamePrefix()) ? this.createNewBlock(name, null) : this.createNewBlock(name);
        if (b == null) {
            throw new IllegalArgumentException("Could not create block \"" + name + "\"");
        }
        return b;
    }

    @CheckReturnValue
    @CheckForNull
    public Block getBlock(@Nonnull String name) {
        Block r = (Block)this.getByUserName(name);
        if (r != null) {
            return r;
        }
        return (Block)this.getBySystemName(name);
    }

    @CheckReturnValue
    @CheckForNull
    public Block getByDisplayName(@Nonnull String key) {
        Block retv = (Block)this.getByUserName(key);
        if (retv == null) {
            retv = (Block)this.getBySystemName(key);
        }
        return retv;
    }

    public void setDefaultSpeed(@Nonnull String speed) {
        if (this.defaultSpeed.equals(speed)) {
            return;
        }
        try {
            Float.valueOf(speed);
        }
        catch (NumberFormatException nx) {
            try {
                InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Value of requested default block speed \"" + speed + "\" is not valid", ex);
            }
        }
        String oldSpeed = this.defaultSpeed;
        this.defaultSpeed = speed;
        this.firePropertyChange(PROPERTY_DEFAULT_BLOCK_SPEED_CHANGE, oldSpeed, speed);
    }

    @CheckReturnValue
    @Nonnull
    public String getDefaultSpeed() {
        return this.defaultSpeed;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameBlocks" : "BeanNameBlock");
    }

    @CheckReturnValue
    @Nonnull
    public List<Block> getBlocksOccupiedByRosterEntry(@Nonnull BasicRosterEntry re) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        this.getNamedBeanSet().stream().forEach(b -> {
            Object obj;
            if (b != null && (obj = b.getValue()) != null && this.blockValueEqualsRosterEntry(obj, re)) {
                blockList.add((Block)b);
            }
        });
        return blockList;
    }

    private boolean blockValueEqualsRosterEntry(@Nonnull Object obj, @Nonnull BasicRosterEntry re) {
        return obj instanceof BasicRosterEntry && obj == re || obj.toString().equals(re.getId()) || obj.toString().equals(re.getDccAddress());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        PowerManager pm2;
        super.propertyChange(e);
        if ("power".equals(e.getPropertyName())) {
            try {
                pm2 = (PowerManager)e.getSource();
                if (pm2.getPower() == 2) {
                    this.lastTimeLayoutPowerOn = Instant.now();
                }
            }
            catch (NoSuchMethodError pm2) {
                // empty catch block
            }
        }
        if (this.powerManagerChangeName.equals(e.getPropertyName())) {
            if (e.getNewValue() == null) {
                pm2 = (PowerManager)e.getOldValue();
                pm2.removePropertyChangeListener(this);
            } else {
                pm2 = (PowerManager)e.getNewValue();
                pm2.addPropertyChangeListener(this);
            }
        }
    }

    public long timeSinceLastLayoutPowerOn() {
        if (this.lastTimeLayoutPowerOn == null) {
            return Long.MAX_VALUE;
        }
        return Instant.now().toEpochMilli() - this.lastTimeLayoutPowerOn.toEpochMilli();
    }

    @Override
    @Nonnull
    public Block provide(@Nonnull String name) {
        return this.provideBlock(name);
    }
}

