/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import jmri.Permission;
import jmri.PermissionValue;
import jmri.Role;

public interface BooleanPermission
extends Permission {
    @Override
    default public String getValue(PermissionValue value) {
        if (!(value instanceof BooleanValue)) {
            throw new IllegalArgumentException("value is not a BooleanValue");
        }
        return ((BooleanValue)value).get() ? "yes" : "no";
    }

    @Override
    default public PermissionValue valueOf(String value) {
        return BooleanValue.get("yes".equals(value));
    }

    @Override
    default public BooleanValue getDefaultPermission() {
        return BooleanValue.FALSE;
    }

    @Override
    public BooleanValue getDefaultPermission(Role var1);

    @Override
    default public int compare(PermissionValue o1, PermissionValue o2) {
        if (o1 instanceof BooleanValue && o2 instanceof BooleanValue) {
            boolean b1 = ((BooleanValue)o1).get();
            boolean b2 = ((BooleanValue)o2).get();
            return Boolean.compare(b1, b2);
        }
        throw new IllegalArgumentException("Cannot compare o1 and o2 since one or both is not a BooleanValue");
    }

    public static class BooleanValue
    implements PermissionValue {
        public static final BooleanValue TRUE = new BooleanValue(true);
        public static final BooleanValue FALSE = new BooleanValue(false);
        private final boolean _value;

        public boolean get() {
            return this._value;
        }

        public static BooleanValue get(boolean value) {
            return value ? TRUE : FALSE;
        }

        private BooleanValue(boolean value) {
            this._value = value;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        public String toString() {
            return Boolean.toString(this._value);
        }
    }
}

