/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public class Bundle {
    @CheckForNull
    private static final String name = "jmri.NamedBeanBundle";
    private static final Bundle b = new Bundle();
    private static final Logger log = LoggerFactory.getLogger(Bundle.class);

    static String getMessage(String key) {
        return Bundle.getBundle().handleGetMessage(key);
    }

    static String getMessage(Locale locale, String key) {
        return Bundle.getBundle().handleGetMessage(locale, key);
    }

    static String getMessage(String key, Object ... subs) {
        return Bundle.getBundle().handleGetMessage(key, subs);
    }

    static String getMessage(Locale locale, String key, Object ... subs) {
        return Bundle.getBundle().handleGetMessage(locale, key, subs);
    }

    public String handleGetMessage(String key) {
        return this.handleGetMessage(Locale.getDefault(), key);
    }

    public String handleGetMessage(Locale locale, String key) {
        log.trace("handleGetMessage for key {}", (Object)key);
        if (this.bundleName() != null) {
            ResourceBundle rb = ResourceBundle.getBundle(this.bundleName(), locale);
            if (rb.containsKey(key)) {
                return rb.getString(key);
            }
            return this.retry(locale, key);
        }
        return this.retry(locale, key);
    }

    public String handleGetMessage(String key, Object[] subs) {
        return this.handleGetMessage(Locale.getDefault(), key, subs);
    }

    public String handleGetMessage(Locale locale, String key, Object[] subs) {
        return MessageFormat.format(this.handleGetMessage(locale, key), subs);
    }

    public static String formatMessage(String message, Object ... subs) {
        return MessageFormat.format(message, subs);
    }

    protected String retry(Locale locale, String key) throws MissingResourceException {
        throw new MissingResourceException("Resource '" + key + "' not found", this.getClass().toString(), key);
    }

    @CheckForNull
    protected String bundleName() {
        return name;
    }

    protected static Bundle getBundle() {
        return b;
    }
}

