/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;
import jmri.CatalogTreeLeaf;
import jmri.util.swing.DefaultMutableTreeNode;

public class CatalogTreeNode
extends DefaultMutableTreeNode {
    private ArrayList<CatalogTreeLeaf> _leafs = new ArrayList();

    public CatalogTreeNode(String name) {
        super(name);
    }

    public void addLeaf(CatalogTreeLeaf leaf) {
        this._leafs.add(leaf);
    }

    public void addLeaf(String name, String path) {
        int h = 0;
        this._leafs.add(new CatalogTreeLeaf(name, path, h));
    }

    public void deleteLeaves(String name) {
        Iterator<CatalogTreeLeaf> iterator = this._leafs.iterator();
        while (iterator.hasNext()) {
            CatalogTreeLeaf leaf = iterator.next();
            if (!name.equals(leaf.getName())) continue;
            iterator.remove();
        }
    }

    public void deleteLeaf(String name, String path) {
        for (int i = 0; i < this._leafs.size(); ++i) {
            CatalogTreeLeaf leaf = this._leafs.get(i);
            if (!name.equals(leaf.getName()) || !path.equals(leaf.getPath())) continue;
            this._leafs.remove(i);
            return;
        }
    }

    public CatalogTreeLeaf getLeaf(String name, String path) {
        for (CatalogTreeLeaf leaf : this._leafs) {
            if (!name.equals(leaf.getName()) || !path.equals(leaf.getPath())) continue;
            return leaf;
        }
        return null;
    }

    public ArrayList<CatalogTreeLeaf> getLeaves(String name) {
        ArrayList<CatalogTreeLeaf> leafs = new ArrayList<CatalogTreeLeaf>();
        for (CatalogTreeLeaf leaf : this._leafs) {
            if (!name.equals(leaf.getName())) continue;
            leafs.add(leaf);
        }
        return leafs;
    }

    @Override
    public Enumeration<TreeNode> children() {
        return super.children();
    }

    public ArrayList<CatalogTreeLeaf> getLeaves() {
        return this._leafs;
    }

    public int getNumLeaves() {
        return this._leafs.size();
    }

    public void setLeaves(ArrayList<CatalogTreeLeaf> leafs) {
        this._leafs = leafs;
    }
}

