/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import jmri.InstanceManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.TurnoutOperator;
import jmri.implementation.AbstractTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonTurnoutOperation
extends TurnoutOperation {
    int interval;
    int maxTries;
    public static final int minInterval = 100;
    public static final int maxInterval = 5000;
    public static final int intervalStepSize = 50;
    public static final int minMaxTries = 1;
    public static final int maxMaxTries = 10;
    private static final Logger log = LoggerFactory.getLogger(CommonTurnoutOperation.class);

    public CommonTurnoutOperation(String name, int interval, int maxTries) {
        super(name);
        this.init(interval, maxTries);
    }

    private void init(int interval, int maxTries) {
        this.setInterval(this.getDefaultInterval());
        this.setInterval(interval);
        this.setMaxTries(this.getDefaultMaxTries());
        this.setMaxTries(maxTries);
        InstanceManager.getDefault(TurnoutOperationManager.class).addOperation(this);
    }

    @Override
    public abstract TurnoutOperator getOperator(AbstractTurnout var1);

    public int getInterval() {
        return this.interval;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public abstract int getDefaultInterval();

    public abstract int getDefaultMaxTries();

    @Override
    public boolean equivalentTo(TurnoutOperation other) {
        if (other != null && this.getClass() == other.getClass()) {
            return this.interval == ((CommonTurnoutOperation)other).interval && this.maxTries == ((CommonTurnoutOperation)other).maxTries;
        }
        return false;
    }

    public void setInterval(int newInterval) {
        if (newInterval >= 100 && newInterval <= 5000) {
            this.interval = newInterval;
            return;
        }
        log.warn("Could not set {} Interval to {}, out of range {}-{}", new Object[]{this.name, newInterval, 100, 5000});
    }

    public void setMaxTries(int newMaxTries) {
        if (newMaxTries >= 1 && newMaxTries <= 10) {
            this.maxTries = newMaxTries;
        }
    }
}

