/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Bundle;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.NamedBean;

public interface Conditional
extends NamedBean {
    public static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    public static final ResourceBundle rbxWarrant = ResourceBundle.getBundle("jmri.jmrit.logix.WarrantBundle");
    public static final int FALSE = 2;
    public static final int TRUE = 4;
    public static final int ALL_AND = 1;
    public static final int ALL_OR = 2;
    public static final int MIXED = 3;
    public static final int OPERATOR_AND = 1;
    public static final int OPERATOR_NONE = 4;
    public static final int OPERATOR_OR = 5;
    public static final int TYPE_ERROR = -1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SENSOR_ACTIVE = 1;
    public static final int TYPE_SENSOR_INACTIVE = 2;
    public static final int TYPE_TURNOUT_THROWN = 3;
    public static final int TYPE_TURNOUT_CLOSED = 4;
    public static final int TYPE_CONDITIONAL_TRUE = 5;
    public static final int TYPE_CONDITIONAL_FALSE = 6;
    public static final int TYPE_LIGHT_ON = 7;
    public static final int TYPE_LIGHT_OFF = 8;
    public static final int TYPE_MEMORY_EQUALS = 9;
    public static final int TYPE_FAST_CLOCK_RANGE = 10;
    public static final int TYPE_SIGNAL_HEAD_RED = 11;
    public static final int TYPE_SIGNAL_HEAD_YELLOW = 12;
    public static final int TYPE_SIGNAL_HEAD_GREEN = 13;
    public static final int TYPE_SIGNAL_HEAD_DARK = 14;
    public static final int TYPE_SIGNAL_HEAD_FLASHRED = 15;
    public static final int TYPE_SIGNAL_HEAD_FLASHYELLOW = 16;
    public static final int TYPE_SIGNAL_HEAD_FLASHGREEN = 17;
    public static final int TYPE_SIGNAL_HEAD_LIT = 18;
    public static final int TYPE_SIGNAL_HEAD_HELD = 19;
    public static final int TYPE_MEMORY_COMPARE = 20;
    public static final int TYPE_SIGNAL_HEAD_LUNAR = 21;
    public static final int TYPE_SIGNAL_HEAD_FLASHLUNAR = 22;
    public static final int TYPE_MEMORY_EQUALS_INSENSITIVE = 23;
    public static final int TYPE_MEMORY_COMPARE_INSENSITIVE = 24;
    public static final int TYPE_ROUTE_FREE = 25;
    public static final int TYPE_ROUTE_OCCUPIED = 26;
    public static final int TYPE_ROUTE_ALLOCATED = 27;
    public static final int TYPE_ROUTE_SET = 28;
    public static final int TYPE_TRAIN_RUNNING = 29;
    public static final int TYPE_SIGNAL_MAST_ASPECT_EQUALS = 30;
    public static final int TYPE_SIGNAL_MAST_LIT = 31;
    public static final int TYPE_SIGNAL_MAST_HELD = 32;
    public static final int TYPE_SIGNAL_HEAD_APPEARANCE_EQUALS = 33;
    public static final int TYPE_BLOCK_STATUS_EQUALS = 34;
    public static final int TYPE_ENTRYEXIT_ACTIVE = 35;
    public static final int TYPE_ENTRYEXIT_INACTIVE = 36;
    public static final int TYPE_OBLOCK_UNOCCUPIED = 37;
    public static final int TYPE_OBLOCK_OCCUPIED = 38;
    public static final int TYPE_OBLOCK_ALLOCATED = 39;
    public static final int TYPE_OBLOCK_RUNNING = 40;
    public static final int TYPE_OBLOCK_OUT_OF_SERVICE = 41;
    public static final int TYPE_OBLOCK_DARK = 42;
    public static final int TYPE_OBLOCK_POWER_ERROR = 43;
    public static final int TYPE_XXXXXXX = 9999;
    public static final int ACTION_OPTION_ON_CHANGE_TO_TRUE = 1;
    public static final int ACTION_OPTION_ON_CHANGE_TO_FALSE = 2;
    public static final int ACTION_OPTION_ON_CHANGE = 3;
    public static final int NUM_ACTION_OPTIONS = 3;
    public static final int ACTION_NONE = 1;
    public static final int ACTION_SET_TURNOUT = 2;
    public static final int ACTION_SET_SIGNAL_APPEARANCE = 3;
    public static final int ACTION_SET_SIGNAL_HELD = 4;
    public static final int ACTION_CLEAR_SIGNAL_HELD = 5;
    public static final int ACTION_SET_SIGNAL_DARK = 6;
    public static final int ACTION_SET_SIGNAL_LIT = 7;
    public static final int ACTION_TRIGGER_ROUTE = 8;
    public static final int ACTION_SET_SENSOR = 9;
    public static final int ACTION_DELAYED_SENSOR = 10;
    public static final int ACTION_SET_LIGHT = 11;
    public static final int ACTION_SET_MEMORY = 12;
    public static final int ACTION_ENABLE_LOGIX = 13;
    public static final int ACTION_DISABLE_LOGIX = 14;
    public static final int ACTION_PLAY_SOUND = 15;
    public static final int ACTION_RUN_SCRIPT = 16;
    public static final int ACTION_DELAYED_TURNOUT = 17;
    public static final int ACTION_LOCK_TURNOUT = 18;
    public static final int ACTION_RESET_DELAYED_SENSOR = 19;
    public static final int ACTION_CANCEL_SENSOR_TIMERS = 20;
    public static final int ACTION_RESET_DELAYED_TURNOUT = 21;
    public static final int ACTION_CANCEL_TURNOUT_TIMERS = 22;
    public static final int ACTION_SET_FAST_CLOCK_TIME = 23;
    public static final int ACTION_START_FAST_CLOCK = 24;
    public static final int ACTION_STOP_FAST_CLOCK = 25;
    public static final int ACTION_COPY_MEMORY = 26;
    public static final int ACTION_SET_LIGHT_INTENSITY = 27;
    public static final int ACTION_SET_LIGHT_TRANSITION_TIME = 28;
    public static final int ACTION_CONTROL_AUDIO = 29;
    public static final int ACTION_JYTHON_COMMAND = 30;
    public static final int ACTION_ALLOCATE_WARRANT_ROUTE = 31;
    public static final int ACTION_DEALLOCATE_WARRANT_ROUTE = 32;
    public static final int ACTION_SET_ROUTE_TURNOUTS = 33;
    public static final int ACTION_AUTO_RUN_WARRANT = 34;
    public static final int ACTION_CONTROL_TRAIN = 35;
    public static final int ACTION_SET_TRAIN_ID = 36;
    public static final int ACTION_SET_SIGNALMAST_ASPECT = 37;
    public static final int ACTION_GET_TRAIN_LOCATION = 38;
    public static final int ACTION_SET_SIGNALMAST_HELD = 39;
    public static final int ACTION_CLEAR_SIGNALMAST_HELD = 40;
    public static final int ACTION_SET_SIGNALMAST_DARK = 41;
    public static final int ACTION_SET_SIGNALMAST_LIT = 42;
    public static final int ACTION_SET_BLOCK_ERROR = 43;
    public static final int ACTION_CLEAR_BLOCK_ERROR = 44;
    public static final int ACTION_DEALLOCATE_BLOCK = 45;
    public static final int ACTION_SET_BLOCK_OUT_OF_SERVICE = 46;
    public static final int ACTION_SET_BLOCK_IN_SERVICE = 47;
    public static final int ACTION_MANUAL_RUN_WARRANT = 48;
    public static final int ACTION_SET_TRAIN_NAME = 49;
    public static final int ACTION_SET_BLOCK_VALUE = 50;
    public static final int ACTION_SET_NXPAIR_ENABLED = 51;
    public static final int ACTION_SET_NXPAIR_DISABLED = 52;
    public static final int ACTION_SET_NXPAIR_SEGMENT = 53;
    public static final int ACTION_GET_BLOCK_WARRANT = 54;
    public static final int ACTION_GET_BLOCK_TRAIN_NAME = 55;
    public static final int ITEM_TYPE_SENSOR = 1;
    public static final int ITEM_TYPE_TURNOUT = 2;
    public static final int ITEM_TYPE_LIGHT = 3;
    public static final int ITEM_TYPE_SIGNALHEAD = 4;
    public static final int ITEM_TYPE_SIGNALMAST = 5;
    public static final int ITEM_TYPE_MEMORY = 6;
    public static final int ITEM_TYPE_CONDITIONAL = 7;
    public static final int ITEM_TYPE_LOGIX = 7;
    public static final int ITEM_TYPE_WARRANT = 8;
    public static final int ITEM_TYPE_CLOCK = 9;
    public static final int ITEM_TYPE_OBLOCK = 10;
    public static final int ITEM_TYPE_ENTRYEXIT = 11;
    public static final int ITEM_TYPE_AUDIO = 12;
    public static final int ITEM_TYPE_SCRIPT = 13;
    public static final int ITEM_TYPE_OTHER = 14;

    public void setLogicType(AntecedentOperator var1, String var2);

    public String getAntecedentExpression();

    public AntecedentOperator getLogicType();

    public boolean getTriggerOnChange();

    public void setTriggerOnChange(boolean var1);

    public void setAction(@Nonnull List<ConditionalAction> var1);

    @Nonnull
    public List<ConditionalAction> getCopyOfActions();

    public void setStateVariables(@Nonnull List<ConditionalVariable> var1);

    @Nonnull
    public List<ConditionalVariable> getCopyOfStateVariables();

    public int calculate(boolean var1, PropertyChangeEvent var2);

    @CheckForNull
    public String validateAntecedent(@Nonnull String var1, List<ConditionalVariable> var2);

    public void cancelSensorTimer(String var1);

    public void cancelTurnoutTimer(String var1);

    @Override
    public int getState();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener var1);

    @Override
    public void removePropertyChangeListener(PropertyChangeListener var1);

    @Override
    public void dispose();

    public static enum Action {
        NONE(1, ItemType.NONE, ""),
        SET_TURNOUT(2, ItemType.TURNOUT, rbx.getString("ActionSetTurnout")),
        SET_SIGNAL_APPEARANCE(3, ItemType.SIGNALHEAD, rbx.getString("ActionSetSignal")),
        SET_SIGNAL_HELD(4, ItemType.SIGNALHEAD, rbx.getString("ActionSetSignalHeld")),
        CLEAR_SIGNAL_HELD(5, ItemType.SIGNALHEAD, rbx.getString("ActionClearSignalHeld")),
        SET_SIGNAL_DARK(6, ItemType.SIGNALHEAD, rbx.getString("ActionSetSignalDark")),
        SET_SIGNAL_LIT(7, ItemType.SIGNALHEAD, rbx.getString("ActionSetSignalLit")),
        TRIGGER_ROUTE(8, ItemType.OTHER, rbx.getString("ActionTriggerRoute")),
        SET_SENSOR(9, ItemType.SENSOR, rbx.getString("ActionSetSensor")),
        DELAYED_SENSOR(10, ItemType.SENSOR, rbx.getString("ActionDelayedSensor")),
        SET_LIGHT(11, ItemType.LIGHT, rbx.getString("ActionSetLight")),
        SET_MEMORY(12, ItemType.MEMORY, rbx.getString("ActionSetMemory")),
        ENABLE_LOGIX(13, ItemType.LOGIX, rbx.getString("ActionEnableLogix")),
        DISABLE_LOGIX(14, ItemType.LOGIX, rbx.getString("ActionDisableLogix")),
        PLAY_SOUND(15, ItemType.AUDIO, rbx.getString("ActionPlaySound")),
        RUN_SCRIPT(16, ItemType.SCRIPT, rbx.getString("ActionRunScript")),
        DELAYED_TURNOUT(17, ItemType.TURNOUT, rbx.getString("ActionDelayedTurnout")),
        LOCK_TURNOUT(18, ItemType.TURNOUT, rbx.getString("ActionTurnoutLock")),
        RESET_DELAYED_SENSOR(19, ItemType.SENSOR, rbx.getString("ActionResetDelayedSensor")),
        CANCEL_SENSOR_TIMERS(20, ItemType.SENSOR, rbx.getString("ActionCancelSensorTimers")),
        RESET_DELAYED_TURNOUT(21, ItemType.TURNOUT, rbx.getString("ActionResetDelayedTurnout")),
        CANCEL_TURNOUT_TIMERS(22, ItemType.TURNOUT, rbx.getString("ActionCancelTurnoutTimers")),
        SET_FAST_CLOCK_TIME(23, ItemType.CLOCK, rbx.getString("ActionSetFastClockTime")),
        START_FAST_CLOCK(24, ItemType.CLOCK, rbx.getString("ActionStartFastClock")),
        STOP_FAST_CLOCK(25, ItemType.CLOCK, rbx.getString("ActionStopFastClock")),
        COPY_MEMORY(26, ItemType.MEMORY, rbx.getString("ActionCopyMemory")),
        SET_LIGHT_INTENSITY(27, ItemType.LIGHT, rbx.getString("ActionSetLightIntensity")),
        SET_LIGHT_TRANSITION_TIME(28, ItemType.LIGHT, rbx.getString("ActionSetLightTransitionTime")),
        CONTROL_AUDIO(29, ItemType.AUDIO, rbx.getString("ActionControlAudio")),
        JYTHON_COMMAND(30, ItemType.SCRIPT, rbx.getString("ActionJythonCommand")),
        ALLOCATE_WARRANT_ROUTE(31, ItemType.WARRANT, rbx.getString("ActionAllocateWarrant")),
        DEALLOCATE_WARRANT_ROUTE(32, ItemType.WARRANT, rbx.getString("ActionDeallocateWarrant")),
        SET_ROUTE_TURNOUTS(33, ItemType.WARRANT, rbx.getString("ActionSetWarrantTurnouts")),
        AUTO_RUN_WARRANT(34, ItemType.WARRANT, rbx.getString("ActionAutoRunWarrant")),
        MANUAL_RUN_WARRANT(48, ItemType.WARRANT, rbx.getString("ActionManualRunWarrant")),
        CONTROL_TRAIN(35, ItemType.WARRANT, rbx.getString("ActionControlTrain")),
        SET_TRAIN_ID(36, ItemType.WARRANT, rbx.getString("ActionSetTrainId")),
        SET_TRAIN_NAME(49, ItemType.WARRANT, rbx.getString("ActionSetTrainName")),
        SET_SIGNALMAST_ASPECT(37, ItemType.SIGNALMAST, rbx.getString("ActionSetSignalMastAspect")),
        GET_TRAIN_LOCATION(38, ItemType.WARRANT, rbx.getString("ActionSetTrainLocation")),
        GET_BLOCK_WARRANT(54, ItemType.OBLOCK, rbx.getString("ActionGetBlockWarrant")),
        GET_BLOCK_TRAIN_NAME(55, ItemType.OBLOCK, rbx.getString("ActionGetBlockTrainName")),
        SET_SIGNALMAST_HELD(39, ItemType.SIGNALMAST, rbx.getString("ActionSetSignalMastHeld")),
        CLEAR_SIGNALMAST_HELD(40, ItemType.SIGNALMAST, rbx.getString("ActionClearSignalMastHeld")),
        SET_SIGNALMAST_DARK(41, ItemType.SIGNALMAST, rbx.getString("ActionSetSignalMastDark")),
        SET_SIGNALMAST_LIT(42, ItemType.SIGNALMAST, rbx.getString("ActionClearSignalMastDark")),
        SET_BLOCK_VALUE(50, ItemType.OBLOCK, rbx.getString("ActionSetBlockValue")),
        SET_BLOCK_ERROR(43, ItemType.OBLOCK, rbx.getString("ActionSetBlockError")),
        CLEAR_BLOCK_ERROR(44, ItemType.OBLOCK, rbx.getString("ActionClearBlockError")),
        DEALLOCATE_BLOCK(45, ItemType.OBLOCK, rbx.getString("ActionDeallocateBlock")),
        SET_BLOCK_OUT_OF_SERVICE(46, ItemType.OBLOCK, rbx.getString("ActionSetBlockOutOfService")),
        SET_BLOCK_IN_SERVICE(47, ItemType.OBLOCK, rbx.getString("ActionBlockInService")),
        SET_NXPAIR_ENABLED(51, ItemType.ENTRYEXIT, rbx.getString("ActionNXPairEnabled")),
        SET_NXPAIR_DISABLED(52, ItemType.ENTRYEXIT, rbx.getString("ActionNXPairDisabled")),
        SET_NXPAIR_SEGMENT(53, ItemType.ENTRYEXIT, rbx.getString("ActionNXPairSegment"));

        private final int _item;
        private final ItemType _itemType;
        private final String _string;
        private static final List<Action> sensorItemsList;
        private static final List<Action> turnoutItemsList;
        private static final List<Action> lightItemsList;
        private static final List<Action> warrantItemsList;
        private static final List<Action> memoryItemsList;
        private static final List<Action> oblockItemsList;
        private static final List<Action> entryExitItemsList;
        private static final List<Action> signalHeadItemsList;
        private static final List<Action> signalMastItemsList;
        private static final List<Action> clockItemsList;
        private static final List<Action> logixItemsList;
        private static final List<Action> audioItemsList;
        private static final List<Action> scriptItemsList;
        private static final List<Action> otherItemsList;

        private Action(int state, ItemType itemType, String string2) {
            this._item = state;
            this._itemType = itemType;
            this._string = string2;
        }

        public ItemType getItemType() {
            return this._itemType;
        }

        public int getIntValue() {
            return this._item;
        }

        public static List<Action> getSensorItems() {
            return sensorItemsList;
        }

        public static List<Action> getTurnoutItems() {
            return turnoutItemsList;
        }

        public static List<Action> getLightItems() {
            return lightItemsList;
        }

        public static List<Action> getWarrantItems() {
            return warrantItemsList;
        }

        public static List<Action> getMemoryItems() {
            return memoryItemsList;
        }

        public static List<Action> getOBlockItems() {
            return oblockItemsList;
        }

        public static List<Action> getEntryExitItems() {
            return entryExitItemsList;
        }

        public static List<Action> getSignalHeadItems() {
            return signalHeadItemsList;
        }

        public static List<Action> getSignalMastItems() {
            return signalMastItemsList;
        }

        public static List<Action> getClockItems() {
            return clockItemsList;
        }

        public static List<Action> getLogixItems() {
            return logixItemsList;
        }

        public static List<Action> getAudioItems() {
            return audioItemsList;
        }

        public static List<Action> getScriptItems() {
            return scriptItemsList;
        }

        public static List<Action> getOtherItems() {
            return otherItemsList;
        }

        public static Action getOperatorFromIntValue(int actionInt) {
            for (Action action : Action.values()) {
                if (action.getIntValue() != actionInt) continue;
                return action;
            }
            throw new IllegalArgumentException("Action is unknown");
        }

        public String toString() {
            return this._string;
        }

        static {
            Action[] typeArray1 = new Action[]{SET_SENSOR, DELAYED_SENSOR, RESET_DELAYED_SENSOR, CANCEL_SENSOR_TIMERS};
            sensorItemsList = Collections.unmodifiableList(Arrays.asList(typeArray1));
            Action[] typeArray2 = new Action[]{SET_TURNOUT, DELAYED_TURNOUT, LOCK_TURNOUT, CANCEL_TURNOUT_TIMERS, RESET_DELAYED_TURNOUT};
            turnoutItemsList = Collections.unmodifiableList(Arrays.asList(typeArray2));
            Action[] typeArray3 = new Action[]{SET_LIGHT, SET_LIGHT_INTENSITY, SET_LIGHT_TRANSITION_TIME};
            lightItemsList = Collections.unmodifiableList(Arrays.asList(typeArray3));
            Action[] typeArray4 = new Action[]{ALLOCATE_WARRANT_ROUTE, DEALLOCATE_WARRANT_ROUTE, SET_ROUTE_TURNOUTS, AUTO_RUN_WARRANT, MANUAL_RUN_WARRANT, CONTROL_TRAIN, SET_TRAIN_ID, SET_TRAIN_NAME, GET_TRAIN_LOCATION};
            warrantItemsList = Collections.unmodifiableList(Arrays.asList(typeArray4));
            Action[] typeArray5 = new Action[]{SET_MEMORY, COPY_MEMORY};
            memoryItemsList = Collections.unmodifiableList(Arrays.asList(typeArray5));
            Action[] typeArray6 = new Action[]{SET_NXPAIR_ENABLED, SET_NXPAIR_DISABLED, SET_NXPAIR_SEGMENT};
            entryExitItemsList = Collections.unmodifiableList(Arrays.asList(typeArray6));
            Action[] typeArray7 = new Action[]{SET_SIGNAL_APPEARANCE, SET_SIGNAL_HELD, CLEAR_SIGNAL_HELD, SET_SIGNAL_DARK, SET_SIGNAL_LIT};
            signalHeadItemsList = Collections.unmodifiableList(Arrays.asList(typeArray7));
            Action[] typeArray8 = new Action[]{SET_SIGNALMAST_ASPECT, SET_SIGNALMAST_HELD, CLEAR_SIGNALMAST_HELD, SET_SIGNALMAST_DARK, SET_SIGNALMAST_LIT};
            signalMastItemsList = Collections.unmodifiableList(Arrays.asList(typeArray8));
            Action[] typeArray9 = new Action[]{SET_FAST_CLOCK_TIME, START_FAST_CLOCK, STOP_FAST_CLOCK};
            clockItemsList = Collections.unmodifiableList(Arrays.asList(typeArray9));
            Action[] typeArray10 = new Action[]{ENABLE_LOGIX, DISABLE_LOGIX};
            logixItemsList = Collections.unmodifiableList(Arrays.asList(typeArray10));
            Action[] typeArray11 = new Action[]{DEALLOCATE_BLOCK, SET_BLOCK_VALUE, SET_BLOCK_ERROR, CLEAR_BLOCK_ERROR, SET_BLOCK_OUT_OF_SERVICE, SET_BLOCK_IN_SERVICE, GET_BLOCK_TRAIN_NAME, GET_BLOCK_WARRANT};
            oblockItemsList = Collections.unmodifiableList(Arrays.asList(typeArray11));
            Action[] typeArray12 = new Action[]{PLAY_SOUND, CONTROL_AUDIO};
            audioItemsList = Collections.unmodifiableList(Arrays.asList(typeArray12));
            Action[] typeArray13 = new Action[]{RUN_SCRIPT, JYTHON_COMMAND};
            scriptItemsList = Collections.unmodifiableList(Arrays.asList(typeArray13));
            Action[] typeArray14 = new Action[]{TRIGGER_ROUTE};
            otherItemsList = Collections.unmodifiableList(Arrays.asList(typeArray14));
        }
    }

    public static enum Type {
        ERROR(-1, ItemType.NONE, "", ""),
        NONE(0, ItemType.NONE, "", ""),
        SENSOR_ACTIVE(1, ItemType.SENSOR, Bundle.getMessage("SensorStateActive"), rbx.getString("TypeSensorActive")),
        SENSOR_INACTIVE(2, ItemType.SENSOR, Bundle.getMessage("SensorStateInactive"), rbx.getString("TypeSensorInactive")),
        TURNOUT_THROWN(3, ItemType.TURNOUT, Bundle.getMessage("TurnoutStateThrown"), rbx.getString("TypeTurnoutThrown")),
        TURNOUT_CLOSED(4, ItemType.TURNOUT, Bundle.getMessage("TurnoutStateClosed"), rbx.getString("TypeTurnoutClosed")),
        CONDITIONAL_TRUE(5, ItemType.CONDITIONAL, Bundle.getMessage("True"), rbx.getString("TypeConditionalTrue")),
        CONDITIONAL_FALSE(6, ItemType.CONDITIONAL, Bundle.getMessage("False"), rbx.getString("TypeConditionalFalse")),
        LIGHT_ON(7, ItemType.LIGHT, rbx.getString("LightOn"), rbx.getString("TypeLightOn")),
        LIGHT_OFF(8, ItemType.LIGHT, rbx.getString("LightOff"), rbx.getString("TypeLightOff")),
        MEMORY_EQUALS(9, ItemType.MEMORY, rbx.getString("StateMemoryEquals"), rbx.getString("TypeMemoryEquals")),
        MEMORY_COMPARE(20, ItemType.MEMORY, rbx.getString("StateMemoryCompare"), rbx.getString("TypeMemoryCompare")),
        MEMORY_EQUALS_INSENSITIVE(23, ItemType.MEMORY, rbx.getString("StateMemoryEqualsInsensitive"), rbx.getString("TypeMemoryEqualsInsensitive")),
        MEMORY_COMPARE_INSENSITIVE(24, ItemType.MEMORY, rbx.getString("StateMemoryCompareInsensitive"), rbx.getString("TypeMemoryCompareInsensitive")),
        FAST_CLOCK_RANGE(10, ItemType.CLOCK, rbx.getString("TypeFastClockRange"), rbx.getString("TypeFastClockRange")),
        SIGNAL_HEAD_RED(11, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateRed"), Bundle.getMessage("SignalHeadStateRed")),
        SIGNAL_HEAD_YELLOW(12, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateYellow"), Bundle.getMessage("SignalHeadStateYellow")),
        SIGNAL_HEAD_GREEN(13, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateGreen"), Bundle.getMessage("SignalHeadStateGreen")),
        SIGNAL_HEAD_DARK(14, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateDark"), Bundle.getMessage("SignalHeadStateDark")),
        SIGNAL_HEAD_FLASHRED(15, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateFlashingRed"), Bundle.getMessage("SignalHeadStateFlashingRed")),
        SIGNAL_HEAD_FLASHYELLOW(16, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateFlashingYellow"), Bundle.getMessage("SignalHeadStateFlashingYellow")),
        SIGNAL_HEAD_FLASHGREEN(17, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateFlashingGreen"), Bundle.getMessage("SignalHeadStateFlashingGreen")),
        SIGNAL_HEAD_LIT(18, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateLit"), Bundle.getMessage("SignalHeadStateLit")),
        SIGNAL_HEAD_HELD(19, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateHeld"), Bundle.getMessage("SignalHeadStateHeld")),
        SIGNAL_HEAD_LUNAR(21, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateLunar"), Bundle.getMessage("SignalHeadStateLunar")),
        SIGNAL_HEAD_FLASHLUNAR(22, ItemType.SIGNALHEAD, Bundle.getMessage("SignalHeadStateFlashingLunar"), Bundle.getMessage("SignalHeadStateFlashingLunar")),
        ROUTE_FREE(25, ItemType.WARRANT, rbx.getString("StateRouteFree"), rbx.getString("TypeWarrantRouteFree")),
        ROUTE_OCCUPIED(26, ItemType.WARRANT, rbx.getString("stateRouteOccupied"), rbx.getString("TypeWarrantRouteOccupied")),
        ROUTE_ALLOCATED(27, ItemType.WARRANT, rbx.getString("StateRouteReserved"), rbx.getString("TypeWarrantRouteAllocated")),
        ROUTE_SET(28, ItemType.WARRANT, rbx.getString("StateRouteIsSet"), rbx.getString("TypeRouteIsSet")),
        TRAIN_RUNNING(29, ItemType.WARRANT, rbx.getString("StateTrainRunning"), rbx.getString("TypeTrainRunning")),
        SIGNAL_MAST_ASPECT_EQUALS(30, ItemType.SIGNALMAST, rbx.getString("TypeSignalMastAspectEquals"), rbx.getString("TypeSignalMastAspectEquals")),
        SIGNAL_MAST_LIT(31, ItemType.SIGNALMAST, Bundle.getMessage("SignalMastStateLit"), Bundle.getMessage("SignalMastStateLit")),
        SIGNAL_MAST_HELD(32, ItemType.SIGNALMAST, Bundle.getMessage("SignalMastStateHeld"), Bundle.getMessage("SignalMastStateHeld")),
        SIGNAL_HEAD_APPEARANCE_EQUALS(33, ItemType.SIGNALHEAD, rbx.getString("TypeSignalHeadAspectEquals"), rbx.getString("TypeSignalHeadAspectEquals")),
        BLOCK_STATUS_EQUALS(34, ItemType.OBLOCK, "", ""),
        ENTRYEXIT_ACTIVE(35, ItemType.ENTRYEXIT, rbx.getString("TypeEntryExitActive"), rbx.getString("TypeEntryExitActive")),
        ENTRYEXIT_INACTIVE(36, ItemType.ENTRYEXIT, rbx.getString("TypeEntryExitInactive"), rbx.getString("TypeEntryExitInactive")),
        OBLOCK_UNOCCUPIED(37, ItemType.OBLOCK, rbxWarrant.getString("unoccupied"), rbxWarrant.getString("unoccupied")),
        OBLOCK_OCCUPIED(38, ItemType.OBLOCK, rbxWarrant.getString("occupied"), rbxWarrant.getString("occupied")),
        OBLOCK_ALLOCATED(39, ItemType.OBLOCK, rbxWarrant.getString("allocated"), rbxWarrant.getString("allocated")),
        OBLOCK_RUNNING(40, ItemType.OBLOCK, rbxWarrant.getString("running"), rbxWarrant.getString("running")),
        OBLOCK_OUT_OF_SERVICE(41, ItemType.OBLOCK, rbxWarrant.getString("outOfService"), rbxWarrant.getString("outOfService")),
        OBLOCK_DARK(42, ItemType.OBLOCK, rbxWarrant.getString("dark"), rbxWarrant.getString("dark")),
        OBLOCK_POWER_ERROR(43, ItemType.OBLOCK, rbxWarrant.getString("powerError"), rbxWarrant.getString("powerError")),
        XXXXXXX(9999, ItemType.NONE, "XXXXXXX", "XXXXXXX");

        private final int _item;
        private final ItemType _itemType;
        private final String _string;
        private final String _testTypeString;
        private static final List<Type> sensorItemsList;
        private static final List<Type> turnoutItemsList;
        private static final List<Type> conditionalItemsList;
        private static final List<Type> lightItemsList;
        private static final List<Type> warrantItemsList;
        private static final List<Type> memoryItemsList;
        private static final List<Type> entryExitItemsList;
        private static final List<Type> signalHeadStateMachineItemsList;
        private static final List<Type> signalMastItemsList;
        private static final List<Type> oblockItemsList;
        private static final Set<Type> signalHeadAppearanceSet;

        private Type(int state, ItemType itemType, String string2, String testTypeString) {
            this._item = state;
            this._itemType = itemType;
            this._string = string2;
            this._testTypeString = testTypeString;
        }

        public ItemType getItemType() {
            return this._itemType;
        }

        public int getIntValue() {
            return this._item;
        }

        public static List<Type> getSensorItems() {
            return sensorItemsList;
        }

        public static List<Type> getTurnoutItems() {
            return turnoutItemsList;
        }

        public static List<Type> getConditionalItems() {
            return conditionalItemsList;
        }

        public static List<Type> getLightItems() {
            return lightItemsList;
        }

        public static List<Type> getWarrantItems() {
            return warrantItemsList;
        }

        public static List<Type> getMemoryItems() {
            return memoryItemsList;
        }

        public static List<Type> getEntryExitItems() {
            return entryExitItemsList;
        }

        public static List<Type> getSignalHeadStateMachineItems() {
            return signalHeadStateMachineItemsList;
        }

        public static boolean isSignalHeadApperance(Type type) {
            return signalHeadAppearanceSet.contains((Object)type);
        }

        public static List<Type> getSignalMastItems() {
            return signalMastItemsList;
        }

        public static List<Type> getOBlockItems() {
            return oblockItemsList;
        }

        public static int getIndexInList(List<Type> table, Type entry) {
            for (int i = 0; i < table.size(); ++i) {
                if (entry != table.get(i)) continue;
                return i;
            }
            return -1;
        }

        public static Type getOperatorFromIntValue(int typeInt) {
            for (Type type : Type.values()) {
                if (type.getIntValue() != typeInt) continue;
                return type;
            }
            throw new IllegalArgumentException("Type is unknown");
        }

        public String toString() {
            return this._string;
        }

        public String getTestTypeString() {
            return this._testTypeString;
        }

        static {
            Type[] typeArray1 = new Type[]{SENSOR_ACTIVE, SENSOR_INACTIVE};
            sensorItemsList = Collections.unmodifiableList(Arrays.asList(typeArray1));
            Type[] typeArray2 = new Type[]{TURNOUT_THROWN, TURNOUT_CLOSED};
            turnoutItemsList = Collections.unmodifiableList(Arrays.asList(typeArray2));
            Type[] typeArray3 = new Type[]{CONDITIONAL_TRUE, CONDITIONAL_FALSE};
            conditionalItemsList = Collections.unmodifiableList(Arrays.asList(typeArray3));
            Type[] typeArray4 = new Type[]{LIGHT_ON, LIGHT_OFF};
            lightItemsList = Collections.unmodifiableList(Arrays.asList(typeArray4));
            Type[] typeArray5 = new Type[]{ROUTE_FREE, ROUTE_SET, ROUTE_ALLOCATED, ROUTE_OCCUPIED, TRAIN_RUNNING};
            warrantItemsList = Collections.unmodifiableList(Arrays.asList(typeArray5));
            Type[] typeArray6 = new Type[]{MEMORY_EQUALS, MEMORY_EQUALS_INSENSITIVE, MEMORY_COMPARE, MEMORY_COMPARE_INSENSITIVE};
            memoryItemsList = Collections.unmodifiableList(Arrays.asList(typeArray6));
            Type[] typeArray7 = new Type[]{ENTRYEXIT_ACTIVE, ENTRYEXIT_INACTIVE};
            entryExitItemsList = Collections.unmodifiableList(Arrays.asList(typeArray7));
            Type[] typeArray8 = new Type[]{NONE, SIGNAL_HEAD_APPEARANCE_EQUALS, SIGNAL_HEAD_LIT, SIGNAL_HEAD_HELD};
            signalHeadStateMachineItemsList = Collections.unmodifiableList(Arrays.asList(typeArray8));
            Type[] typeArray9 = new Type[]{SIGNAL_HEAD_RED, SIGNAL_HEAD_YELLOW, SIGNAL_HEAD_GREEN, SIGNAL_HEAD_DARK, SIGNAL_HEAD_FLASHRED, SIGNAL_HEAD_FLASHYELLOW, SIGNAL_HEAD_FLASHGREEN, SIGNAL_HEAD_LUNAR, SIGNAL_HEAD_FLASHLUNAR};
            signalHeadAppearanceSet = Collections.unmodifiableSet(new HashSet<Type>(Arrays.asList(typeArray9)));
            Type[] typeArray10 = new Type[]{NONE, SIGNAL_MAST_ASPECT_EQUALS, SIGNAL_MAST_LIT, SIGNAL_MAST_HELD};
            signalMastItemsList = Collections.unmodifiableList(Arrays.asList(typeArray10));
            Type[] typeArray11 = new Type[]{OBLOCK_UNOCCUPIED, OBLOCK_OCCUPIED, OBLOCK_ALLOCATED, OBLOCK_RUNNING, OBLOCK_OUT_OF_SERVICE, OBLOCK_DARK, OBLOCK_POWER_ERROR};
            oblockItemsList = Collections.unmodifiableList(Arrays.asList(typeArray11));
        }
    }

    public static enum ItemType {
        NONE(0, IsStateVar.IS_STATE_VAR, "ItemTypeNone"),
        SENSOR(1, IsStateVar.IS_STATE_VAR, "ItemTypeSensor"),
        TURNOUT(2, IsStateVar.IS_STATE_VAR, "ItemTypeTurnout"),
        LIGHT(3, IsStateVar.IS_STATE_VAR, "ItemTypeLight"),
        SIGNALHEAD(4, IsStateVar.IS_STATE_VAR, "ItemTypeSignalHead"),
        SIGNALMAST(5, IsStateVar.IS_STATE_VAR, "ItemTypeSignalMast"),
        MEMORY(6, IsStateVar.IS_STATE_VAR, "ItemTypeMemory"),
        CONDITIONAL(7, IsStateVar.IS_STATE_VAR, "ItemTypeConditional"),
        LOGIX(7, IsStateVar.IS_STATE_VAR, "ItemTypeLogix"),
        WARRANT(8, IsStateVar.IS_STATE_VAR, "ItemTypeWarrant"),
        CLOCK(9, IsStateVar.IS_STATE_VAR, "ItemTypeClock"),
        OBLOCK(10, IsStateVar.IS_STATE_VAR, "ItemTypeOBlock"),
        ENTRYEXIT(11, IsStateVar.IS_STATE_VAR, "ItemTypeEntryExit"),
        AUDIO(12, IsStateVar.IS_NOT_STATE_VAR, "ItemTypeAudio"),
        SCRIPT(13, IsStateVar.IS_NOT_STATE_VAR, "ItemTypeScript"),
        OTHER(14, IsStateVar.IS_NOT_STATE_VAR, "ItemTypeOther");

        private final int _type;
        private final IsStateVar _isStateVar;
        private final String _bundleKey;
        private static final List<ItemType> stateVarList;

        private ItemType(int type, IsStateVar isStateVar, String bundleKey) {
            this._type = type;
            this._isStateVar = isStateVar;
            this._bundleKey = bundleKey;
        }

        public static List<ItemType> getStateVarList() {
            return stateVarList;
        }

        public int getIntValue() {
            return this._type;
        }

        public static ItemType getOperatorFromIntValue(int itemTypeInt) {
            for (ItemType itemType : ItemType.values()) {
                if (itemType.getIntValue() != itemTypeInt) continue;
                return itemType;
            }
            throw new IllegalArgumentException("ItemType is unknown");
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }

        private IsStateVar getIsStateVar() {
            return this._isStateVar;
        }

        static {
            stateVarList = new ArrayList<ItemType>();
            for (ItemType itemType : ItemType.values()) {
                if (itemType.getIsStateVar() != IsStateVar.IS_STATE_VAR) continue;
                stateVarList.add(itemType);
            }
        }

        private static enum IsStateVar {
            IS_STATE_VAR,
            IS_NOT_STATE_VAR;

        }
    }

    public static enum Operator {
        NONE,
        AND,
        OR;


        public int getIntValue() {
            switch (this) {
                case NONE: {
                    return 4;
                }
                case AND: {
                    return 1;
                }
                case OR: {
                    return 5;
                }
            }
            throw new IllegalArgumentException(String.format("operator %s is unknown", this.name()));
        }

        public static Operator getOperatorFromIntValue(int opern) {
            switch (opern) {
                case 1: {
                    return AND;
                }
                case 4: {
                    return NONE;
                }
                case 5: {
                    return OR;
                }
            }
            throw new IllegalArgumentException(String.format("operator %d is unknown", opern));
        }
    }

    public static enum AntecedentOperator {
        ALL_AND(1, Bundle.getMessage("LogicAND")),
        ALL_OR(2, Bundle.getMessage("LogicOR")),
        MIXED(3, Bundle.getMessage("LogicMixed"));

        private final int _value;
        private final String _string;

        private AntecedentOperator(int value, String string2) {
            this._value = value;
            this._string = string2;
        }

        public int getIntValue() {
            return this._value;
        }

        public static AntecedentOperator getOperatorFromIntValue(int value) {
            for (AntecedentOperator antecedentOperators : AntecedentOperator.values()) {
                if (antecedentOperators.getIntValue() != value) continue;
                return antecedentOperators;
            }
            throw new IllegalArgumentException("ItemType is unknown");
        }

        public String toString() {
            return this._string;
        }
    }

    public static enum State {
        UNKNOWN(1, "StateUnknown"),
        FALSE(2, "StateFalse"),
        TRUE(4, "StateTrue");

        private final int _state;
        private final String _bundleKey;

        private State(int state, String bundleKey) {
            this._state = state;
            this._bundleKey = bundleKey;
        }

        public int getIntValue() {
            return this._state;
        }

        public static State getOperatorFromIntValue(int stateInt) {
            for (State state : State.values()) {
                if (state.getIntValue() != stateInt) continue;
                return state;
            }
            throw new IllegalArgumentException("State is unknown");
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }
}

