/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPoint {
    public static final int UNKNOWN = 2;
    public static final int FORWARD = 4;
    public static final int REVERSE = 8;
    private Block mBlock = null;
    private Block mFromBlock = null;
    private int mDirection = 2;
    private boolean mFixed = false;
    private String mFromBlockDirection = "";
    private boolean needsInitialize = false;
    private String blockName = "";
    private String fromBlockName = "";
    private static final Logger log = LoggerFactory.getLogger(EntryPoint.class);

    public EntryPoint(Block b, Block pb, String fbDir) {
        this.mBlock = b;
        this.mFromBlock = pb;
        this.mFromBlockDirection = fbDir;
    }

    public EntryPoint(String bName, String fbName, String fbDir) {
        this.needsInitialize = true;
        this.blockName = bName;
        this.fromBlockName = fbName;
        this.mFromBlockDirection = fbDir;
    }

    private void initialize() {
        this.mBlock = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(this.blockName);
        if (this.mBlock == null) {
            log.error("Missing block - {} - when initializing entry point", (Object)this.blockName);
        }
        this.mFromBlock = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(this.fromBlockName);
        if (this.mFromBlock == null) {
            log.error("Missing block - {} - when initializing entry point", (Object)this.fromBlockName);
        }
        this.needsInitialize = false;
    }

    public Block getBlock() {
        if (this.needsInitialize) {
            this.initialize();
        }
        return this.mBlock;
    }

    public String getFromBlockName() {
        if (this.needsInitialize) {
            this.initialize();
        }
        Object s = this.mFromBlock.getDisplayName();
        if (this.mFromBlockDirection != null && !this.mFromBlockDirection.isEmpty()) {
            s = (String)s + " ( " + this.mFromBlockDirection + " )";
        }
        return s;
    }

    public Block getFromBlock() {
        if (this.needsInitialize) {
            this.initialize();
        }
        return this.mFromBlock;
    }

    public void setTypeForward() {
        this.mDirection = 4;
    }

    public void setTypeReverse() {
        this.mDirection = 8;
    }

    public void setTypeUnknown() {
        this.mDirection = 2;
    }

    public boolean isForwardType() {
        return this.mDirection == 4;
    }

    public boolean isReverseType() {
        return this.mDirection == 8;
    }

    public boolean isUnknownType() {
        return this.mDirection == 2;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int dir) {
        this.mDirection = dir;
    }

    public void setFixed(boolean f) {
        this.mFixed = f;
    }

    public boolean isFixed() {
        return this.mFixed;
    }

    public String getFromBlockDirection() {
        return this.mFromBlockDirection;
    }
}

