/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import java.beans.PropertyVetoException;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.SystemConnectionMemo;
import jmri.beans.SilenceablePropertyChangeProvider;
import jmri.beans.VetoableChangeProvider;

public interface Manager<E extends NamedBean>
extends SilenceablePropertyChangeProvider,
VetoableChangeProvider {
    public static final String PROPERTY_CAN_DELETE = "CanDelete";
    public static final String PROPERTY_DO_DELETE = "DoDelete";
    public static final String PROPERTY_DO_NOT_DELETE = "DoNotDelete";
    public static final String PROPERTY_BEANS = "beans";
    public static final String PROPERTY_LENGTH = "length";
    public static final String PROPERTY_DISPLAY_LIST_NAME = "DisplayListName";
    public static final int SENSORS = 10;
    public static final int TURNOUTS = 20;
    public static final int LIGHTS = 30;
    public static final int REPORTERS = 40;
    public static final int MEMORIES = 50;
    public static final int SENSORGROUPS = 60;
    public static final int SIGNALHEADS = 70;
    public static final int SIGNALMASTS = 80;
    public static final int SIGNALGROUPS = 90;
    public static final int BLOCKS = 100;
    public static final int OBLOCKS = 110;
    public static final int LAYOUTBLOCKS = 120;
    public static final int SECTIONS = 130;
    public static final int TRANSITS = 140;
    public static final int BLOCKBOSS = 150;
    public static final int ROUTES = 160;
    public static final int WARRANTS = 170;
    public static final int SIGNALMASTLOGICS = 180;
    public static final int IDTAGS = 190;
    public static final int ANALOGIOS = 200;
    public static final int METERS = 210;
    public static final int STRINGIOS = 220;
    public static final int LOGIXS = 230;
    public static final int CONDITIONALS = 240;
    public static final int AUDIO = 250;
    public static final int TIMEBASE = 260;
    public static final int LOGIXNGS = 270;
    public static final int LOGIXNG_GLOBAL_VARIABLES = 280;
    public static final int LOGIXNG_CONDITIONALNGS = 290;
    public static final int LOGIXNG_MODULES = 300;
    public static final int LOGIXNG_TABLES = 310;
    public static final int LOGIXNG_DIGITAL_EXPRESSIONS = 320;
    public static final int LOGIXNG_DIGITAL_ACTIONS = 330;
    public static final int LOGIXNG_DIGITAL_BOOLEAN_ACTIONS = 340;
    public static final int LOGIXNG_ANALOG_EXPRESSIONS = 350;
    public static final int LOGIXNG_ANALOG_ACTIONS = 360;
    public static final int LOGIXNG_STRING_EXPRESSIONS = 370;
    public static final int LOGIXNG_STRING_ACTIONS = 380;
    public static final int PANELFILES = 390;
    public static final int ENTRYEXIT = 400;
    public static final int METERFRAMES = 410;
    public static final int CTCDATA = 420;

    @CheckReturnValue
    @Nonnull
    public SystemConnectionMemo getMemo();

    @CheckReturnValue
    @Nonnull
    public String getSystemPrefix();

    @CheckReturnValue
    public char typeLetter();

    public Class<E> getNamedBeanClass();

    default public String getSystemNamePrefix() {
        return this.getSystemPrefix() + this.typeLetter();
    }

    default public String getSubSystemNamePrefix() {
        return this.getSystemNamePrefix();
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name) throws NamedBean.BadSystemNameException {
        return this.makeSystemName(name, true);
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name, boolean logErrors) throws NamedBean.BadSystemNameException {
        return this.makeSystemName(name, logErrors, Locale.getDefault());
    }

    @Nonnull
    default public String makeSystemName(@Nonnull String name, boolean logErrors, Locale locale) throws NamedBean.BadSystemNameException {
        String prefix = this.getSystemNamePrefix();
        if (name.trim().isEmpty()) {
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemNameInvalidPrefix", prefix);
        }
        return this.validateSystemNameFormat((String)(name.startsWith(prefix) ? name : prefix + name), locale);
    }

    @Nonnull
    default public String validateSystemNameFormat(@Nonnull String name) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormat(name, Locale.getDefault());
    }

    @Nonnull
    default public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNamePrefix(name, locale);
    }

    @Nonnull
    default public String validateSystemNamePrefix(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String prefix = this.getSystemNamePrefix();
        if (name.equals(prefix)) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameMatchesPrefix", name);
        }
        if (!name.startsWith(prefix)) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameInvalidPrefix", prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateTrimmedSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String prefix;
        String suffix = (name = this.validateSystemNamePrefix(name, locale)).substring((prefix = this.getSystemNamePrefix()).length());
        if (!suffix.equals(suffix.trim())) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameTrailingWhitespace", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateTrimmedMin1NumberSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        if (!(name = this.validateTrimmedSystemNameFormat(name, locale)).matches(".*\\d+.*")) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameMin1Number", name);
        }
        return name;
    }

    default public String validateSystemNameFormatOnlyNumeric(@Nonnull String name, @Nonnull Locale locale) {
        name = this.validateTrimmedSystemNameFormat(name, locale);
        try {
            Integer.parseInt(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (NumberFormatException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotInteger", name, this.getSystemNamePrefix());
        }
        return name;
    }

    @Nonnull
    default public String validateBadCharsInSystemNameFormat(@Nonnull String name, @Nonnull Locale locale, @Nonnull String[] invalidChars) throws NamedBean.BadSystemNameException {
        name = this.validateSystemNamePrefix(name, locale);
        for (String s : invalidChars) {
            if (!name.contains(s)) continue;
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCharacter", name, s);
        }
        return name;
    }

    @Nonnull
    default public String validateUppercaseTrimmedSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        String upper;
        String prefix;
        String suffix = (name = this.validateTrimmedSystemNameFormat(name, locale)).substring((prefix = this.getSystemNamePrefix()).length());
        if (!suffix.equals(upper = suffix.toUpperCase())) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotUpperCase", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateIntegerSystemNameFormat(@Nonnull String name, int min, int max, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        name = this.validateTrimmedSystemNameFormat(name, locale);
        String prefix = this.getSystemNamePrefix();
        String suffix = name.substring(prefix.length());
        try {
            int number = Integer.parseInt(suffix);
            if (number < min) {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameIntegerLessThan", name, min);
            }
            if (number > max) {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameIntegerGreaterThan", name, max);
            }
        }
        catch (NumberFormatException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameNotInteger", name, prefix);
        }
        return name;
    }

    @Nonnull
    default public String validateNmraAccessorySystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateIntegerSystemNameFormat(name, 1, 2044, locale);
    }

    @CheckReturnValue
    @OverrideMustInvoke
    default public NameValidity validSystemNameFormat(@Nonnull String systemName) {
        String prefix = this.getSystemNamePrefix();
        if (prefix.equals(systemName)) {
            return NameValidity.VALID_AS_PREFIX_ONLY;
        }
        return systemName.startsWith(prefix) ? NameValidity.VALID : NameValidity.INVALID;
    }

    default public boolean isValidSystemNameFormat(@Nonnull String systemName) {
        return this.validSystemNameFormat(systemName) == NameValidity.VALID;
    }

    public void dispose();

    @CheckReturnValue
    public int getObjectCount();

    @CheckReturnValue
    @Nonnull
    public SortedSet<E> getNamedBeanSet();

    @CheckReturnValue
    @CheckForNull
    public E getBySystemName(@Nonnull String var1);

    @CheckReturnValue
    @CheckForNull
    public E getByUserName(@Nonnull String var1);

    @CheckReturnValue
    @CheckForNull
    public E getNamedBean(@Nonnull String var1);

    @Nonnull
    default public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        return new LinkedList();
    }

    public void deleteBean(@Nonnull E var1, @Nonnull String var2) throws PropertyVetoException;

    public void register(@Nonnull E var1);

    public void deregister(@Nonnull E var1);

    @CheckReturnValue
    public int getXMLOrder();

    @CheckReturnValue
    @Nonnull
    default public String getBeanTypeHandled() {
        return this.getBeanTypeHandled(false);
    }

    @CheckReturnValue
    @Nonnull
    public String getBeanTypeHandled(boolean var1);

    @CheckReturnValue
    public static int getSystemPrefixLength(@Nonnull String inputName) {
        int i;
        if (inputName.isEmpty()) {
            throw new NamedBean.BadSystemNameException();
        }
        if (!Character.isLetter(inputName.charAt(0))) {
            throw new NamedBean.BadSystemNameException();
        }
        for (i = 1; i < inputName.length() && Character.isDigit(inputName.charAt(i)); ++i) {
        }
        return i;
    }

    @CheckReturnValue
    @Nonnull
    public static String getSystemPrefix(@Nonnull String inputName) {
        return inputName.substring(0, Manager.getSystemPrefixLength(inputName));
    }

    @CheckReturnValue
    @Nonnull
    public static String getTypeLetter(@Nonnull String inputName) {
        return inputName.substring(Manager.getSystemPrefixLength(inputName), Manager.getSystemPrefixLength(inputName) + 1);
    }

    @CheckReturnValue
    @Nonnull
    public static String getSystemSuffix(@Nonnull String inputName) {
        return inputName.substring(Manager.getSystemPrefixLength(inputName) + 1);
    }

    default public String getEntryToolTip() {
        return null;
    }

    public void addDataListener(ManagerDataListener<E> var1);

    public void removeDataListener(ManagerDataListener<E> var1);

    default public void setDataListenerMute(boolean muted) {
    }

    @Immutable
    public static final class ManagerDataEvent<E extends NamedBean>
    extends EventObject {
        public static final int CONTENTS_CHANGED = 0;
        public static final int INTERVAL_ADDED = 1;
        public static final int INTERVAL_REMOVED = 2;
        private final int type;
        private final int index0;
        private final int index1;
        private final transient E changedBean;
        private final transient Manager<E> sourceManager;

        public ManagerDataEvent(@Nonnull Manager<E> source, int type, int index0, int index1, E changedBean) {
            super(source);
            this.sourceManager = source;
            this.type = type;
            this.index0 = Math.min(index0, index1);
            this.index1 = Math.max(index0, index1);
            this.changedBean = changedBean;
        }

        @Override
        public Manager<E> getSource() {
            return this.sourceManager;
        }

        public int getIndex0() {
            return this.index0;
        }

        public int getIndex1() {
            return this.index1;
        }

        public E getChangedBean() {
            return this.changedBean;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[type=" + this.type + ", index0=" + this.index0 + ", index1=" + this.index1 + "]";
        }
    }

    public static interface ManagerDataListener<E extends NamedBean> {
        public void contentsChanged(ManagerDataEvent<E> var1);

        public void intervalAdded(ManagerDataEvent<E> var1);

        public void intervalRemoved(ManagerDataEvent<E> var1);
    }

    public static enum NameValidity {
        VALID,
        INVALID,
        VALID_AS_PREFIX_ONLY;

    }
}

