/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.VariableControlSpanBean;
import jmri.util.StringUtil;

public interface NameIncrementingManager {
    @CheckReturnValue
    default public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Nonnull
    @CheckReturnValue
    default public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        int increment;
        if (!this.allowMultipleAdditions(currentBean.getSystemName())) {
            throw new UnsupportedOperationException("Not supported");
        }
        String currentName = currentBean.getSystemName();
        String nextName = StringUtil.incrementLastNumberInString(currentName, increment = currentBean instanceof VariableControlSpanBean ? ((VariableControlSpanBean)currentBean).getNumberControlBits() : 1);
        if (nextName == null) {
            throw new JmriException("No existing number found when incrementing " + currentName);
        }
        return nextName;
    }
}

