/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.Bundle;
import jmri.InvokeOnLayoutThread;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBeanUsageReport;
import jmri.beans.PropertyChangeProvider;
import jmri.util.AlphanumComparator;

public interface NamedBean
extends Comparable<NamedBean>,
PropertyChangeProvider {
    public static final int UNKNOWN = 1;
    public static final int INCONSISTENT = 8;
    public static final String DISPLAY_NAME_FORMAT = "%s (%s)";
    public static final String QUOTED_NAME_FORMAT = "\"%s\" (%s)";
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_KNOWN_STATE = "KnownState";
    public static final String PROPERTY_ENABLED = "Enabled";
    public static final String PROPERTY_COMMENT = "Comment";
    public static final String PROPERTY_USERNAME = "UserName";

    @CheckReturnValue
    @CheckForNull
    public String getUserName();

    public void setUserName(@CheckForNull String var1) throws BadUserNameException;

    @CheckReturnValue
    @Nonnull
    public String getSystemName();

    @Nonnull
    public String toString();

    @CheckReturnValue
    @Nonnull
    default public String getDisplayName() {
        return this.getDisplayName(DisplayOptions.DISPLAYNAME);
    }

    @CheckReturnValue
    @Nonnull
    default public String getDisplayName(DisplayOptions options) {
        String userName = this.getUserName();
        String systemName = this.getSystemName();
        if (userName != null && userName.isEmpty()) {
            userName = null;
        }
        switch (options) {
            case USERNAME_SYSTEMNAME: {
                return userName != null ? String.format(DISPLAY_NAME_FORMAT, userName, systemName) : systemName;
            }
            case QUOTED_USERNAME_SYSTEMNAME: {
                return userName != null ? String.format(QUOTED_NAME_FORMAT, userName, systemName) : this.getDisplayName(DisplayOptions.QUOTED_SYSTEMNAME);
            }
            case SYSTEMNAME: {
                return systemName;
            }
            case QUOTED_SYSTEMNAME: {
                return String.format("\"%s\"", systemName);
            }
            case QUOTED_USERNAME: 
            case QUOTED_DISPLAYNAME: {
                return String.format("\"%s\"", userName != null ? userName : systemName);
            }
        }
        return userName != null ? userName : systemName;
    }

    @CheckReturnValue
    @Nonnull
    default public String getRecommendedToolTip() {
        String retval = this.getComment();
        if (retval == null) {
            return "";
        }
        return retval;
    }

    public void addPropertyChangeListener(@Nonnull PropertyChangeListener var1, String var2, String var3);

    public void addPropertyChangeListener(@Nonnull String var1, @Nonnull PropertyChangeListener var2, String var3, String var4);

    public void updateListenerRef(@Nonnull PropertyChangeListener var1, String var2);

    public void vetoableChange(@Nonnull PropertyChangeEvent var1) throws PropertyVetoException;

    @CheckReturnValue
    public String getListenerRef(@Nonnull PropertyChangeListener var1);

    @CheckReturnValue
    public ArrayList<String> getListenerRefs();

    @CheckReturnValue
    public int getNumPropertyChangeListeners();

    @CheckReturnValue
    @Nonnull
    public PropertyChangeListener[] getPropertyChangeListenersByReference(@Nonnull String var1);

    public void dispose();

    @InvokeOnLayoutThread
    public void setState(int var1) throws JmriException;

    @CheckReturnValue
    public int getState();

    @CheckReturnValue
    public String describeState(int var1);

    @CheckReturnValue
    @CheckForNull
    public String getComment();

    public void setComment(@CheckForNull String var1);

    default public List<NamedBeanUsageReport> getUsageReport(@CheckForNull NamedBean bean) {
        return new ArrayList<NamedBeanUsageReport>();
    }

    public void setProperty(@Nonnull String var1, Object var2);

    @CheckReturnValue
    @CheckForNull
    public Object getProperty(@Nonnull String var1);

    public void removeProperty(@Nonnull String var1);

    @CheckReturnValue
    @Nonnull
    public Set<String> getPropertyKeys();

    @CheckReturnValue
    @Nonnull
    public String getBeanType();

    @CheckReturnValue
    @CheckForNull
    public static String normalizeUserName(@CheckForNull String inputName) throws BadUserNameException {
        String result = inputName;
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    @Override
    @CheckReturnValue
    default public int compareTo(NamedBean n2) {
        char c2;
        Objects.requireNonNull(n2);
        AlphanumComparator ac = new AlphanumComparator();
        String o1 = this.getSystemName();
        String o2 = n2.getSystemName();
        int p1len = Manager.getSystemPrefixLength(o1);
        int p2len = Manager.getSystemPrefixLength(o2);
        int comp = ac.compare(o1.substring(0, p1len), o2.substring(0, p2len));
        if (comp != 0) {
            return comp;
        }
        char c1 = o1.charAt(p1len);
        if (c1 != (c2 = o2.charAt(p2len))) {
            return c1 > c2 ? 1 : -1;
        }
        return this.compareSystemNameSuffix(o1.substring(p1len + 1), o2.substring(p2len + 1), n2);
    }

    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String var1, @Nonnull String var2, @Nonnull NamedBean var3);

    public static enum DisplayOptions {
        DISPLAYNAME,
        QUOTED_DISPLAYNAME,
        USERNAME,
        QUOTED_USERNAME,
        SYSTEMNAME,
        QUOTED_SYSTEMNAME,
        USERNAME_SYSTEMNAME,
        QUOTED_USERNAME_SYSTEMNAME;

    }

    public static class DuplicateSystemNameException
    extends IllegalArgumentException {
        private final String localizedMessage;

        public DuplicateSystemNameException() {
            this.localizedMessage = super.getMessage();
        }

        public DuplicateSystemNameException(String message) {
            super(message);
            this.localizedMessage = super.getMessage();
        }

        public DuplicateSystemNameException(Locale locale, String message, Object ... subs) {
            this(Bundle.getMessage(locale, message, subs), Bundle.getMessage(locale, message, subs));
        }

        public DuplicateSystemNameException(String logging, String display) {
            super(logging);
            this.localizedMessage = display;
        }

        @Override
        public String getLocalizedMessage() {
            return this.localizedMessage;
        }
    }

    public static class BadSystemNameException
    extends BadNameException {
        public BadSystemNameException() {
        }

        public BadSystemNameException(Locale locale, String message, Object ... subs) {
            this(Bundle.getMessage(Locale.ENGLISH, message, subs), Bundle.getMessage(locale, message, subs));
        }

        public BadSystemNameException(String logging, String display) {
            super(logging, display);
        }
    }

    public static class BadUserNameException
    extends BadNameException {
        public BadUserNameException() {
        }

        public BadUserNameException(Locale locale, String message, Object ... subs) {
            super(Bundle.getMessage(Locale.ENGLISH, message, subs), Bundle.getMessage(locale, message, subs));
        }

        public BadUserNameException(String logging, String display) {
            super(logging, display);
        }
    }

    public static class BadNameException
    extends IllegalArgumentException {
        private final String localizedMessage;

        protected BadNameException() {
            this.localizedMessage = super.getMessage();
        }

        protected BadNameException(String logging, String display) {
            super(logging);
            this.localizedMessage = display;
        }

        @Override
        public String getLocalizedMessage() {
            return this.localizedMessage;
        }
    }
}

