/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Bundle;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null returned is documented in each method to mean no valid result")
public class NmraPacket {
    public static final int accIdLowLimit = 1;
    public static final int accIdHighLimit = 2044;
    public static final int accIdAltHighLimit = 2048;
    private static final Logger log = LoggerFactory.getLogger(NmraPacket.class);

    @CheckForNull
    public static byte[] idlePacket() {
        byte[] retVal = new byte[]{-1, 0, -1};
        return retVal;
    }

    @CheckForNull
    public static byte[] oneBytePacket(int address, boolean longAddr, byte byte1) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), byte1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])} : new byte[]{(byte)(address & 0xFF), byte1, (byte)(retVal[0] ^ retVal[1])};
        return retVal;
    }

    @CheckForNull
    public static byte[] twoBytePacket(int address, boolean longAddr, byte byte1, byte byte2) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), byte1, byte2, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])} : new byte[]{(byte)(address & 0xFF), byte1, byte2, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])};
        return retVal;
    }

    @CheckForNull
    public static byte[] threeBytePacket(int address, boolean longAddr, byte byte1, byte byte2, byte byte3) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), byte1, byte2, byte3, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])} : new byte[]{(byte)(address & 0xFF), byte1, byte2, byte3, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])};
        return retVal;
    }

    @CheckForNull
    public static byte[] fourBytePacket(int address, boolean longAddr, byte byte1, byte byte2, byte byte3, byte byte4) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), byte1, byte2, byte3, byte4, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4] ^ retVal[5])} : new byte[]{(byte)(address & 0xFF), byte1, byte2, byte3, byte4, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])};
        return retVal;
    }

    public static byte[] accDecoderPkt(int addr, int active, int outputChannel) {
        byte[] retVal;
        if (addr < 1 || addr > 511) {
            log.error("invalid address {}", (Object)addr);
            throw new IllegalArgumentException();
        }
        if (active < 0 || active > 1) {
            log.error("invalid active (C) bit {}", (Object)addr);
            return null;
        }
        if (outputChannel < 0 || outputChannel > 7) {
            log.error("invalid output channel {}", (Object)addr);
            return null;
        }
        int lowAddr = addr & 0x3F;
        int highAddr = ~addr >> 6 & 7;
        retVal = new byte[]{(byte)(0x80 | lowAddr), (byte)(0x80 | highAddr << 4 | active << 3 | outputChannel & 7), (byte)(retVal[0] ^ retVal[1])};
        return retVal;
    }

    public static byte[] accDecoderPktOpsMode(int addr, int active, int outputChannel, int cvNum, int data) {
        byte[] retVal;
        if (addr < 1 || addr > 511) {
            log.error("invalid address {}", (Object)addr);
            throw new IllegalArgumentException();
        }
        if (active < 0 || active > 1) {
            log.error("invalid active (C) bit {}", (Object)addr);
            return null;
        }
        if (outputChannel < 0 || outputChannel > 7) {
            log.error("invalid output channel {}", (Object)addr);
            return null;
        }
        if (cvNum < 1 || cvNum > 1024) {
            log.error("invalid CV number {}", (Object)cvNum);
            return null;
        }
        if (data < 0 || data > 255) {
            log.error("invalid data {}", (Object)data);
            return null;
        }
        int lowAddr = addr & 0x3F;
        int highAddr = ~addr >> 6 & 7;
        int lowCVnum = cvNum - 1 & 0xFF;
        int highCVnum = cvNum - 1 >> 8 & 3;
        retVal = new byte[]{(byte)(0x80 | lowAddr), (byte)(0x80 | highAddr << 4 | active << 3 | outputChannel & 7), (byte)(0xEC | highCVnum), (byte)lowCVnum, (byte)(0xFF & data), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])};
        return retVal;
    }

    public static byte[] accDecPktOpsModeLegacy(int decAddr, int cvNum, int data) {
        byte[] retVal;
        if (decAddr < 1 || decAddr > 511) {
            log.error("invalid address {}", (Object)decAddr);
            return null;
        }
        if (cvNum < 1 || cvNum > 1024) {
            log.error("invalid CV number {}", (Object)cvNum);
            return null;
        }
        if (data < 0 || data > 255) {
            log.error("invalid data {}", (Object)data);
            return null;
        }
        int lowAddr = decAddr & 0x3F;
        int highAddr = ~decAddr >> 6 & 7;
        int lowCVnum = cvNum - 1 & 0xFF;
        int highCVnum = cvNum - 1 >> 8 & 3;
        retVal = new byte[]{(byte)(0x80 | lowAddr), (byte)(0xC | highAddr << 4 | highCVnum), (byte)lowCVnum, (byte)(0xFF & data), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])};
        return retVal;
    }

    @Nonnull
    public static byte[] accSignalDecoderPkt(int outputAddr, int aspect) {
        if (outputAddr < 1 || outputAddr > 2044) {
            log.error("invalid signal decoder address {}", (Object)outputAddr);
        }
        int lowAddr = --outputAddr & 3;
        int boardAddr = (outputAddr >> 2) + 1;
        return NmraPacket.accSignalDecoderPktCommon(lowAddr, boardAddr, aspect);
    }

    public static byte[] accSignalDecoderPktOpsMode(int addr, int cvNum, int data) {
        byte[] retVal;
        if (addr < 1 || addr > 2044) {
            log.error("invalid address {}", (Object)addr);
            throw new IllegalArgumentException();
        }
        if (cvNum < 1 || cvNum > 1024) {
            log.error("invalid CV number {}", (Object)cvNum);
            return null;
        }
        if (data < 0 || data > 255) {
            log.error("invalid data {}", (Object)data);
            return null;
        }
        int outputAddr = addr - 1;
        int lowAddr = outputAddr & 3;
        int boardAddr = (outputAddr >> 2) + 1;
        int midAddr = boardAddr & 0x3F;
        int highAddr = ~(boardAddr >> 6) & 7;
        int lowCVnum = cvNum - 1 & 0xFF;
        int highCVnum = cvNum - 1 >> 8 & 3;
        retVal = new byte[]{(byte)(0x80 | midAddr), (byte)(1 | highAddr << 4 | lowAddr << 1), (byte)(0xEC | highCVnum), (byte)lowCVnum, (byte)(0xFF & data), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])};
        return retVal;
    }

    public static boolean isAccSignalDecoderPkt(byte[] packet) {
        if (packet == null || packet.length != 3 && packet.length != 4) {
            return false;
        }
        if ((packet[0] & 0xC0) != 128) {
            return false;
        }
        if ((packet[1] & 1) != 1) {
            return false;
        }
        return (packet[2] & 0xE0) == 0;
    }

    public static boolean isAccDecoderPktOpsMode(byte[] packet) {
        if (packet.length != 5 && packet.length != 6) {
            return false;
        }
        if ((packet[0] & 0xC0) != 128) {
            return false;
        }
        if ((packet[1] & 0x88) != 136 && (packet[1] & 0x8F) != 128) {
            return false;
        }
        return (packet[2] & 0xFC) == 236;
    }

    public static boolean isAccDecoderPktOpsModeLegacy(byte[] packet) {
        if (packet.length != 4 && packet.length != 5) {
            return false;
        }
        if ((packet[0] & 0xC0) != 128) {
            return false;
        }
        return (packet[1] & 0x8C) == 12;
    }

    public static int getAccDecPktOpsModeLegacyAddress(byte[] packet) {
        int midAddr = packet[0] & 0x3F;
        int hiAddr = (~packet[1] & 0x70) >> 4;
        return hiAddr << 6 | midAddr;
    }

    public static int getAccDecoderPktOpsModeLegacyAddress(byte[] packet) {
        int midAddr = packet[0] & 0x3F;
        int hiAddr = (~packet[1] & 0x70) >> 4;
        int boardAddr = (hiAddr << 6 | midAddr) - 1;
        return (boardAddr << 2) + 1;
    }

    public static int getAccDecoderPktOpsModeAddress(byte[] packet) {
        int midAddr = packet[0] & 0x3F;
        int lowAddr = (packet[1] & 6) >> 1;
        int hiAddr = (~packet[1] & 0x70) >> 4;
        int boardAddr = (hiAddr << 6 | midAddr) - 1;
        return (boardAddr << 2 | lowAddr) + 1;
    }

    public static int getAccDecPktOpsModeAddress(byte[] packet) {
        int lowAddr = packet[0] & 0x3F;
        int hiAddr = (~packet[1] & 0x70) >> 4;
        return hiAddr << 6 | lowAddr;
    }

    public static int getAccSignalDecoderPktAddress(byte[] packet) {
        int midAddr = packet[0] & 0x3F;
        int lowAddr = (packet[1] & 0xE) >> 1;
        int hiAddr = (~packet[1] & 0x70) >> 4;
        int boardAddr = (hiAddr << 6 | midAddr) - 1;
        return (boardAddr << 2 | lowAddr) + 1;
    }

    @Nonnull
    public static byte[] altAccSignalDecoderPkt(int outputAddr, int aspect) {
        if (outputAddr < 1 || outputAddr > 2048) {
            log.error("invalid signal decoder address {}", (Object)outputAddr);
        }
        int lowAddr = --outputAddr & 3;
        int boardAddr = outputAddr >> 2;
        return NmraPacket.accSignalDecoderPktCommon(lowAddr, boardAddr, aspect);
    }

    public static byte[] altAccSignalDecoderPktOpsMode(int addr, int cvNum, int data) {
        byte[] retVal;
        if (addr < 1 || addr > 2044) {
            log.error("invalid address {}", (Object)addr);
            throw new IllegalArgumentException();
        }
        if (cvNum < 1 || cvNum > 1024) {
            log.error("invalid CV number {}", (Object)cvNum);
            return null;
        }
        if (data < 0 || data > 255) {
            log.error("invalid data {}", (Object)data);
            return null;
        }
        int outputAddr = addr - 1;
        int lowAddr = outputAddr & 3;
        int boardAddr = outputAddr >> 2;
        int midAddr = boardAddr & 0x3F;
        int highAddr = ~(boardAddr >> 6) & 7;
        int lowCVnum = cvNum - 1 & 0xFF;
        int highCVnum = cvNum - 1 >> 8 & 3;
        retVal = new byte[]{(byte)(0x80 | midAddr), (byte)(1 | highAddr << 4 | lowAddr << 1), (byte)(0xEC | highCVnum), (byte)lowCVnum, (byte)(0xFF & data), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])};
        return retVal;
    }

    @Nonnull
    protected static byte[] accSignalDecoderPktCommon(int lowAddr, int boardAddr, int aspect) {
        byte[] retVal;
        if (aspect < 0 || aspect > 31) {
            log.error("invalid signal decoder aspect {}", (Object)aspect);
        }
        int midAddr = boardAddr & 0x3F;
        int highAddr = ~boardAddr >> 6 & 7;
        retVal = new byte[]{(byte)(0x80 | midAddr), (byte)(1 | highAddr << 4 | lowAddr << 1), (byte)(0x1F & aspect), (byte)(retVal[0] ^ retVal[1] ^ retVal[2])};
        return retVal;
    }

    public static int getAccDecoderPktAddress(byte[] packet) {
        int boardAddress = (~packet[1] & 0x70) << 2 | packet[0] & 0x3F;
        int outputAddress = packet[1] & 7;
        int outputIndex = outputAddress >> 1;
        return (boardAddress - 1 << 2 | outputIndex) + 1;
    }

    public static byte[] accDecoderPkt(int number, boolean closed) {
        int dBits = (number - 1 & 3) << 1;
        dBits = closed ? dBits | 1 : dBits;
        int aBits = number - 1 >> 2;
        int cBit = 1;
        return NmraPacket.accDecoderPkt(++aBits, cBit, dBits);
    }

    public static byte[] accDecoderPktOpsMode(int accAddr, int cvNum, int data) {
        int dBits = (accAddr - 1 & 3) << 1 | 1;
        int aBits = accAddr - 1 >> 2;
        int cBit = 1;
        return NmraPacket.accDecoderPktOpsMode(++aBits, cBit, dBits, cvNum, data);
    }

    public static byte[] accDecPktOpsMode(int decAddr, int cvNum, int data) {
        int dBits = 0;
        int aBits = decAddr;
        int cBit = 0;
        return NmraPacket.accDecoderPktOpsMode(aBits, cBit, dBits, cvNum, data);
    }

    public static byte[] accDecoderPktOpsModeLegacy(int accAddr, int cvNum, int data) {
        int aBits = accAddr - 1 >> 2;
        return NmraPacket.accDecPktOpsModeLegacy(++aBits, cvNum, data);
    }

    public static byte[] opsCvWriteByte(int address, boolean longAddr, int cvNum, int data) {
        log.debug("opswrite {} {} {}", new Object[]{address, cvNum, data});
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        if (data < 0 || data > 255) {
            log.error("invalid data {}", (Object)data);
            return null;
        }
        if (cvNum < 1 || cvNum > 1024) {
            log.error("invalid CV number {}", (Object)cvNum);
            return null;
        }
        int arg1 = 236 + (cvNum - 1 >> 8 & 3);
        int arg2 = cvNum - 1 & 0xFF;
        int arg3 = data & 0xFF;
        return NmraPacket.threeBytePacket(address, longAddr, (byte)arg1, (byte)arg2, (byte)arg3);
    }

    public static byte[] speedStep128Packet(int address, boolean longAddr, int speed, boolean fwd) {
        byte[] retVal;
        log.debug("128 step packet {} {}", (Object)address, (Object)speed);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        if (speed < 0 || speed > 127) {
            log.error("invalid speed {}", (Object)speed);
            return null;
        }
        int arg1 = 63;
        int arg2 = speed & 0x7F | (fwd ? 128 : 0);
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)arg2, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)arg2, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])};
        return retVal;
    }

    public static byte[] speedStep28Packet(int address, boolean longAddr, int speed, boolean fwd) {
        log.debug("28 step packet {} {}", (Object)address, (Object)speed);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        if (speed < 0 || speed > 28) {
            log.error("invalid speed {}", (Object)speed);
            return null;
        }
        int speedC = (speed & 0x1F) >> 1;
        if (speed > 0) {
            ++speedC;
        }
        int c = (speed & 1) << 4;
        int arg1 = (fwd ? 96 : 64) | (speedC += c);
        return NmraPacket.oneBytePacket(address, longAddr, (byte)arg1);
    }

    @CheckForNull
    public static byte[] speedStep28Packet(boolean full, int address, boolean longAddr, int speed, boolean fwd) {
        log.debug("28 step packet {} {}", (Object)address, (Object)speed);
        if (!full) {
            log.error("invalid method invocation");
            return null;
        }
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        if (speed < 0 || speed > 31) {
            log.error("invalid speed {}", (Object)speed);
            return null;
        }
        int speedC = (speed & 0x1F) >> 1;
        int c = (speed & 1) << 4;
        int arg1 = (fwd ? 96 : 64) | (speedC += c);
        return NmraPacket.oneBytePacket(address, longAddr, (byte)arg1);
    }

    public static byte[] speedStep14Packet(int address, boolean longAddr, int speed, boolean fwd, boolean F0) {
        byte[] retVal;
        log.debug("14 step packet {} {} {}", new Object[]{address, speed, F0});
        if (speed < 0 || speed > 15) {
            log.error("invalid speed {}", (Object)speed);
            return null;
        }
        int speedC = speed & 0xF;
        if (F0) {
            speedC += 16;
        }
        int arg1 = (fwd ? 96 : 64) | speedC;
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])};
        return retVal;
    }

    public static byte[] function0Through4Packet(int address, boolean longAddr, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        byte[] retVal;
        log.debug("f0 through f4 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 0x80 | (f0 ? 16 : 0) | (f1 ? 1 : 0) | (f2 ? 2 : 0) | (f3 ? 4 : 0) | (f4 ? 8 : 0);
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1])};
        return retVal;
    }

    public static byte[] function5Through8Packet(int address, boolean longAddr, boolean f5, boolean f6, boolean f7, boolean f8) {
        byte[] retVal;
        log.debug("f5 through f8 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 0xB0 | (f8 ? 8 : 0) | (f7 ? 4 : 0) | (f6 ? 2 : 0) | (f5 ? 1 : 0);
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1])};
        return retVal;
    }

    public static byte[] function9Through12Packet(int address, boolean longAddr, boolean f9, boolean f10, boolean f11, boolean f12) {
        byte[] retVal;
        log.debug("f9 through f12 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 0xA0 | (f12 ? 8 : 0) | (f11 ? 4 : 0) | (f10 ? 2 : 0) | (f9 ? 1 : 0);
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1] ^ retVal[2])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(retVal[0] ^ retVal[1])};
        return retVal;
    }

    public static byte[] function13Through20Packet(int address, boolean longAddr, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        log.debug("f13 through f20 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 222;
        int arg2 = (f20 ? 128 : 0) | (f19 ? 64 : 0) | (f18 ? 32 : 0) | (f17 ? 16 : 0) | (f16 ? 8 : 0) | (f15 ? 4 : 0) | (f14 ? 2 : 0) | (f13 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function21Through28Packet(int address, boolean longAddr, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        log.debug("f21 through f28 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 223;
        int arg2 = (f28 ? 128 : 0) | (f27 ? 64 : 0) | (f26 ? 32 : 0) | (f25 ? 16 : 0) | (f24 ? 8 : 0) | (f23 ? 4 : 0) | (f22 ? 2 : 0) | (f21 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function29Through36Packet(int address, boolean longAddr, boolean f29, boolean f30, boolean f31, boolean f32, boolean f33, boolean f34, boolean f35, boolean f36) {
        log.debug("f29 through f36 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 216;
        int arg2 = (f36 ? 128 : 0) | (f35 ? 64 : 0) | (f34 ? 32 : 0) | (f33 ? 16 : 0) | (f32 ? 8 : 0) | (f31 ? 4 : 0) | (f30 ? 2 : 0) | (f29 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function37Through44Packet(int address, boolean longAddr, boolean f37, boolean f38, boolean f39, boolean f40, boolean f41, boolean f42, boolean f43, boolean f44) {
        log.debug("f37 through f44 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 217;
        int arg2 = (f44 ? 128 : 0) | (f43 ? 64 : 0) | (f42 ? 32 : 0) | (f41 ? 16 : 0) | (f40 ? 8 : 0) | (f39 ? 4 : 0) | (f38 ? 2 : 0) | (f37 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function45Through52Packet(int address, boolean longAddr, boolean f45, boolean f46, boolean f47, boolean f48, boolean f49, boolean f50, boolean f51, boolean f52) {
        log.debug("f45 through f52 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 218;
        int arg2 = (f52 ? 128 : 0) | (f51 ? 64 : 0) | (f50 ? 32 : 0) | (f49 ? 16 : 0) | (f48 ? 8 : 0) | (f47 ? 4 : 0) | (f46 ? 2 : 0) | (f45 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function53Through60Packet(int address, boolean longAddr, boolean f53, boolean f54, boolean f55, boolean f56, boolean f57, boolean f58, boolean f59, boolean f60) {
        log.debug("f53 through f60 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 219;
        int arg2 = (f60 ? 128 : 0) | (f59 ? 64 : 0) | (f58 ? 32 : 0) | (f57 ? 16 : 0) | (f56 ? 8 : 0) | (f55 ? 4 : 0) | (f54 ? 2 : 0) | (f53 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] function61Through68Packet(int address, boolean longAddr, boolean f61, boolean f62, boolean f63, boolean f64, boolean f65, boolean f66, boolean f67, boolean f68) {
        log.debug("f61 through f68 packet {}", (Object)address);
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 220;
        int arg2 = (f68 ? 128 : 0) | (f67 ? 64 : 0) | (f66 ? 32 : 0) | (f65 ? 16 : 0) | (f64 ? 8 : 0) | (f63 ? 4 : 0) | (f62 ? 2 : 0) | (f61 ? 1 : 0);
        return NmraPacket.twoBytePacket(address, longAddr, (byte)arg1, (byte)arg2);
    }

    public static byte[] analogControl(int address, boolean longAddr, int function, int value) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        int arg1 = 61;
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(function & 0xFF), (byte)(value & 0xFF), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3] ^ retVal[4])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(function & 0xFF), (byte)(value & 0xFF), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])};
        return retVal;
    }

    public static byte[] consistControl(int address, boolean longAddr, int consist, boolean directionNormal) {
        byte[] retVal;
        if (!NmraPacket.addressCheck(address, longAddr)) {
            return null;
        }
        if (!NmraPacket.addressCheck(consist, false)) {
            return null;
        }
        int arg1 = 16;
        arg1 = directionNormal ? (arg1 |= 2) : (arg1 |= 3);
        retVal = longAddr ? new byte[]{(byte)(192 + (address / 256 & 0x3F)), (byte)(address & 0xFF), (byte)arg1, (byte)(consist & 0xFF), (byte)(retVal[0] ^ retVal[1] ^ retVal[2] ^ retVal[3])} : new byte[]{(byte)(address & 0xFF), (byte)arg1, (byte)(consist & 0xFF), (byte)(retVal[0] ^ retVal[1] ^ retVal[2])};
        return retVal;
    }

    public static boolean addressCheck(int address, boolean longAddr) {
        if (address < 0) {
            log.error("invalid address {}", (Object)address);
            return false;
        }
        if (longAddr && address > 10239) {
            log.error("invalid address {}", (Object)address);
            return false;
        }
        if (!longAddr && address > 127) {
            log.error("invalid address {}", (Object)address);
            return false;
        }
        return true;
    }

    public static DccAddressType extractAddressType(byte[] packet) {
        if (packet[0] == 0) {
            return DccAddressType.BROADCAST;
        }
        if ((packet[0] & 0xFF) == 255) {
            return DccAddressType.IDLE;
        }
        if ((0x80 & packet[0]) == 0) {
            return DccAddressType.LOCO_SHORT_ADDRESS;
        }
        if ((0xC0 & packet[0]) == 192) {
            return DccAddressType.LOCO_LONG_ADDRESS;
        }
        if ((0xC0 & packet[0]) == 128) {
            return DccAddressType.ACCESSORY_ADDRESS;
        }
        return DccAddressType.NO_ADDRESS;
    }

    public static int extractAddressNumber(byte[] packet) {
        switch (NmraPacket.extractAddressType(packet)) {
            case BROADCAST: {
                return 0;
            }
            case NO_ADDRESS: 
            case IDLE: {
                return -1;
            }
            case LOCO_SHORT_ADDRESS: {
                return packet[0] & 0xFF;
            }
            case LOCO_LONG_ADDRESS: {
                return (packet[0] & 0x3F) << 8 | packet[1] & 0xFF;
            }
            case ACCESSORY_ADDRESS: {
                if (NmraPacket.isAccSignalDecoderPkt(packet)) {
                    return NmraPacket.getAccSignalDecoderPktAddress(packet);
                }
                return NmraPacket.getAccDecoderPktAddress(packet);
            }
        }
        log.error("Unhandled address type {}", (Object)NmraPacket.extractAddressType(packet));
        return -1;
    }

    public static int extractInstruction(byte[] packet) {
        switch (NmraPacket.extractAddressType(packet)) {
            case BROADCAST: 
            case NO_ADDRESS: 
            case IDLE: 
            case LOCO_SHORT_ADDRESS: {
                return packet[1] & 0xFF;
            }
            case LOCO_LONG_ADDRESS: 
            case ACCESSORY_ADDRESS: {
                return packet[2] & 0xFF;
            }
        }
        log.warn("Unhandled address type: {}", (Object)NmraPacket.extractAddressType(packet));
        return 0;
    }

    public static String format(byte[] p) {
        return StringUtil.hexStringFromBytes(p);
    }

    public static String toString(byte[] p) throws IllegalArgumentException {
        if (p == null || p.length == 0) {
            throw new IllegalArgumentException("Content required");
        }
        return Bundle.getMessage("DccToStringFormat", new Object[]{NmraPacket.extractAddressType(p), NmraPacket.extractInstruction(p), NmraPacket.extractAddressNumber(p)});
    }

    private NmraPacket() {
    }

    public static enum DccAddressType {
        NO_ADDRESS,
        BROADCAST,
        IDLE,
        LOCO_SHORT_ADDRESS,
        LOCO_LONG_ADDRESS,
        ACCESSORY_ADDRESS;

    }
}

