/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jmri.BeanSetting;
import jmri.Block;
import jmri.Bundle;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path
implements Comparable<Path> {
    public static final int NONE = 0;
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 64;
    public static final int WEST = 128;
    public static final int NORTH_EAST = 80;
    public static final int SOUTH_EAST = 96;
    public static final int SOUTH_WEST = 160;
    public static final int NORTH_WEST = 144;
    public static final int CW = 256;
    public static final int CCW = 512;
    public static final int LEFT = 1024;
    public static final int RIGHT = 2048;
    public static final int UP = 4096;
    public static final int DOWN = 8192;
    private final ArrayList<BeanSetting> _beans = new ArrayList();
    private Block _block;
    private int _toBlockDirection;
    private int _fromBlockDirection;
    private float _length = 0.0f;
    private static final Logger log = LoggerFactory.getLogger(Path.class);

    public Path() {
    }

    public Path(Block dest, int toBlockDirection, int fromBlockDirection) {
        this();
        this._toBlockDirection = toBlockDirection;
        this._fromBlockDirection = fromBlockDirection;
        this.setBlock(dest);
    }

    public Path(Block dest, int toBlockDirection, int fromBlockDirection, BeanSetting setting) {
        this(dest, toBlockDirection, fromBlockDirection);
        this.addSetting(setting);
    }

    public void addSetting(BeanSetting t) {
        this._beans.add(t);
    }

    public List<BeanSetting> getSettings() {
        return this._beans;
    }

    public void removeSetting(BeanSetting t) {
        this._beans.remove(t);
    }

    public void clearSettings() {
        for (int i = this._beans.size(); i > 0; --i) {
            this._beans.remove(i - 1);
        }
    }

    public void setBlock(Block b) {
        this._block = b;
    }

    public Block getBlock() {
        return this._block;
    }

    public int getToBlockDirection() {
        return this._toBlockDirection;
    }

    public void setToBlockDirection(int d) {
        this._toBlockDirection = d;
    }

    public int getFromBlockDirection() {
        return this._fromBlockDirection;
    }

    public void setFromBlockDirection(int d) {
        this._fromBlockDirection = d;
    }

    public boolean checkPathSet() {
        if (this._beans.isEmpty()) {
            return true;
        }
        for (BeanSetting bean : this._beans) {
            if (bean.check()) continue;
            return false;
        }
        return true;
    }

    public static String decodeDirection(int d) {
        if (d == 0) {
            return Bundle.getMessage("None");
        }
        StringBuffer b = new StringBuffer();
        if ((d & 0x10) != 0 && (d & 0x40) != 0) {
            Path.appendOne(b, Bundle.getMessage("NorthEast"));
        } else if ((d & 0x10) != 0 && (d & 0x80) != 0) {
            Path.appendOne(b, Bundle.getMessage("NorthWest"));
        } else if ((d & 0x20) != 0 && (d & 0x40) != 0) {
            Path.appendOne(b, Bundle.getMessage("SouthEast"));
        } else if ((d & 0x20) != 0 && (d & 0x80) != 0) {
            Path.appendOne(b, Bundle.getMessage("SouthWest"));
        } else {
            if ((d & 0x10) != 0) {
                Path.appendOne(b, Bundle.getMessage("North"));
            }
            if ((d & 0x20) != 0) {
                Path.appendOne(b, Bundle.getMessage("South"));
            }
            if ((d & 0x40) != 0) {
                Path.appendOne(b, Bundle.getMessage("East"));
            }
            if ((d & 0x80) != 0) {
                Path.appendOne(b, Bundle.getMessage("West"));
            }
        }
        if ((d & 0x100) != 0) {
            Path.appendOne(b, Bundle.getMessage("Clockwise"));
        }
        if ((d & 0x200) != 0) {
            Path.appendOne(b, Bundle.getMessage("CounterClockwise"));
        }
        if ((d & 0x400) != 0) {
            Path.appendOne(b, Bundle.getMessage("Leftward"));
        }
        if ((d & 0x800) != 0) {
            Path.appendOne(b, Bundle.getMessage("Rightward"));
        }
        if ((d & 0x1000) != 0) {
            Path.appendOne(b, Bundle.getMessage("ButtonUp"));
        }
        if ((d & 0x2000) != 0) {
            Path.appendOne(b, Bundle.getMessage("ButtonDown"));
        }
        int mask = 16368;
        if ((d & 0xFFFFC00F) != 0) {
            Path.appendOne(b, "Unknown: 0x" + Integer.toHexString(d & 0xFFFFC00F));
        }
        return b.toString();
    }

    public void setLength(float l) {
        this._length = l;
    }

    public float getLength() {
        return this._length;
    }

    public float getLengthMm() {
        if (this._length <= 0.0f) {
            return this._block.getLengthMm();
        }
        return this._length;
    }

    public float getLengthCm() {
        if (this._length <= 0.0f) {
            return this._block.getLengthCm();
        }
        return this._length / 10.0f;
    }

    public float getLengthIn() {
        if (this._length <= 0.0f) {
            return this._block.getLengthIn();
        }
        return this._length / 25.4f;
    }

    private static void appendOne(StringBuffer b, String t) {
        if (b.length() != 0) {
            b.append(", ");
        }
        b.append(t);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="equals operator should actually check for equality")
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path p = (Path)obj;
        if (!Float.valueOf(p._length).equals(Float.valueOf(this._length))) {
            return false;
        }
        if (p._toBlockDirection != this._toBlockDirection) {
            return false;
        }
        if (p._fromBlockDirection != this._fromBlockDirection) {
            return false;
        }
        if (p._block == null && this._block != null) {
            return false;
        }
        if (p._block != null && this._block == null) {
            return false;
        }
        if (p._block != null && this._block != null && !p._block.equals(this._block)) {
            return false;
        }
        if (p._beans.size() != this._beans.size()) {
            return false;
        }
        for (int i = 0; i < p._beans.size(); ++i) {
            if (p._beans.get(i).equals(this._beans.get(i))) continue;
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (BeanSetting beanSetting : this.getSettings()) {
            result.append(separator).append(MessageFormat.format("{0} with state {1}", beanSetting.getBean().getDisplayName(), beanSetting.getBean().describeState(beanSetting.getSetting())));
            separator = ", ";
        }
        if (this.getBlock() != null) {
            return MessageFormat.format("Path: \"{0}\" ({1}): {2}", this.getBlock().getDisplayName(), Path.decodeDirection(this.getToBlockDirection()), result);
        }
        return MessageFormat.format("Path: <no block>: {0}", result);
    }

    @Override
    public int compareTo(Path obj) {
        int retval;
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            throw new NullPointerException("null argument to compareTo");
        }
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("argument of improper type");
        }
        if (obj.getBlock() != null && this.getBlock() != null && (retval = this.getBlock().compareTo(obj.getBlock())) != 0) {
            return retval;
        }
        if ((double)((int)this._length - (int)obj._length) != 0.0) {
            return (int)this._length - (int)obj._length;
        }
        if (this._toBlockDirection != obj._toBlockDirection) {
            return this._toBlockDirection - obj._toBlockDirection;
        }
        if (this._fromBlockDirection != obj._fromBlockDirection) {
            return this._fromBlockDirection - obj._fromBlockDirection;
        }
        if (this._beans.size() != obj._beans.size()) {
            return this._beans.size() - obj._beans.size();
        }
        for (int i = 0; i < obj._beans.size(); ++i) {
            BeanSetting bs1 = this._beans.get(i);
            BeanSetting bs2 = obj._beans.get(i);
            retval = bs1.getBean().compareTo(bs2.getBean());
            if (retval != 0) {
                return retval;
            }
            if (bs1.getSetting() == bs2.getSetting()) continue;
            return bs1.getSetting() - bs2.getSetting();
        }
        return this.hashCode() - obj.hashCode();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this._beans);
        hash = 89 * hash + Objects.hashCode(this._block);
        hash = 89 * hash + this._toBlockDirection;
        hash = 89 * hash + this._fromBlockDirection;
        hash = 89 * hash + Float.floatToIntBits(this._length);
        return hash;
    }

    public static int computeDirection(Point2D p1, Point2D p2) {
        log.trace("Path.computeDirection({}, {})", (Object)p1, (Object)p2);
        double angleDEG = MathUtil.computeAngleDEG(p2, p1);
        angleDEG = MathUtil.wrap360(angleDEG);
        int octant = (int)Math.round(angleDEG / 45.0);
        int[] dirs = new int[]{32, 96, 64, 80, 16, 144, 128, 160, 32};
        if (log.isTraceEnabled()) {
            log.trace("   returns {} ({})", (Object)dirs[octant], (Object)Path.decodeDirection(dirs[octant]));
        }
        return dirs[octant];
    }

    public static int reverseDirection(int inDir) {
        switch (inDir) {
            case 16: {
                return 32;
            }
            case 80: {
                return 160;
            }
            case 64: {
                return 128;
            }
            case 96: {
                return 144;
            }
            case 32: {
                return 16;
            }
            case 160: {
                return 80;
            }
            case 128: {
                return 64;
            }
            case 144: {
                return 96;
            }
        }
        return 0;
    }
}

