/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.Locale;
import jmri.Bundle;
import jmri.JmriException;
import jmri.Permission;
import jmri.PermissionOwner;
import jmri.PermissionValue;
import jmri.Role;
import jmri.User;

public interface PermissionManager {
    public Role addRole(String var1) throws RoleAlreadyExistsException;

    public void removeRole(String var1) throws RoleDoesNotExistException;

    public User addUser(String var1, String var2) throws UserAlreadyExistsException;

    public void removeUser(String var1) throws UserDoesNotExistException;

    public void changePassword(String var1, String var2);

    public boolean login(String var1, String var2);

    public boolean remoteLogin(StringBuilder var1, Locale var2, String var3, String var4);

    public void logout();

    public void remoteLogout(String var1);

    public boolean isLoggedIn();

    public boolean isRemotelyLoggedIn(String var1);

    public boolean isCurrentUser(String var1);

    public boolean isCurrentUser(User var1);

    public String getCurrentUserName();

    public boolean isCurrentUserPermittedToChangePassword();

    public boolean isAGuestUser(String var1);

    public boolean isAGuestUser(User var1);

    public void addLoginListener(LoginListener var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isAllowEmptyPasswords();

    public void setAllowEmptyPasswords(boolean var1);

    public boolean hasAtLeastPermission(Permission var1, PermissionValue var2);

    public boolean hasAtLeastRemotePermission(String var1, Permission var2, PermissionValue var3);

    public boolean ensureAtLeastPermission(Permission var1, PermissionValue var2);

    public void registerOwner(PermissionOwner var1);

    public void registerPermission(Permission var1);

    public void storePermissionSettings();

    public static class BadPasswordException
    extends JmriException {
        public BadPasswordException() {
            super(Bundle.getMessage("PermissionManager_BadPasswordException"));
        }
    }

    public static class BadUserOrPasswordException
    extends JmriException {
        public BadUserOrPasswordException() {
            super(Bundle.getMessage("PermissionManager_BadUserOrPasswordException"));
        }
    }

    public static class UserDoesNotExistException
    extends JmriException {
        public UserDoesNotExistException() {
            super(Bundle.getMessage("PermissionManager_UserDoesNotExistException"));
        }
    }

    public static class UserAlreadyExistsException
    extends JmriException {
        public UserAlreadyExistsException() {
            super(Bundle.getMessage("PermissionManager_UserAlreadyExistsException"));
        }
    }

    public static class RoleDoesNotExistException
    extends JmriException {
        public RoleDoesNotExistException() {
            super(Bundle.getMessage("PermissionManager_RoleDoesNotExistException"));
        }
    }

    public static class RoleAlreadyExistsException
    extends JmriException {
        public RoleAlreadyExistsException() {
            super(Bundle.getMessage("PermissionManager_RoleAlreadyExistsException"));
        }
    }

    public static interface LoginListener {
        public void loginLogout(boolean var1);
    }
}

