/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import jmri.BooleanPermission;
import jmri.Bundle;
import jmri.Permission;
import jmri.PermissionFactory;
import jmri.PermissionManager;
import jmri.PermissionOwner;
import jmri.Role;

public class PermissionsSystemAdmin {
    public static final PermissionOwner PERMISSION_OWNER_SYSTEM_ADMIN = new PermissionOwnerSystemAdmin();
    public static final Permission PERMISSION_EDIT_PREFERENCES = new PermissionEditPreferences();
    public static final Permission PERMISSION_EDIT_PERMISSIONS = new PermissionEditPermissions();
    public static final Permission PERMISSION_EDIT_OWN_PASSWORD = new PermissionEditOwnPassword();

    private PermissionsSystemAdmin() {
    }

    public static class PermissionEditOwnPassword
    implements BooleanPermission {
        @Override
        public PermissionOwner getOwner() {
            return PERMISSION_OWNER_SYSTEM_ADMIN;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("PermissionsSystemAdmin_PermissionChangeOwnPassword");
        }

        @Override
        public BooleanPermission.BooleanValue getDefaultPermission(Role role) {
            return BooleanPermission.BooleanValue.get(role.isAdminRole() || role.isStandardUserRole());
        }
    }

    public static class PermissionEditPreferences
    implements BooleanPermission {
        @Override
        public PermissionOwner getOwner() {
            return PERMISSION_OWNER_SYSTEM_ADMIN;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("PermissionsSystemAdmin_PermissionEditPreferences");
        }

        @Override
        public BooleanPermission.BooleanValue getDefaultPermission(Role role) {
            return BooleanPermission.BooleanValue.get(role.isAdminRole());
        }
    }

    public static class PermissionEditPermissions
    implements BooleanPermission {
        @Override
        public PermissionOwner getOwner() {
            return PERMISSION_OWNER_SYSTEM_ADMIN;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("PermissionsSystemAdmin_PermissionEditPermissions");
        }

        @Override
        public BooleanPermission.BooleanValue getDefaultPermission(Role role) {
            return BooleanPermission.BooleanValue.get(role.isAdminRole());
        }
    }

    public static class PermissionOwnerSystemAdmin
    implements PermissionOwner {
        @Override
        public String getName() {
            return Bundle.getMessage("PermissionsSystemAdmin_PermissionOwnerSystemAdmin");
        }
    }

    public static class Factory
    implements PermissionFactory {
        @Override
        public void register(PermissionManager manager) {
            manager.registerOwner(PERMISSION_OWNER_SYSTEM_ADMIN);
            manager.registerPermission(PERMISSION_EDIT_PREFERENCES);
            manager.registerPermission(PERMISSION_EDIT_PERMISSIONS);
            manager.registerPermission(PERMISSION_EDIT_OWN_PASSWORD);
        }
    }
}

