/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.Turnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushbuttonPacket {
    public static final String unknown = "None";
    public static final String NCEname = "NCE_Rev_C";
    public static final String CVP_1Bname = "CVP_AD4_1B";
    public static final String CVP_2Bname = "CVP_AD4_2B";
    private static final String[] VALIDDECODERNAMES = new String[]{"None", "NCE_Rev_C", "CVP_AD4_1B", "CVP_AD4_2B"};
    private static final Logger log = LoggerFactory.getLogger(PushbuttonPacket.class);

    @Nonnull
    public static byte[] pushbuttonPkt(@Nonnull String prefix, int turnoutNum, boolean locked) {
        Turnout t = InstanceManager.turnoutManagerInstance().getBySystemName(prefix + turnoutNum);
        if (t == null || t.getDecoderName() == null) {
            throw new IllegalArgumentException("No turnout or turnout decoder name");
        }
        if (unknown.equals(t.getDecoderName())) {
            throw new IllegalArgumentException("Turnout decoder name is unknown");
        }
        if (NCEname.equals(t.getDecoderName())) {
            byte[] bl = locked ? NmraPacket.accDecoderPktOpsMode(turnoutNum, 556, 1) : NmraPacket.accDecoderPktOpsMode(turnoutNum, 556, 0);
            if (bl == null) {
                throw new IllegalArgumentException("No valid DCC packet address");
            }
            return bl;
        }
        if (CVP_1Bname.equals(t.getDecoderName()) || CVP_2Bname.equals(t.getDecoderName())) {
            int CVdata = PushbuttonPacket.CVPturnoutLockout(prefix, turnoutNum);
            byte[] bl = NmraPacket.accDecoderPktOpsModeLegacy(turnoutNum, 514, CVdata);
            if (bl == null) {
                throw new IllegalArgumentException("No valid DCC packet address");
            }
            return bl;
        }
        log.error("Invalid decoder name for turnout {}", (Object)turnoutNum);
        throw new IllegalArgumentException("Illegal decoder name");
    }

    @Nonnull
    public static String[] getValidDecoderNames() {
        String[] arrayCopy = new String[VALIDDECODERNAMES.length];
        System.arraycopy(VALIDDECODERNAMES, 0, arrayCopy, 0, VALIDDECODERNAMES.length);
        return arrayCopy;
    }

    private static int CVPturnoutLockout(@Nonnull String prefix, int turnoutNum) {
        int CVdata = 0;
        int oneButton = 1;
        int twoButton = 3;
        int modTurnoutNum = turnoutNum - 1 & 0xFFC;
        for (int i = 0; i < 4; ++i) {
            int button = oneButton;
            Turnout t = InstanceManager.turnoutManagerInstance().getBySystemName(prefix + ++modTurnoutNum);
            if (t != null && t.getDecoderName() != null) {
                if (!CVP_1Bname.equals(t.getDecoderName())) {
                    if (CVP_2Bname.equals(t.getDecoderName())) {
                        button = twoButton;
                    } else {
                        log.warn("Turnout {}, all CVP turnouts on one decoder should be CVP_AD4_1B or CVP_AD4_2B", (Object)modTurnoutNum);
                    }
                }
                if (t.getLocked(2)) {
                    button = 0;
                }
            }
            CVdata += button;
            oneButton <<= 2;
            twoButton <<= 2;
        }
        return CVdata;
    }
}

