/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.beans.PropertyVetoException;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.ScaleManager;
import jmri.beans.ConstrainedBean;
import jmri.configurexml.ScaleConfigXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scale
extends ConstrainedBean {
    private String _name = "HO";
    private String _userName = "HO";
    private double _ratio = 87.1;
    private double _factor = 0.011481056257175661;
    private static final Logger log = LoggerFactory.getLogger(Scale.class);

    public Scale() {
    }

    public Scale(@Nonnull String name, double ratio, String userName) {
        this._name = name;
        this._userName = userName == null ? name : userName;
        this._ratio = ratio;
        this._factor = 1.0 / this._ratio;
    }

    public String getScaleName() {
        return this._name;
    }

    public String getUserName() {
        return this._userName;
    }

    public double getScaleRatio() {
        return this._ratio;
    }

    public double getScaleFactor() {
        return this._factor;
    }

    public void setUserName(@Nonnull String newName) throws IllegalArgumentException, PropertyVetoException {
        for (Scale scale : ScaleManager.getScales()) {
            if (!scale.getUserName().equals(newName) || scale.getScaleName().equals(this._name)) continue;
            throw new IllegalArgumentException("Duplicate scale user name: " + newName);
        }
        String oldName = this._userName;
        this._userName = newName;
        try {
            this.fireVetoableChange("ScaleUserName", oldName, newName);
        }
        catch (PropertyVetoException ex) {
            log.warn("The user name change for {} scale to {} was rejected: Reason: {}", new Object[]{this._name, this._userName, ex.getMessage()});
            this._userName = oldName;
            throw ex;
        }
        ScaleConfigXML.doStore();
    }

    public void setScaleRatio(double newRatio) throws IllegalArgumentException, PropertyVetoException {
        if (newRatio < 1.0) {
            throw new IllegalArgumentException("The scale ratio is less than 1");
        }
        double oldRatio = this._ratio;
        this._ratio = newRatio;
        this._factor = 1.0 / this._ratio;
        try {
            this.fireVetoableChange("ScaleRatio", oldRatio, newRatio);
        }
        catch (PropertyVetoException ex) {
            log.warn("The ratio change for {} scale to {} was rejected: Reason: {}", new Object[]{this._name, this._ratio, ex.getMessage()});
            this._ratio = oldRatio;
            this._factor = 1.0 / oldRatio;
            throw ex;
        }
        ScaleConfigXML.doStore();
    }

    public String toString() {
        return String.format(Locale.getDefault(), "%s (%.1f)", this.getUserName(), this.getScaleRatio());
    }
}

