/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import jmri.Scale;
import jmri.configurexml.ScaleConfigXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleManager {
    private static final HashMap<String, Scale> _scaleMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ScaleManager.class);

    private ScaleManager() {
    }

    private static void fillMap() {
        if (!ScaleConfigXML.doLoad()) {
            ScaleManager.addScale("HO", "HO", 87.1);
            ScaleManager.addScale("N", "N", 160.0);
        }
        log.debug("ScaleManager initialized");
    }

    private static void fillScaleMapIfEmpty() {
        if (_scaleMap.isEmpty()) {
            ScaleManager.fillMap();
        }
    }

    public static void addScale(String scaleName, String userName, double scaleRatio) {
        _scaleMap.put(scaleName, new Scale(scaleName, scaleRatio, userName));
    }

    public static Scale getScale(@Nonnull String name) {
        ScaleManager.fillScaleMapIfEmpty();
        return _scaleMap.get(name);
    }

    public static ArrayList<Scale> getScales() {
        ScaleManager.fillScaleMapIfEmpty();
        ArrayList<Scale> list = new ArrayList<Scale>();
        for (Scale scale : _scaleMap.values()) {
            list.add(scale);
        }
        Collections.sort(list, (o1, o2) -> o1.getUserName().compareTo(o2.getUserName()));
        return list;
    }

    public static Scale getScaleByName(@Nonnull String name) {
        ScaleManager.fillScaleMapIfEmpty();
        for (Scale scale : _scaleMap.values()) {
            if (!scale.getUserName().equals(name)) continue;
            return scale;
        }
        return _scaleMap.get(name);
    }
}

