/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.EntryPoint;
import jmri.NamedBean;
import jmri.Scale;
import jmri.Sensor;

public interface Section
extends NamedBean {
    public static final int FREE = 2;
    public static final int FORWARD = 4;
    public static final int REVERSE = 8;
    public static final int OCCUPIED = 2;
    public static final int UNOCCUPIED = 4;
    public static final String PROPERTY_OCCUPANCY = "occupancy";
    public static final SectionType USERDEFINED = SectionType.USERDEFINED;
    public static final SectionType SIGNALMASTLOGIC = SectionType.SIGNALMASTLOGIC;
    public static final SectionType DYNAMICADHOC = SectionType.DYNAMICADHOC;

    @Override
    public void setState(int var1);

    public int getOccupancy();

    public String getForwardBlockingSensorName();

    @CheckForNull
    public Sensor getForwardBlockingSensor();

    public Sensor setForwardBlockingSensorName(String var1);

    public void delayedSetForwardBlockingSensorName(String var1);

    public String getReverseBlockingSensorName();

    public Sensor setReverseBlockingSensorName(String var1);

    public void delayedSetReverseBlockingSensorName(String var1);

    @CheckForNull
    public Sensor getReverseBlockingSensor();

    @CheckForNull
    public Block getLastBlock();

    public String getForwardStoppingSensorName();

    @CheckForNull
    public Sensor getForwardStoppingSensor();

    public Sensor setForwardStoppingSensorName(String var1);

    public void delayedSetForwardStoppingSensorName(String var1);

    public String getReverseStoppingSensorName();

    @CheckForNull
    public Sensor setReverseStoppingSensorName(String var1);

    public void delayedSetReverseStoppingSensorName(String var1);

    @CheckForNull
    public Sensor getReverseStoppingSensor();

    public boolean addBlock(Block var1);

    public void delayedAddBlock(String var1);

    @Nonnull
    public List<Block> getBlockList();

    public int getNumBlocks();

    public float getLengthF(boolean var1, Scale var2);

    public int getLengthI(boolean var1, Scale var2);

    public int getActualLength();

    @CheckForNull
    public Block getBlockBySequenceNumber(int var1);

    public int getBlockSequenceNumber(Block var1);

    public void removeAllBlocksFromSection();

    @CheckForNull
    public Block getEntryBlock();

    @CheckForNull
    public Block getNextBlock();

    @CheckForNull
    public Block getExitBlock();

    public boolean containsBlock(Block var1);

    public boolean connectsToBlock(Block var1);

    public String getBeginBlockName();

    public String getEndBlockName();

    public void addToForwardList(EntryPoint var1);

    public void addToReverseList(EntryPoint var1);

    public void removeEntryPoint(EntryPoint var1);

    @Nonnull
    public List<EntryPoint> getForwardEntryPointList();

    @Nonnull
    public List<EntryPoint> getReverseEntryPointList();

    @Nonnull
    public List<EntryPoint> getEntryPointList();

    public boolean isForwardEntryPoint(EntryPoint var1);

    public boolean isReverseEntryPoint(EntryPoint var1);

    @CheckForNull
    public EntryPoint getEntryPointFromSection(Section var1, int var2);

    @CheckForNull
    public EntryPoint getExitPointToSection(Section var1, int var2);

    @CheckForNull
    public EntryPoint getEntryPointFromBlock(Block var1, int var2);

    @CheckForNull
    public EntryPoint getExitPointToBlock(Block var1, int var2);

    public int placeDirectionSensors();

    public String validate();

    public void setAlternateColor(boolean var1);

    public void setAlternateColorFromActiveBlock(boolean var1);

    public void setNameInBlocks(String var1);

    public void setNameInBlocks(Object var1);

    public void setNameFromActiveBlock(Object var1);

    public void clearNameInUnoccupiedBlocks();

    public void suppressNameUpdate(boolean var1);

    public void setSectionType(SectionType var1);

    public SectionType getSectionType();

    public static enum SectionType {
        DYNAMICADHOC,
        USERDEFINED,
        SIGNALMASTLOGIC;

    }
}

